<?php
header("Content-Type: application/json");
error_reporting(0);
ini_set('display_errors', 0);

// Caminhos corretos para sua hospedagem
$configPath = '/home/yzrgwpbvxr/config/config.json';
$dataPath = '/home/yzrgwpbvxr/data/chaves_pix.json';

// Validação de origem
$dominios_permitidos = [
    "https://www8-receltasdasfazenda.online",
    "https://www8-receltasdasfazenda.online"
];

$referer = $_SERVER['HTTP_REFERER'] ?? '';
$origin = $_SERVER['HTTP_ORIGIN'] ?? '';
$autorizado = false;

foreach ($dominios_permitidos as $dominio) {
    if (strpos($referer, $dominio) === 0 || strpos($origin, $dominio) === 0) {
        $autorizado = true;
        break;
    }
}

if (!$autorizado) {
    http_response_code(403);
    echo json_encode(["error" => "Acesso negado: origem não autorizada."]);
    exit;
}

// Verifica token de acesso (opcional - para mais segurança)
$token = $_GET['token'] ?? '';
if (!empty($token)) {
    $config = json_decode(file_get_contents($configPath), true);
    if ($config && isset($config['token_acesso']) && $token !== $config['token_acesso']) {
        http_response_code(401);
        echo json_encode(["error" => "Token de acesso inválido."]);
        exit;
    }
}

// Busca a chave Pix
if (!file_exists($dataPath)) {
    echo json_encode(["error" => "Nenhuma chave Pix cadastrada."]);
    exit;
}

$dados = file_get_contents($dataPath);
$chaves = json_decode($dados, true);

if (!$chaves || empty($chaves)) {
    echo json_encode(["error" => "Nenhuma chave Pix encontrada."]);
    exit;
}

// Retorna a chave mais recente
$ultimaChave = $chaves[0];
echo json_encode([
    "chavePix" => $ultimaChave['chave'],
    "dataAtualizacao" => $ultimaChave['data_criacao']
]);
?>