// Recupera os itens do carrinho do localStorage
const cartItems = JSON.parse(localStorage.getItem('cartItems')) || [];
const cartItemsContainer = document.getElementById('cart-items');
const itemCountElement = document.getElementById('item-count');
const totalPriceElement = document.getElementById('total-price');

// Atualiza os itens no carrinho
function renderCart() {
    cartItemsContainer.innerHTML = ''; // Limpa o conteúdo anterior
    let total = 0;

    cartItems.forEach((item, index) => {
        const cartItem = document.createElement('div');
        cartItem.className = 'cart-item';

        cartItem.innerHTML = `
            <img src="${item.image}" alt="Produto">
            <div class="cart-item-details">
                <h3>${item.title}</h3>
                <p>Código do produto: ${item.code || '---'}</p>
                <p>Vendido por: Magalu</p>
                <div class="quantity-selector">
                    <label for="quantity-${index}">Quantidade:</label>
                    <select id="quantity-${index}" onchange="updateQuantity(${index}, this.value)">
                        ${Array.from({ length: 10 }, (_, i) => 
                            `<option value="${i + 1}" ${i + 1 === item.quantity ? 'selected' : ''}>${i + 1}</option>`
                        ).join('')}
                    </select>
                </div>
            </div>
            <div class="cart-item-price">R$ ${(item.price * item.quantity).toFixed(2)}</div>
        `;

        cartItemsContainer.appendChild(cartItem);
        total += item.price * item.quantity;
    });

    itemCountElement.innerText = cartItems.length;
    totalPriceElement.innerText = total.toFixed(2);
}

// Atualiza a quantidade do produto
function updateQuantity(index, quantity) {
    cartItems[index].quantity = parseInt(quantity, 10);
    localStorage.setItem('cartItems', JSON.stringify(cartItems));
    renderCart(); // Re-renderiza o carrinho
}

// Botão "Continuar"
document.getElementById('continue-btn').addEventListener('click', () => {
    alert('Avançando para o próximo passo.');
    // Redirecionamento ou lógica adicional aqui
});

// Renderiza o carrinho ao carregar a página
renderCart();

