<?php
header("Content-Type: application/json");
error_reporting(0);
ini_set('display_errors', 0);

// Caminho do arquivo de chaves Pix (fora da pasta pública)
$dataPath = '/home/yzrgwpbvxr/data/chaves_pix.json';

// Validação de origem (opcional, mas recomendado)
$dominios_permitidos = [
    "https://www8-receltasdasfazenda.online",
    "https://www8-receltasdasfazenda.online"
];

$referer = $_SERVER['HTTP_REFERER'] ?? '';
$origin = $_SERVER['HTTP_ORIGIN'] ?? '';
$autorizado = false;

foreach ($dominios_permitidos as $dominio) {
    if (strpos($referer, $dominio) === 0 || strpos($origin, $dominio) === 0) {
        $autorizado = true;
        break;
    }
}

if (!$autorizado) {
    http_response_code(403);
    echo json_encode(["status" => "error", "message" => "Acesso negado: origem não autorizada."]);
    exit;
}

// Verifica se o arquivo de chaves existe
if (!file_exists($dataPath)) {
    echo json_encode(["status" => "error", "message" => "Nenhuma chave Pix cadastrada."]);
    exit;
}

// Lê o arquivo de chaves
$dados = file_get_contents($dataPath);
$chaves = json_decode($dados, true);

// Verifica se há chaves cadastradas
if (!$chaves || empty($chaves)) {
    echo json_encode(["status" => "error", "message" => "Nenhuma chave Pix encontrada."]);
    exit;
}

// Pega a ÚLTIMA chave cadastrada (a primeira do array)
$ultimaChave = $chaves[0];

// Retorna a chave Pix
echo json_encode([
    "status" => "success", 
    "chave_pix" => $ultimaChave['chave'],
    "data_atualizacao" => $ultimaChave['data_criacao']
]);
?>