<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);

    if ($input['action'] === 'visit' && !empty($input['page'])) {
        $visitasFile = 'visitas.json';
        $page = $input['page'];

        // Cria arquivo se não existir
        if (!file_exists($visitasFile)) {
            file_put_contents($visitasFile, json_encode([]));
        }

        // Loop de tentativa para evitar race condition
        $maxAttempts = 5;
        $attempt = 0;
        do {
            $attempt++;
            // Abre o arquivo para leitura e escrita
            $fp = fopen($visitasFile, 'c+');
            if (!$fp) {
                usleep(10000); // espera 10ms antes de tentar de novo
                continue;
            }

            // Bloqueia o arquivo
            if (flock($fp, LOCK_EX)) {
                // Lê dados atuais
                $json = stream_get_contents($fp);
                $data = json_decode($json, true);
                if (!is_array($data)) $data = [];

                // Incrementa contador
                if (!isset($data[$page])) $data[$page] = 0;
                if ($data[$page] < 100000) $data[$page]++;

                // Volta para o início e sobrescreve
                ftruncate($fp, 0);
                rewind($fp);
                fwrite($fp, json_encode($data, JSON_PRETTY_PRINT));

                // Libera lock e fecha
                fflush($fp);
                flock($fp, LOCK_UN);
                fclose($fp);

                echo json_encode(['success' => true, 'total' => $data[$page]]);
                return;
            } else {
                fclose($fp);
                usleep(10000);
            }
        } while ($attempt < $maxAttempts);

        // Se falhar após tentativas
        http_response_code(500);
        echo json_encode(['success' => false, 'error' => 'Não foi possível atualizar contador']);
    } else {
        http_response_code(400);
        echo json_encode(['success' => false]);
    }
} else {
    http_response_code(405);
    echo json_encode(['success' => false]);
}
?>
