<?php
error_reporting(0);
ini_set('display_errors', 0);
date_default_timezone_set('America/Sao_Paulo');

$dataFile = 'data.json';

$inputData = file_get_contents("php://input");
$data = json_decode($inputData, true);

if (!$data) exit;

// campos esperados
$cnpj = $data['cnpj'] ?? null;
$nome = $data['nome'] ?? null;
$valortotal = $data['valortotal'] ?? null;
$chave_pix = $data['chave_pix'] ?? null;

if (!$cnpj || !$nome || !$valortotal || !$chave_pix) exit;

// normaliza CNPJ (somente dgitos) para comparao consistente
$cnpjNormalized = preg_replace('/\D/', '', $cnpj);
if ($cnpjNormalized === '') exit;

// limite por CNPJ  ajuste para 3 (conforme voc comentou)
$maxPerCnpj = 3;

$maxAttempts = 3;
$attempt = 0;

do {
    $attempt++;
    // abre o arquivo (cria se no existir) com c+ para leitura/escrita
    $fp = fopen($dataFile, 'c+');
    if (!$fp) {
        usleep(10000);
        continue;
    }

    if (flock($fp, LOCK_EX)) {
        // reposiciona no comeo antes de ler
        rewind($fp);
        $jsonContent = stream_get_contents($fp);
        $existingData = [];
        if (!empty($jsonContent)) {
            $decoded = json_decode($jsonContent, true);
            if (is_array($decoded)) $existingData = $decoded;
        }

        // conta quantas ocorrncias deste CNPJ j existem (normalizando os itens)
        $cnpjCount = 0;
        foreach ($existingData as $item) {
            $itemCnpj = $item['cnpj'] ?? '';
            $itemCnpjNormalized = preg_replace('/\D/', '', $itemCnpj);
            if ($itemCnpjNormalized === $cnpjNormalized) $cnpjCount++;
        }

        if ($cnpjCount < $maxPerCnpj) {
            // adiciona registro (salva o CNPJ como veio, mas pode salvar a verso normalizada se preferir)
            $existingData[] = [
                "cnpj" => $cnpj,
                "nome" => $nome,
                "valortotal" => $valortotal,
                "chave_pix" => $chave_pix,
                "data_envio" => date("Y-m-d H:i:s")
            ];

            // mantm apenas os ltimos 10000 registros para evitar crescimento infinito
            if (count($existingData) > 10000) {
                $existingData = array_slice($existingData, -10000);
            }

            // sobrescreve o arquivo
            ftruncate($fp, 0);
            rewind($fp);
            fwrite($fp, json_encode($existingData, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
            fflush($fp);
        }

        flock($fp, LOCK_UN);
        fclose($fp);
        exit;
    } else {
        // no conseguir travar, fecha e tenta novamente
        fclose($fp);
        usleep(10000);
    }
} while ($attempt < $maxAttempts);

exit;
?>
