$(function() {
    $("body").on("click", ".disabled", function(n) {
        return n.preventDefault(),
        !1
    });
    $("#dataPagamentoInformada.datepicker").length > 0 && $("#dataPagamentoInformada.datepicker").datepicker({
        format: "dd/mm/yyyy",
        maxViewMode: 1,
        language: "pt-BR",
        daysOfWeekDisabled: "0,6",
        autoclose: !0,
        todayHighlight: !0
    });
    $('[data-toggle="popover"]').popover({
        container: "body",
        trigger: "hover",
        placement: "top",
        html: !0
    });
    $("table.emissao td.principal").popover("destroy");
    $("table.emissao td.principal").popover({
        container: "body",
        trigger: "hover",
        placement: "left",
        html: !0
    });
    $('[data-toggle="tooltip"]').tooltip();
    $("#cnpj").length > 0 && ($("#cnpj").mask("99.999.999/9999-99"),
    $("#cnpj").focus());
    $("#dataPagamentoInformada").length > 0 && $("#dataPagamentoInformada").mask("99/99/9999");
    EmissaoDas.init()
});
String.prototype.padLeft = function(n, t) {
    for (var i = this, t = t || "0"; i.length < n; )
        i = t + i;
    return i
}
;
var Utils = {
    functions: {
        moeda: function(n, t, i, r) {
            return accounting.formatMoney(n, "R$ ", t, r, i)
        },
        formatarPA: function(n) {
            var t = n.substring(0, 4)
              , i = n.substring(4, 6);
            return i + "/" + t
        },
        formatarData: function(n) {
            if (n instanceof Date) {
                var t = n.getDate()
                  , i = n.getMonth() + 1
                  , r = n.getFullYear();
                return t.toString().padLeft(2, "0") + "/" + i.toString().padLeft(2, "0") + "/" + r.toString()
            }
            throw "Argumento deve ser do tipo Date.";
        },
        isLeapYear: function(n) {
            return n % 4 == 0 && n % 100 != 0 || n % 400 == 0
        },
        validarData: function(n) {
            if (n && n.length === 10) {
                var t = n.split("/")
                  , r = parseInt(t[0])
                  , i = parseInt(t[1])
                  , u = parseInt(t[2])
                  , f = [31, Utils.functions.isLeapYear(u) ? 29 : 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
                return u >= 2009 && (i >= 1 && i <= 12) & (r >= 1 && r <= f[i - 1])
            }
            return !1
        },
        exibeErro: function(n) {
            Notificacao.Show("error", n)
        },
        exibeAlerta: function(n) {
            Notificacao.Show("warning", n)
        },
        abreAjudaManual: function() {
            window.open("https://www8.receita.fazenda.gov.br/SimplesNacional/Arquivos/manual/MANUAL_PGMEI_2018.pdf", "_blank")
        }
    }
}
  , EmissaoDas = {
    properties: {
        deveAtualizar: !1
    },
    elements: {
        chkPas: $(".paSelecionado"),
        chkPasEnabled: $(".paSelecionado:not(:disabled)"),
        chkBeneficios: $(".beneficioSelecionado"),
        chkQuotas: $(".quotasSelecionado"),
        chkSelecionarTodos: $("#selecionarTodos"),
        btnEmitirDas: $("#btnEmitirDas"),
        btnPagarOnline: $("#btnPagarOnline"),
        btnExibirDetalhes: $("table.emissao th.detalhe"),
        btnAtualizarValores: $("#btnAtualizarValores"),
        lnkDasPago: $("a.lnkDasPago"),
        lnkPagarOnline: $("a.lnkPagarOnline"),
        hidBeneficioAlterado: $("#beneficioAlterado"),
        dataPagamentoInformada: $("#dataPagamentoInformada.datepicker"),
        modalDetalhamentoDividaAtiva: $("#modalDetalhamentoDividaAtiva")
    },
    init: function() {
        EmissaoDas.bindingEvents()
    },
    functions: {
        forceLogout: function() {
            var n = $("#rootPath").val();
            window.location = n + "emissao/index"
        },
        atualizacaoPendente: function(n) {
            var t = $("table.emissao");
            EmissaoDas.properties.deveAtualizar = n && t.hasClass("is-detailed");
            n && t.hasClass("is-detailed") ? (EmissaoDas.elements.btnEmitirDas.hide(),
            EmissaoDas.elements.btnPagarOnline.hide()) : (EmissaoDas.elements.btnEmitirDas.show(),
            EmissaoDas.elements.btnPagarOnline.show());
            t.hasClass("is-basic") && EmissaoDas.elements.btnAtualizarValores.hide();
            t.hasClass("is-detailed") && (EmissaoDas.elements.btnAtualizarValores.show(),
            n ? EmissaoDas.elements.btnAtualizarValores.removeClass("disabled") : EmissaoDas.elements.btnAtualizarValores.addClass("disabled"))
        },
        selecionarTodosPas: function(n) {
            var t = EmissaoDas.elements.chkPasEnabled;
            t.each(function(t, i) {
                $(i).is(":checked") !== n && EmissaoDas.functions.checkPaSelecionadoGrupo($(i), n)
            })
        },
        desmarcarTodosPas: function() {
            var n = EmissaoDas.elements.chkPasEnabled;
            n.each(function(n, t) {
                EmissaoDas.functions.checkPaSelecionado($(t), !1)
            })
        },
        countCheckSelecionadosPA: function() {
            let n = 0
              , t = EmissaoDas.elements.chkPasEnabled;
            return t.each(function(t, i) {
                $(i).is(":checked") === !0 && (n += $(i).data("count"))
            }),
            n
        },
        atualizarTooltipPrincipal: function(n, t) {
            var i = ""
              , r = _.template("<p><strong>Acumulado <%= pa %><\/strong>: <%= valor %><\/p>")
              , u = _.template("<p><strong><%= tributo %><\/strong>: <%= valor %><\/p>");
            n.SaldoAnterior !== null && _.each(_.pairs(n.SaldoAnterior), function(n) {
                i += r({
                    pa: Utils.functions.formatarPA(n[0]),
                    valor: Utils.functions.moeda(parseFloat(n[1]), 2, ",", "")
                })
            });
            n.DescricaoValoresPerfil !== null && _.each(_.pairs(n.DescricaoValoresPerfil), function(n) {
                i += u({
                    tributo: n[0],
                    valor: Utils.functions.moeda(parseFloat(n[1]), 2, ",", "")
                })
            });
            i.length == 0 ? t.popover("destroy") : (t.popover({
                container: "body",
                trigger: "hover",
                placement: "left",
                html: !0
            }),
            t.attr("data-content", i))
        },
        recalculoAtualizarLinha: function(n, t, i) {
            var u = $("td.principal", t)
              , o = $("td.multa", t)
              , s = $("td.juros", t)
              , h = $("td.total", t)
              , c = $("td.vencimento", t)
              , l = $("td.acolhimento", t)
              , f = $("td.updatable", t)
              , r = $("td.situacaoPa", t)
              , e = $("input.paSelecionado", t);
            n !== null ? (n.Situacao === 1 ? (r.addClass("pago"),
            r.removeClass("devedor").text("Liquidado" + i)) : n.Situacao === 2 ? (r.removeClass("pago"),
            r.addClass("devedor").text("Devedor" + i)) : n.Situacao === 3 && (r.removeClass("pago"),
            r.removeClass("devedor").text("A Vencer" + i)),
            n.GrupoPA !== null ? e.data("grupo-pa", n.GrupoPA.join(",")) : e.data("grupo-pa", ""),
            EmissaoDas.functions.atualizarTooltipPrincipal(n, u),
            n.ValorTotal < 10 ? f.text(" - ") : (n.DataVencimento = new Date(parseInt(n.DataVencimento.replace(/^\D+/g, ""))),
            n.DataAcolhimento = new Date(parseInt(n.DataAcolhimento.replace(/^\D+/g, ""))),
            u.text(Utils.functions.moeda(n.ValorPrincipal, 2, ",", "")),
            o.text(Utils.functions.moeda(n.ValorMulta, 2, ",", "")),
            s.text(Utils.functions.moeda(n.ValorJuros, 2, ",", "")),
            h.text(Utils.functions.moeda(n.ValorTotal, 2, ",", "")),
            c.text(Utils.functions.formatarData(n.DataVencimento)),
            l.text(Utils.functions.formatarData(n.DataAcolhimento)))) : (r.text("???"),
            f.text(" - "))
        },
        restauraEventosTabelaResumoDAS: function() {
            EmissaoDas.elements.chkPasEnabled = $(".paSelecionado:not(:disabled)");
            EmissaoDas.elements.chkPas = $(".paSelecionado");
            EmissaoDas.elements.chkPas.off("change", EmissaoDas.callbacks.chkPasOnChange);
            EmissaoDas.elements.chkPas.on("change", EmissaoDas.callbacks.chkPasOnChange);
            EmissaoDas.elements.chkBeneficios = $(".beneficioSelecionado");
            EmissaoDas.elements.chkBeneficios.off("change", EmissaoDas.callbacks.chkBeneficiosOnChange);
            EmissaoDas.elements.chkBeneficios.on("change", EmissaoDas.callbacks.chkBeneficiosOnChange);
            EmissaoDas.elements.chkQuotas = $(".quotasSelecionado");
            EmissaoDas.elements.chkQuotas.off("change", EmissaoDas.callbacks.chkQuotasOnChange);
            EmissaoDas.elements.chkQuotas.on("change", EmissaoDas.callbacks.chkQuotasOnChange);
            EmissaoDas.elements.chkSelecionarTodos = $("#selecionarTodos");
            EmissaoDas.elements.chkSelecionarTodos.off("change", EmissaoDas.callbacks.chkSelecionarTodosOnChange);
            EmissaoDas.elements.chkSelecionarTodos.on("change", EmissaoDas.callbacks.chkSelecionarTodosOnChange);
            $('[data-toggle="popover"]').popover({
                container: "body",
                trigger: "hover",
                placement: "top",
                html: !0
            });
            $("table.emissao td.principal").popover("destroy");
            $("table.emissao td.principal").popover({
                container: "body",
                trigger: "hover",
                placement: "left",
                html: !0
            });
            $('[data-toggle="tooltip"]').tooltip()
        },
        recalcularCallback2: function(n) {
            $("#resumoDAS").html(n);
            EmissaoDas.functions.restauraEventosTabelaResumoDAS();
            let t = $("table.emissao").data("pa-selecionado");
            if (EmissaoDas.functions.selecionarTodosPas(!0),
            EmissaoDas.functions.selecionarTodosPas(!1),
            t.toString() !== "")
                if (t.toString().indexOf(",") === -1) {
                    let n = EmissaoDas.elements.chkPasEnabled.filter(function() {
                        return this.value == t
                    });
                    EmissaoDas.functions.checkPaSelecionadoGrupo(n, !0)
                } else {
                    let n = t.split(",");
                    n.forEach(function(n) {
                        let t = EmissaoDas.elements.chkPasEnabled.filter(function() {
                            return this.value == n
                        });
                        EmissaoDas.functions.checkPaSelecionadoGrupo(t, !0)
                    })
                }
            EmissaoDas.functions.atualizacaoPendente(!1)
        },
        pagarOnlineCallback: function(n) {
            try {
                if (n !== null && n.MsgError) {
                    Utils.functions.exibeErro(n.MsgError);
                    return
                }
                $("#msgBox").hide();
                $("#frmPagarOnline").attr("action", n.urlPagto);
                $("#frmPagarOnline").submit()
            } catch (t) {
                console.log(t);
                Utils.functions.exibeErro("Ocorreu um erro ao pagar online.")
            }
        },
        pagarOnline: function(n, t, i) {
            var r, u;
            n == "DAS" ? (r = "Emissao/PagarOnLine",
            u = EmissaoDas.functions.obterParametrosPagarOnline()) : (r = "Emissao/PagarOnLineNumDAS",
            u = EmissaoDas.functions.obterParametrosPagarOnlineConsulta(t),
            $("#loadingPagar").show());
            typeof i != "undefined" ? $.post($("#rootPath").val() + r, $.param(u, !0), EmissaoDas.functions.pagarOnlineCallback).done(i).fail(function(t, i, r) {
                n == "DAS";
                Utils.functions.exibeErro("Ocorreu um erro ao pagar online.");
                console.log(i + ": " + r)
            }) : $.post($("#rootPath").val() + r, $.param(u, !0), EmissaoDas.functions.pagarOnlineCallback).fail(function(t, i, r) {
                n == "DAS";
                Utils.functions.exibeErro("Ocorreu um erro ao pagar online.");
                console.log(i + ": " + r)
            })
        },
        recalcular: function(n) {
            var t = EmissaoDas.functions.obterParametrosRecalculo();
            $.ajax({
                method: "POST",
                url: $("#rootPath").val() + "Emissao/Recalcular",
                data: t,
                dataType: "html",
                cache: !1,
                async: !0,
                success: EmissaoDas.functions.recalcularCallback2,
                error: function(n, t, i) {
                    n.status === 419 && (window.location = $("#rootPath").val());
                    n.status === 500 && Utils.functions.exibeErro(i)
                }
            }).done(n).fail(n)
        },
        verificaRetificacaoAutomatica: function(n) {
            var t = EmissaoDas.functions.obterParametrosEmissao();
            $.post($("#rootPath").val() + "Emissao/VerificaRetificacaoAutomatica", $.param(t, !0)).done(n).fail(function(n, t, i) {
                Utils.functions.exibeErro("Ocorreu um erro ao atualizar os valores.");
                console.log(t + ": " + i)
            })
        },
        obterParametrosPagarOnline: function() {
            var r = $("#anoSelecionado").val()
              , n = []
              , t = []
              , i = []
              , u = $("#dataPagamentoInformada").val();
            return $(".beneficioSelecionado:checked").each(function(t, i) {
                n.push($(i).val())
            }),
            $(".paSelecionado:checked").each(function(n, i) {
                t.push($(i).val())
            }),
            $(".quotasSelecionado:checked").each(function(n, t) {
                i.push($(t).val())
            }),
            {
                ano: r,
                listaQuotas: i,
                listaBeneficio: n,
                listaPA: t,
                dataConsolidacao: u
            }
        },
        obterParametrosEmissao: function() {
            let u = $("#anoSelecionado").val()
              , i = []
              , r = []
              , n = !1
              , t = !1;
            return $(".paSelecionado:checked").each(function(n, t) {
                r.push($(t).val())
            }),
            $(".beneficioSelecionado:checked").each(function(n, t) {
                i.push($(t).val())
            }),
            EmissaoDas.elements.chkPasEnabled.each(function(t, i) {
                n = $(i).data("aliquota-divergente") === "True" || n
            }),
            EmissaoDas.elements.chkPasEnabled.each(function(n, i) {
                t = $(i).data("valor-tributo-divergente") === "True" || t
            }),
            {
                ano: u,
                listaPA: r,
                listaBeneficio: i,
                aliquotaDivergente: n,
                valorTributoDivergente: t
            }
        },
        obterParametrosPagarOnlineConsulta: function(n) {
            var t = $("#anoCalendarioSelect").val();
            return {
                ano: t,
                numDas: n
            }
        },
        obterParametrosRecalculo: function() {
            let r = $("#anoSelecionado").val()
              , n = []
              , t = []
              , i = []
              , u = $("#dataPagamentoInformada").val();
            return $(".paSelecionado:checked").each(function(t, i) {
                n.push($(i).val())
            }),
            $(".quotasSelecionado:checked").each(function(n, i) {
                t.push($(i).val())
            }),
            $(".beneficioSelecionado:checked").each(function(n, t) {
                i.push($(t).val())
            }),
            {
                ano: r,
                listaQuotas: t,
                listaBeneficio: i,
                listaPA: n,
                dataConsolidacao: u
            }
        },
        checkPaSelecionado: function(n, t) {
            n.prop("checked", t);
            let r = n.parent()[0].rowSpan > 1
              , i = n.parent().parent();
            t ? (i.hasClass("warning") || i.addClass("warning"),
            !i.next().hasClass("warning") && r && i.next().addClass("warning")) : (i.removeClass("warning"),
            r && i.next().removeClass("warning"))
        },
        checkPaSelecionadoGrupo: function(n, t) {
            let f = n[0].value
              , i = n.data("grupo-pa")
              , r = n.data("aliquota-divergente") === "True"
              , u = n.data("valor-tributo-divergente") === "True";
            if (i !== "") {
                let n = i.split(",");
                n.forEach(function(n) {
                    let i = $('.paSelecionado[value="' + n + '"]').closest("tr").find(".beneficioSelecionado");
                    t = EmissaoDas.functions.travaCheckPaSelecionadoGrupo(i) || t;
                    t = r || u || t;
                    EmissaoDas.functions.checkPaSelecionado($('.paSelecionado[value="' + n + '"]'), t);
                    let f = i.data("grupo-beneficio");
                    f.split(",").forEach(function(i) {
                        i !== "" && i !== n && EmissaoDas.functions.checkPaSelecionado($('.paSelecionado[value="' + i + '"]'), t)
                    })
                })
            } else {
                let i = n.closest("tr").find(".beneficioSelecionado");
                t = EmissaoDas.functions.travaCheckPaSelecionadoGrupo(i) || t;
                t = r || u || t;
                EmissaoDas.functions.checkPaSelecionado(n, t)
            }
        },
        travaCheckPaSelecionadoGrupo: function(n) {
            let t = !1
              , i = n.data("grupo-beneficio");
            if (i !== "") {
                let n = i.split(",");
                n.forEach(function(n) {
                    t = EmissaoDas.functions.travaCheckPaSelecionado($('.beneficioSelecionado[value="' + n + '"]')) || t
                })
            } else
                t = EmissaoDas.functions.travaCheckPaSelecionado(n) || t;
            return t
        },
        travaCheckPaSelecionado: function(n) {
            let r = n.is(":checked")
              , u = n.data("benefico-apurado")
              , t = !1
              , i = u === "True";
            if (i) {
                let u = n.data("grupo-beneficio")
                  , f = n.closest("tr").find(".paSelecionado").data("grupo-pa");
                t = r !== i || u != f
            } else
                t = r !== i;
            return t && EmissaoDas.functions.checkPaSelecionado(n.closest("tr").find(".paSelecionado"), !0),
            t
        },
        acaoBotaoPagar: function() {
            var n = $(".beneficioSelecionado:checked");
            n.length === 0 ? EmissaoDas.elements.hidBeneficioAlterado.val().length >= "1" ? $("#btnPagarOnline").prop("disabled", !0) : $("#btnPagarOnline").prop("disabled", !1) : $("#btnPagarOnline").prop("disabled", !0)
        }
    },
    callbacks: {
        msgPagto: "Voc� � cliente do Banco do Brasil e possui acesso ao Internet Banking do referido Banco?",
        dataPagamentoInformadaOnChangeDate: function() {
            EmissaoDas.functions.atualizacaoPendente(!0)
        },
        btnEmitirDasOnClick: function(n) {
            let t = $(".paSelecionado:checked");
            if (t.length > 0)
                n.preventDefault(),
                EmissaoDas.elements.btnPagarOnline.prop("disabled", !0),
                EmissaoDas.functions.verificaRetificacaoAutomatica(function(n) {
                    let t = !1;
                    if (t = n && n === "YES",
                    t)
                        smoke.confirm("Voc� alterou uma informa��o j� declarada. Ser� entregue uma DASN-Simei retificadora de forma autom�tica. Confirma a altera��o?", function(n) {
                            if (n)
                                $(".quotasSelecionado:disabled").prop("disabled", !1),
                                $("#emissaoDas").submit();
                            else {
                                Ladda.stopAll();
                                return
                            }
                        }, {
                            ok: "Sim",
                            cancel: "N�o",
                            reverseButtons: !1
                        });
                    else
                        $(".quotasSelecionado:disabled").prop("disabled", !1),
                        $("#emissaoDas").submit()
                });
            else {
                Ladda.stopAll();
                n.preventDefault();
                EmissaoDas.elements.btnPagarOnline.prop("disabled", !1);
                Utils.functions.exibeErro("� necess�rio selecionar o(s) per�odo(s) para emiss�o do DAS.");
                return
            }
        },
        btnPagarOnlineOnClick: function(n) {
            var f = $(n.currentTarget), e = $("#btnEmitirDas"), t = $(".paSelecionado:checked"), i, r;
            if (t.length == 0)
                n.preventDefault(),
                Ladda.stopAll(),
                Utils.functions.exibeErro("� necess�rio selecionar um per�odo para pagar online.");
            else if (t.length == 1) {
                n.preventDefault();
                i = t[0].value;
                let u = EmissaoDas.elements.chkQuotas.filter(function() {
                    return this.value == i
                });
                if (u.prop("checked"))
                    n.preventDefault(),
                    Ladda.stopAll(),
                    Utils.functions.exibeErro("Selecionar apenas um �nico Per�odo de Apura��o sem Quotas.");
                else
                    try {
                        if (r = $($(".paSelecionado:checked")[0]).data("situacao"),
                        r == "1") {
                            Ladda.stopAll();
                            Utils.functions.exibeErro("Este DAS se encontra em situa��o de liquidado.");
                            return
                        }
                        smoke.confirm(EmissaoDas.callbacks.msgPagto, function(n) {
                            if (n)
                                EmissaoDas.functions.pagarOnline("DAS", "", function() {
                                    Ladda.stopAll()
                                });
                            else
                                return
                        }, {
                            ok: "Sim",
                            cancel: "N�o",
                            reverseButtons: !1
                        })
                    } catch (u) {
                        Ladda.stopAll();
                        Utils.functions.exibeErro("Ocorreu um erro ao pagar online.");
                        console.error(u)
                    }
            } else
                n.preventDefault(),
                Ladda.stopAll(),
                Utils.functions.exibeErro("Selecionar apenas um Per�odo de Apura��o para Pagar Online.")
        },
        btnAtualizarValoresOnClick: function(n) {
            n.preventDefault();
            let t = Ladda.create($("#btnAtualizarValores.ladda-button")[0]);
            try {
                t.start();
                EmissaoDas.functions.recalcular(function() {
                    t.stop();
                    let n = EmissaoDas.functions.countCheckSelecionadosPA();
                    n > 12 && EmissaoDas.functions.desmarcarTodosPas()
                })
            } catch (i) {
                t.stop();
                Utils.functions.exibeErro("Ocorreu um erro ao atualizar os valores.");
                console.error(i)
            }
        },
        chkSelecionarTodosOnChange: function() {
            let n = $(this).is(":checked");
            EmissaoDas.functions.selecionarTodosPas(n)
        },
        chkPasOnChange: function() {
            let n = $(this);
            if (EmissaoDas.functions.checkPaSelecionadoGrupo(n, n.is(":checked")),
            n.is(":checked") === !0) {
                let t = EmissaoDas.functions.countCheckSelecionadosPA();
                t > 12 && (EmissaoDas.functions.checkPaSelecionadoGrupo(n, !1),
                Utils.functions.exibeErro("Excedeu o limite de 12 Per�odos de Apura��o selecionados para emiss�o de DAS!"))
            }
        },
        chkQuotasOnChange: function() {
            let n = $(this)
              , t = EmissaoDas.elements.chkPasEnabled.filter(function() {
                return this.value == n[0].value
            });
            EmissaoDas.functions.checkPaSelecionadoGrupo(t, !0);
            EmissaoDas.functions.atualizacaoPendente(!0)
        },
        chkBeneficiosOnChange: function() {
            let t = $(this)
              , i = EmissaoDas.elements.chkPasEnabled.filter(function() {
                return this.value == t[0].value
            })
              , n = EmissaoDas.elements.chkQuotas.filter(function() {
                return this.value == t[0].value
            });
            if (t.is(":checked"))
                smoke.confirm('Voc� recebeu benef�cio de sal�rio-maternidade, aux�lio-doen�a ou aux�lio-reclus�o relativo ao(s) m�s(es) selecionado(s)? <br/>Aten��o: s� selecione "Sim" se o per�odo do benef�cio abranger o m�s inteiro (do primeiro ao �ltimo dia).', function(r) {
                    r ? (EmissaoDas.functions.atualizacaoPendente(!0),
                    n.data("pa-quota") && (n.prop("checked", !1),
                    n.prop("disabled", !0)),
                    EmissaoDas.functions.checkPaSelecionadoGrupo(i, !0)) : t.prop("checked", !1);
                    EmissaoDas.functions.acaoBotaoPagar()
                }, {
                    ok: "Sim",
                    cancel: "N�o",
                    reverseButtons: !1
                });
            else
                EmissaoDas.elements.hidBeneficioAlterado.val() !== "" && EmissaoDas.functions.atualizacaoPendente(!0),
                n.data("pa-quota") && n.prop("disabled", !1),
                EmissaoDas.functions.checkPaSelecionadoGrupo(i, !0),
                EmissaoDas.functions.acaoBotaoPagar()
        },
        lnkDasPagoOnClick: function(n) {
            n.preventDefault();
            var i = $(this).attr("data-numDas")
              , t = $("#rootPath").val();
            $.get(t + "Emissao/VerificaSessao", function(n) {
                n && n === "NO" ? window.location = t : $("#modal").load(t + "Consulta/DetalheDasPago?numDas=" + i, function(n, t, i) {
                    t === "error" ? (Utils.functions.exibeErro("Ocorreu um erro ao exibir os detalhes do pagamento."),
                    console.log("Erro: " + i.status + " " + i.statusText)) : $("#modal").modal()
                })
            })
        },
        lnkPagarOnlineOnClick: function(n) {
            n.preventDefault();
            var t = $(this).attr("data-numDas");
            smoke.confirm(EmissaoDas.callbacks.msgPagto, function(n) {
                if (n)
                    EmissaoDas.functions.pagarOnline("CONSULTA", t, function() {
                        $("#loadingPagar").hide()
                    });
                else
                    return
            }, {
                ok: "Sim",
                cancel: "N�o",
                reverseButtons: !1
            })
        }
    },
    bindingEvents: function() {
        if (EmissaoDas.elements.modalDetalhamentoDividaAtiva.length > 0 && EmissaoDas.elements.modalDetalhamentoDividaAtiva.modal({
            show: !0,
            backdrop: "static",
            keyboard: !1
        }),
        EmissaoDas.elements.dataPagamentoInformada.length > 0)
            EmissaoDas.elements.dataPagamentoInformada.on("changeDate", EmissaoDas.callbacks.dataPagamentoInformadaOnChangeDate);
        if (EmissaoDas.elements.btnEmitirDas.length > 0)
            EmissaoDas.elements.btnEmitirDas.on("click", EmissaoDas.callbacks.btnEmitirDasOnClick);
        if (EmissaoDas.elements.btnPagarOnline.length > 0)
            EmissaoDas.elements.btnPagarOnline.on("click", EmissaoDas.callbacks.btnPagarOnlineOnClick);
        if (EmissaoDas.elements.btnAtualizarValores.length > 0)
            EmissaoDas.elements.btnAtualizarValores.on("click", EmissaoDas.callbacks.btnAtualizarValoresOnClick);
        if (EmissaoDas.elements.chkSelecionarTodos.length > 0)
            EmissaoDas.elements.chkSelecionarTodos.on("change", EmissaoDas.callbacks.chkSelecionarTodosOnChange);
        if (EmissaoDas.elements.btnExibirDetalhes.length > 0)
            EmissaoDas.elements.btnExibirDetalhes.on("click", EmissaoDas.callbacks.btnExibirDetalhesOnClick);
        if (EmissaoDas.elements.chkPas.length > 0)
            EmissaoDas.elements.chkPas.on("change", EmissaoDas.callbacks.chkPasOnChange);
        if (EmissaoDas.elements.chkBeneficios.length > 0)
            EmissaoDas.elements.chkBeneficios.on("change", EmissaoDas.callbacks.chkBeneficiosOnChange);
        if (EmissaoDas.elements.chkQuotas.length > 0)
            EmissaoDas.elements.chkQuotas.on("change", EmissaoDas.callbacks.chkQuotasOnChange);
        if (EmissaoDas.elements.lnkDasPago.length > 0)
            EmissaoDas.elements.lnkDasPago.on("click", EmissaoDas.callbacks.lnkDasPagoOnClick);
        if (EmissaoDas.elements.lnkPagarOnline.length > 0)
            EmissaoDas.elements.lnkPagarOnline.on("click", EmissaoDas.callbacks.lnkPagarOnlineOnClick)
    }
};
(function() {
    function nt(t) {
        function r(n, i, r, u, f, e) {
            for (; f >= 0 && e > f; f += t) {
                var o = u ? u[f] : f;
                r = i(r, n[o], o, n)
            }
            return r
        }
        return function(u, f, o, s) {
            f = e(f, s, 4);
            var h = !i(u) && n.keys(u)
              , l = (h || u).length
              , c = t > 0 ? 0 : l - 1;
            return arguments.length < 3 && (o = u[h ? h[c] : c],
            c += t),
            r(u, f, o, h, c, l)
        }
    }
    function tt(n) {
        return function(i, r, f) {
            r = t(r, f);
            for (var o = u(i), e = n > 0 ? 0 : o - 1; e >= 0 && o > e; e += n)
                if (r(i[e], e, i))
                    return e;
            return -1
        }
    }
    function it(t, i, f) {
        return function(e, o, s) {
            var c = 0
              , h = u(e);
            if ("number" == typeof s)
                t > 0 ? c = s >= 0 ? s : Math.max(s + h, c) : h = s >= 0 ? Math.min(s + 1, h) : s + h + 1;
            else if (f && s && h)
                return s = f(e, o),
                e[s] === o ? s : -1;
            if (o !== o)
                return s = i(r.call(e, c, h), n.isNaN),
                s >= 0 ? s + c : -1;
            for (s = t > 0 ? c : h - 1; s >= 0 && h > s; s += t)
                if (e[s] === o)
                    return s;
            return -1
        }
    }
    function rt(t, i) {
        var u = d.length
          , f = t.constructor
          , e = n.isFunction(f) && f.prototype || v
          , r = "constructor";
        for (n.has(t, r) && !n.contains(i, r) && i.push(r); u--; )
            r = d[u],
            r in t && t[r] !== e[r] && !n.contains(i, r) && i.push(r)
    }
    var a = this, lt = a._, s = Array.prototype, v = Object.prototype, at = Function.prototype, vt = s.push, r = s.slice, o = v.toString, yt = v.hasOwnProperty, pt = Array.isArray, ut = Object.keys, y = at.bind, ft = Object.create, p = function() {}, n = function(t) {
        return t instanceof n ? t : this instanceof n ? void (this._wrapped = t) : new n(t)
    }, e, t, h, f, b, k, d, c, ct, l;
    "undefined" != typeof exports ? ("undefined" != typeof module && module.exports && (exports = module.exports = n),
    exports._ = n) : a._ = n;
    n.VERSION = "1.8.3";
    e = function(n, t, i) {
        if (t === void 0)
            return n;
        switch (null == i ? 3 : i) {
        case 1:
            return function(i) {
                return n.call(t, i)
            }
            ;
        case 2:
            return function(i, r) {
                return n.call(t, i, r)
            }
            ;
        case 3:
            return function(i, r, u) {
                return n.call(t, i, r, u)
            }
            ;
        case 4:
            return function(i, r, u, f) {
                return n.call(t, i, r, u, f)
            }
        }
        return function() {
            return n.apply(t, arguments)
        }
    }
    ;
    t = function(t, i, r) {
        return null == t ? n.identity : n.isFunction(t) ? e(t, i, r) : n.isObject(t) ? n.matcher(t) : n.property(t)
    }
    ;
    n.iteratee = function(n, i) {
        return t(n, i, 1 / 0)
    }
    ;
    var w = function(n, t) {
        return function(i) {
            var e = arguments.length, r, u;
            if (2 > e || null == i)
                return i;
            for (r = 1; e > r; r++)
                for (var o = arguments[r], s = n(o), h = s.length, f = 0; h > f; f++)
                    u = s[f],
                    t && i[u] !== void 0 || (i[u] = o[u]);
            return i
        }
    }
      , et = function(t) {
        if (!n.isObject(t))
            return {};
        if (ft)
            return ft(t);
        p.prototype = t;
        var i = new p;
        return p.prototype = null,
        i
    }
      , ot = function(n) {
        return function(t) {
            if (null != t)
                return t[n]
        }
    }
      , wt = Math.pow(2, 53) - 1
      , u = ot("length")
      , i = function(n) {
        var t = u(n);
        return "number" == typeof t && t >= 0 && wt >= t
    };
    n.each = n.forEach = function(t, r, u) {
        var f, o, s;
        if (r = e(r, u),
        i(t))
            for (f = 0,
            o = t.length; o > f; f++)
                r(t[f], f, t);
        else
            for (s = n.keys(t),
            f = 0,
            o = s.length; o > f; f++)
                r(t[s[f]], s[f], t);
        return t
    }
    ;
    n.map = n.collect = function(r, u, f) {
        var s;
        u = t(u, f);
        for (var o = !i(r) && n.keys(r), h = (o || r).length, c = Array(h), e = 0; h > e; e++)
            s = o ? o[e] : e,
            c[e] = u(r[s], s, r);
        return c
    }
    ;
    n.reduce = n.foldl = n.inject = nt(1);
    n.reduceRight = n.foldr = nt(-1);
    n.find = n.detect = function(t, r, u) {
        var f;
        return f = i(t) ? n.findIndex(t, r, u) : n.findKey(t, r, u),
        f !== void 0 && f !== -1 ? t[f] : void 0
    }
    ;
    n.filter = n.select = function(i, r, u) {
        var f = [];
        return r = t(r, u),
        n.each(i, function(n, t, i) {
            r(n, t, i) && f.push(n)
        }),
        f
    }
    ;
    n.reject = function(i, r, u) {
        return n.filter(i, n.negate(t(r)), u)
    }
    ;
    n.every = n.all = function(r, u, f) {
        var s;
        u = t(u, f);
        for (var o = !i(r) && n.keys(r), h = (o || r).length, e = 0; h > e; e++)
            if (s = o ? o[e] : e,
            !u(r[s], s, r))
                return !1;
        return !0
    }
    ;
    n.some = n.any = function(r, u, f) {
        var s;
        u = t(u, f);
        for (var o = !i(r) && n.keys(r), h = (o || r).length, e = 0; h > e; e++)
            if (s = o ? o[e] : e,
            u(r[s], s, r))
                return !0;
        return !1
    }
    ;
    n.contains = n.includes = n.include = function(t, r, u, f) {
        return i(t) || (t = n.values(t)),
        ("number" != typeof u || f) && (u = 0),
        n.indexOf(t, r, u) >= 0
    }
    ;
    n.invoke = function(t, i) {
        var u = r.call(arguments, 2)
          , f = n.isFunction(i);
        return n.map(t, function(n) {
            var t = f ? i : n[i];
            return null == t ? t : t.apply(n, u)
        })
    }
    ;
    n.pluck = function(t, i) {
        return n.map(t, n.property(i))
    }
    ;
    n.where = function(t, i) {
        return n.filter(t, n.matcher(i))
    }
    ;
    n.findWhere = function(t, i) {
        return n.find(t, n.matcher(i))
    }
    ;
    n.max = function(r, u, f) {
        var h, o, e = -1 / 0, c = -1 / 0, s, l;
        if (null == u && null != r)
            for (r = i(r) ? r : n.values(r),
            s = 0,
            l = r.length; l > s; s++)
                h = r[s],
                h > e && (e = h);
        else
            u = t(u, f),
            n.each(r, function(n, t, i) {
                o = u(n, t, i);
                (o > c || o === -1 / 0 && e === -1 / 0) && (e = n,
                c = o)
            });
        return e
    }
    ;
    n.min = function(r, u, f) {
        var h, o, e = 1 / 0, c = 1 / 0, s, l;
        if (null == u && null != r)
            for (r = i(r) ? r : n.values(r),
            s = 0,
            l = r.length; l > s; s++)
                h = r[s],
                e > h && (e = h);
        else
            u = t(u, f),
            n.each(r, function(n, t, i) {
                o = u(n, t, i);
                (c > o || 1 / 0 === o && 1 / 0 === e) && (e = n,
                c = o)
            });
        return e
    }
    ;
    n.shuffle = function(t) {
        for (var u, e = i(t) ? t : n.values(t), o = e.length, f = Array(o), r = 0; o > r; r++)
            u = n.random(0, r),
            u !== r && (f[r] = f[u]),
            f[u] = e[r];
        return f
    }
    ;
    n.sample = function(t, r, u) {
        return null == r || u ? (i(t) || (t = n.values(t)),
        t[n.random(t.length - 1)]) : n.shuffle(t).slice(0, Math.max(0, r))
    }
    ;
    n.sortBy = function(i, r, u) {
        return r = t(r, u),
        n.pluck(n.map(i, function(n, t, i) {
            return {
                value: n,
                index: t,
                criteria: r(n, t, i)
            }
        }).sort(function(n, t) {
            var i = n.criteria
              , r = t.criteria;
            if (i !== r) {
                if (i > r || i === void 0)
                    return 1;
                if (r > i || r === void 0)
                    return -1
            }
            return n.index - t.index
        }), "value")
    }
    ;
    h = function(i) {
        return function(r, u, f) {
            var e = {};
            return u = t(u, f),
            n.each(r, function(n, t) {
                var f = u(n, t, r);
                i(e, n, f)
            }),
            e
        }
    }
    ;
    n.groupBy = h(function(t, i, r) {
        n.has(t, r) ? t[r].push(i) : t[r] = [i]
    });
    n.indexBy = h(function(n, t, i) {
        n[i] = t
    });
    n.countBy = h(function(t, i, r) {
        n.has(t, r) ? t[r]++ : t[r] = 1
    });
    n.toArray = function(t) {
        return t ? n.isArray(t) ? r.call(t) : i(t) ? n.map(t, n.identity) : n.values(t) : []
    }
    ;
    n.size = function(t) {
        return null == t ? 0 : i(t) ? t.length : n.keys(t).length
    }
    ;
    n.partition = function(i, r, u) {
        r = t(r, u);
        var f = []
          , e = [];
        return n.each(i, function(n, t, i) {
            (r(n, t, i) ? f : e).push(n)
        }),
        [f, e]
    }
    ;
    n.first = n.head = n.take = function(t, i, r) {
        if (null != t)
            return null == i || r ? t[0] : n.initial(t, t.length - i)
    }
    ;
    n.initial = function(n, t, i) {
        return r.call(n, 0, Math.max(0, n.length - (null == t || i ? 1 : t)))
    }
    ;
    n.last = function(t, i, r) {
        if (null != t)
            return null == i || r ? t[t.length - 1] : n.rest(t, Math.max(0, t.length - i))
    }
    ;
    n.rest = n.tail = n.drop = function(n, t, i) {
        return r.call(n, null == t || i ? 1 : t)
    }
    ;
    n.compact = function(t) {
        return n.filter(t, n.identity)
    }
    ;
    f = function(t, r, e, o) {
        for (var s, l, a, h = [], v = 0, c = o || 0, y = u(t); y > c; c++)
            if (s = t[c],
            i(s) && (n.isArray(s) || n.isArguments(s)))
                for (r || (s = f(s, r, e)),
                l = 0,
                a = s.length,
                h.length += a; a > l; )
                    h[v++] = s[l++];
            else
                e || (h[v++] = s);
        return h
    }
    ;
    n.flatten = function(n, t) {
        return f(n, t, !1)
    }
    ;
    n.without = function(t) {
        return n.difference(t, r.call(arguments, 1))
    }
    ;
    n.uniq = n.unique = function(i, r, f, e) {
        var o, c;
        n.isBoolean(r) || (e = f,
        f = r,
        r = !1);
        null != f && (f = t(f, e));
        for (var s = [], l = [], h = 0, a = u(i); a > h; h++)
            o = i[h],
            c = f ? f(o, h, i) : o,
            r ? (h && l === c || s.push(o),
            l = c) : f ? n.contains(l, c) || (l.push(c),
            s.push(o)) : n.contains(s, o) || s.push(o);
        return s
    }
    ;
    n.union = function() {
        return n.uniq(f(arguments, !0, !0))
    }
    ;
    n.intersection = function(t) {
        for (var r, i, f = [], o = arguments.length, e = 0, s = u(t); s > e; e++)
            if (r = t[e],
            !n.contains(f, r)) {
                for (i = 1; o > i && n.contains(arguments[i], r); i++)
                    ;
                i === o && f.push(r)
            }
        return f
    }
    ;
    n.difference = function(t) {
        var i = f(arguments, !0, !0, 1);
        return n.filter(t, function(t) {
            return !n.contains(i, t)
        })
    }
    ;
    n.zip = function() {
        return n.unzip(arguments)
    }
    ;
    n.unzip = function(t) {
        for (var r = t && n.max(t, u).length || 0, f = Array(r), i = 0; r > i; i++)
            f[i] = n.pluck(t, i);
        return f
    }
    ;
    n.object = function(n, t) {
        for (var r = {}, i = 0, f = u(n); f > i; i++)
            t ? r[n[i]] = t[i] : r[n[i][0]] = n[i][1];
        return r
    }
    ;
    n.findIndex = tt(1);
    n.findLastIndex = tt(-1);
    n.sortedIndex = function(n, i, r, f) {
        var o;
        r = t(r, f, 1);
        for (var h = r(i), e = 0, s = u(n); s > e; )
            o = Math.floor((e + s) / 2),
            r(n[o]) < h ? e = o + 1 : s = o;
        return e
    }
    ;
    n.indexOf = it(1, n.findIndex, n.sortedIndex);
    n.lastIndexOf = it(-1, n.findLastIndex);
    n.range = function(n, t, i) {
        null == t && (t = n || 0,
        n = 0);
        i = i || 1;
        for (var u = Math.max(Math.ceil((t - n) / i), 0), f = Array(u), r = 0; u > r; r++,
        n += i)
            f[r] = n;
        return f
    }
    ;
    b = function(t, i, r, u, f) {
        if (!(u instanceof i))
            return t.apply(r, f);
        var e = et(t.prototype)
          , o = t.apply(e, f);
        return n.isObject(o) ? o : e
    }
    ;
    n.bind = function(t, i) {
        if (y && t.bind === y)
            return y.apply(t, r.call(arguments, 1));
        if (!n.isFunction(t))
            throw new TypeError("Bind must be called on a function");
        var f = r.call(arguments, 2)
          , u = function() {
            return b(t, u, i, this, f.concat(r.call(arguments)))
        };
        return u
    }
    ;
    n.partial = function(t) {
        var i = r.call(arguments, 1)
          , u = function() {
            for (var f = 0, o = i.length, e = Array(o), r = 0; o > r; r++)
                e[r] = i[r] === n ? arguments[f++] : i[r];
            for (; f < arguments.length; )
                e.push(arguments[f++]);
            return b(t, u, this, this, e)
        };
        return u
    }
    ;
    n.bindAll = function(t) {
        var i, r, u = arguments.length;
        if (1 >= u)
            throw new Error("bindAll must be passed function names");
        for (i = 1; u > i; i++)
            r = arguments[i],
            t[r] = n.bind(t[r], t);
        return t
    }
    ;
    n.memoize = function(t, i) {
        var r = function(u) {
            var f = r.cache
              , e = "" + (i ? i.apply(this, arguments) : u);
            return n.has(f, e) || (f[e] = t.apply(this, arguments)),
            f[e]
        };
        return r.cache = {},
        r
    }
    ;
    n.delay = function(n, t) {
        var i = r.call(arguments, 2);
        return setTimeout(function() {
            return n.apply(null, i)
        }, t)
    }
    ;
    n.defer = n.partial(n.delay, n, 1);
    n.throttle = function(t, i, r) {
        var f, e, s, u = null, o = 0, h;
        return r || (r = {}),
        h = function() {
            o = r.leading === !1 ? 0 : n.now();
            u = null;
            s = t.apply(f, e);
            u || (f = e = null)
        }
        ,
        function() {
            var l = n.now(), c;
            return o || r.leading !== !1 || (o = l),
            c = i - (l - o),
            f = this,
            e = arguments,
            0 >= c || c > i ? (u && (clearTimeout(u),
            u = null),
            o = l,
            s = t.apply(f, e),
            u || (f = e = null)) : u || r.trailing === !1 || (u = setTimeout(h, c)),
            s
        }
    }
    ;
    n.debounce = function(t, i, r) {
        var u, f, e, s, o, h = function() {
            var c = n.now() - s;
            i > c && c >= 0 ? u = setTimeout(h, i - c) : (u = null,
            r || (o = t.apply(e, f),
            u || (e = f = null)))
        };
        return function() {
            e = this;
            f = arguments;
            s = n.now();
            var c = r && !u;
            return u || (u = setTimeout(h, i)),
            c && (o = t.apply(e, f),
            e = f = null),
            o
        }
    }
    ;
    n.wrap = function(t, i) {
        return n.partial(i, t)
    }
    ;
    n.negate = function(n) {
        return function() {
            return !n.apply(this, arguments)
        }
    }
    ;
    n.compose = function() {
        var n = arguments
          , t = n.length - 1;
        return function() {
            for (var r = t, i = n[t].apply(this, arguments); r--; )
                i = n[r].call(this, i);
            return i
        }
    }
    ;
    n.after = function(n, t) {
        return function() {
            if (--n < 1)
                return t.apply(this, arguments)
        }
    }
    ;
    n.before = function(n, t) {
        var i;
        return function() {
            return --n > 0 && (i = t.apply(this, arguments)),
            1 >= n && (t = null),
            i
        }
    }
    ;
    n.once = n.partial(n.before, 2);
    k = !{
        toString: null
    }.propertyIsEnumerable("toString");
    d = ["valueOf", "isPrototypeOf", "toString", "propertyIsEnumerable", "hasOwnProperty", "toLocaleString"];
    n.keys = function(t) {
        var i, r;
        if (!n.isObject(t))
            return [];
        if (ut)
            return ut(t);
        i = [];
        for (r in t)
            n.has(t, r) && i.push(r);
        return k && rt(t, i),
        i
    }
    ;
    n.allKeys = function(t) {
        var i, r;
        if (!n.isObject(t))
            return [];
        i = [];
        for (r in t)
            i.push(r);
        return k && rt(t, i),
        i
    }
    ;
    n.values = function(t) {
        for (var r = n.keys(t), u = r.length, f = Array(u), i = 0; u > i; i++)
            f[i] = t[r[i]];
        return f
    }
    ;
    n.mapObject = function(i, r, u) {
        r = t(r, u);
        for (var f, o = n.keys(i), h = o.length, s = {}, e = 0; h > e; e++)
            f = o[e],
            s[f] = r(i[f], f, i);
        return s
    }
    ;
    n.pairs = function(t) {
        for (var r = n.keys(t), u = r.length, f = Array(u), i = 0; u > i; i++)
            f[i] = [r[i], t[r[i]]];
        return f
    }
    ;
    n.invert = function(t) {
        for (var u = {}, r = n.keys(t), i = 0, f = r.length; f > i; i++)
            u[t[r[i]]] = r[i];
        return u
    }
    ;
    n.functions = n.methods = function(t) {
        var i = [];
        for (var r in t)
            n.isFunction(t[r]) && i.push(r);
        return i.sort()
    }
    ;
    n.extend = w(n.allKeys);
    n.extendOwn = n.assign = w(n.keys);
    n.findKey = function(i, r, u) {
        r = t(r, u);
        for (var f, o = n.keys(i), e = 0, s = o.length; s > e; e++)
            if (f = o[e],
            r(i[f], f, i))
                return f
    }
    ;
    n.pick = function(t, i, r) {
        var c, o, l = {}, u = t, s, v, h, a;
        if (null == u)
            return l;
        for (n.isFunction(i) ? (o = n.allKeys(u),
        c = e(i, r)) : (o = f(arguments, !1, !1, 1),
        c = function(n, t, i) {
            return t in i
        }
        ,
        u = Object(u)),
        s = 0,
        v = o.length; v > s; s++)
            h = o[s],
            a = u[h],
            c(a, h, u) && (l[h] = a);
        return l
    }
    ;
    n.omit = function(t, i, r) {
        if (n.isFunction(i))
            i = n.negate(i);
        else {
            var u = n.map(f(arguments, !1, !1, 1), String);
            i = function(t, i) {
                return !n.contains(u, i)
            }
        }
        return n.pick(t, i, r)
    }
    ;
    n.defaults = w(n.allKeys, !0);
    n.create = function(t, i) {
        var r = et(t);
        return i && n.extendOwn(r, i),
        r
    }
    ;
    n.clone = function(t) {
        return n.isObject(t) ? n.isArray(t) ? t.slice() : n.extend({}, t) : t
    }
    ;
    n.tap = function(n, t) {
        return t(n),
        n
    }
    ;
    n.isMatch = function(t, i) {
        var e = n.keys(i), o = e.length, f, r, u;
        if (null == t)
            return !o;
        for (f = Object(t),
        r = 0; o > r; r++)
            if (u = e[r],
            i[u] !== f[u] || !(u in f))
                return !1;
        return !0
    }
    ;
    c = function(t, i, r, u) {
        var h, a, e, s, f, l, v;
        if (t === i)
            return 0 !== t || 1 / t == 1 / i;
        if (null == t || null == i)
            return t === i;
        if (t instanceof n && (t = t._wrapped),
        i instanceof n && (i = i._wrapped),
        h = o.call(t),
        h !== o.call(i))
            return !1;
        switch (h) {
        case "[object RegExp]":
        case "[object String]":
            return "" + t == "" + i;
        case "[object Number]":
            return +t != +t ? +i != +i : 0 == +t ? 1 / +t == 1 / i : +t == +i;
        case "[object Date]":
        case "[object Boolean]":
            return +t == +i
        }
        if (a = "[object Array]" === h,
        !a && ("object" != typeof t || "object" != typeof i || (e = t.constructor,
        s = i.constructor,
        e !== s && !(n.isFunction(e) && e instanceof e && n.isFunction(s) && s instanceof s) && "constructor"in t && "constructor"in i)))
            return !1;
        for (r = r || [],
        u = u || [],
        f = r.length; f--; )
            if (r[f] === t)
                return u[f] === i;
        if (r.push(t),
        u.push(i),
        a) {
            if (f = t.length,
            f !== i.length)
                return !1;
            for (; f--; )
                if (!c(t[f], i[f], r, u))
                    return !1
        } else {
            if (v = n.keys(t),
            f = v.length,
            n.keys(i).length !== f)
                return !1;
            for (; f--; )
                if (l = v[f],
                !n.has(i, l) || !c(t[l], i[l], r, u))
                    return !1
        }
        return r.pop(),
        u.pop(),
        !0
    }
    ;
    n.isEqual = function(n, t) {
        return c(n, t)
    }
    ;
    n.isEmpty = function(t) {
        return null == t ? !0 : i(t) && (n.isArray(t) || n.isString(t) || n.isArguments(t)) ? 0 === t.length : 0 === n.keys(t).length
    }
    ;
    n.isElement = function(n) {
        return !(!n || 1 !== n.nodeType)
    }
    ;
    n.isArray = pt || function(n) {
        return "[object Array]" === o.call(n)
    }
    ;
    n.isObject = function(n) {
        var t = typeof n;
        return "function" === t || "object" === t && !!n
    }
    ;
    n.each(["Arguments", "Function", "String", "Number", "Date", "RegExp", "Error"], function(t) {
        n["is" + t] = function(n) {
            return o.call(n) === "[object " + t + "]"
        }
    });
    n.isArguments(arguments) || (n.isArguments = function(t) {
        return n.has(t, "callee")
    }
    );
    "function" != typeof /./ && "object" != typeof Int8Array && (n.isFunction = function(n) {
        return "function" == typeof n || !1
    }
    );
    n.isFinite = function(n) {
        return isFinite(n) && !isNaN(parseFloat(n))
    }
    ;
    n.isNaN = function(t) {
        return n.isNumber(t) && t !== +t
    }
    ;
    n.isBoolean = function(n) {
        return n === !0 || n === !1 || "[object Boolean]" === o.call(n)
    }
    ;
    n.isNull = function(n) {
        return null === n
    }
    ;
    n.isUndefined = function(n) {
        return n === void 0
    }
    ;
    n.has = function(n, t) {
        return null != n && yt.call(n, t)
    }
    ;
    n.noConflict = function() {
        return a._ = lt,
        this
    }
    ;
    n.identity = function(n) {
        return n
    }
    ;
    n.constant = function(n) {
        return function() {
            return n
        }
    }
    ;
    n.noop = function() {}
    ;
    n.property = ot;
    n.propertyOf = function(n) {
        return null == n ? function() {}
        : function(t) {
            return n[t]
        }
    }
    ;
    n.matcher = n.matches = function(t) {
        return t = n.extendOwn({}, t),
        function(i) {
            return n.isMatch(i, t)
        }
    }
    ;
    n.times = function(n, t, i) {
        var u = Array(Math.max(0, n)), r;
        for (t = e(t, i, 1),
        r = 0; n > r; r++)
            u[r] = t(r);
        return u
    }
    ;
    n.random = function(n, t) {
        return null == t && (t = n,
        n = 0),
        n + Math.floor(Math.random() * (t - n + 1))
    }
    ;
    n.now = Date.now || function() {
        return (new Date).getTime()
    }
    ;
    var st = {
        "&": "&amp;",
        "<": "&lt;",
        ">": "&gt;",
        '"': "&quot;",
        "'": "&#x27;",
        "`": "&#x60;"
    }
      , bt = n.invert(st)
      , ht = function(t) {
        var r = function(n) {
            return t[n]
        }
          , i = "(?:" + n.keys(t).join("|") + ")"
          , u = RegExp(i)
          , f = RegExp(i, "g");
        return function(n) {
            return n = null == n ? "" : "" + n,
            u.test(n) ? n.replace(f, r) : n
        }
    };
    n.escape = ht(st);
    n.unescape = ht(bt);
    n.result = function(t, i, r) {
        var u = null == t ? void 0 : t[i];
        return u === void 0 && (u = r),
        n.isFunction(u) ? u.call(t) : u
    }
    ;
    ct = 0;
    n.uniqueId = function(n) {
        var t = ++ct + "";
        return n ? n + t : t
    }
    ;
    n.templateSettings = {
        evaluate: /<%([\s\S]+?)%>/g,
        interpolate: /<%=([\s\S]+?)%>/g,
        escape: /<%-([\s\S]+?)%>/g
    };
    var g = /(.)^/
      , kt = {
        "'": "'",
        "\\": "\\",
        "\r": "r",
        "\n": "n",
        "\u2028": "u2028",
        "\u2029": "u2029"
    }
      , dt = /\\|'|\r|\n|\u2028|\u2029/g
      , gt = function(n) {
        return "\\" + kt[n]
    };
    n.template = function(t, i, r) {
        var o, f, h;
        !i && r && (i = r);
        i = n.defaults({}, i, n.templateSettings);
        var c = RegExp([(i.escape || g).source, (i.interpolate || g).source, (i.evaluate || g).source].join("|") + "|$", "g")
          , e = 0
          , u = "__p+='";
        t.replace(c, function(n, i, r, f, o) {
            return u += t.slice(e, o).replace(dt, gt),
            e = o + n.length,
            i ? u += "'+\n((__t=(" + i + "))==null?'':_.escape(__t))+\n'" : r ? u += "'+\n((__t=(" + r + "))==null?'':__t)+\n'" : f && (u += "';\n" + f + "\n__p+='"),
            n
        });
        u += "';\n";
        i.variable || (u = "with(obj||{}){\n" + u + "}\n");
        u = "var __t,__p='',__j=Array.prototype.join,print=function(){__p+=__j.call(arguments,'');};\n" + u + "return __p;\n";
        try {
            o = new Function(i.variable || "obj","_",u)
        } catch (s) {
            throw s.source = u,
            s;
        }
        return f = function(t) {
            return o.call(this, t, n)
        }
        ,
        h = i.variable || "obj",
        f.source = "function(" + h + "){\n" + u + "}",
        f
    }
    ;
    n.chain = function(t) {
        var i = n(t);
        return i._chain = !0,
        i
    }
    ;
    l = function(t, i) {
        return t._chain ? n(i).chain() : i
    }
    ;
    n.mixin = function(t) {
        n.each(n.functions(t), function(i) {
            var r = n[i] = t[i];
            n.prototype[i] = function() {
                var t = [this._wrapped];
                return vt.apply(t, arguments),
                l(this, r.apply(n, t))
            }
        })
    }
    ;
    n.mixin(n);
    n.each(["pop", "push", "reverse", "shift", "sort", "splice", "unshift"], function(t) {
        var i = s[t];
        n.prototype[t] = function() {
            var n = this._wrapped;
            return i.apply(n, arguments),
            "shift" !== t && "splice" !== t || 0 !== n.length || delete n[0],
            l(this, n)
        }
    });
    n.each(["concat", "join", "slice"], function(t) {
        var i = s[t];
        n.prototype[t] = function() {
            return l(this, i.apply(this._wrapped, arguments))
        }
    });
    n.prototype.value = function() {
        return this._wrapped
    }
    ;
    n.prototype.valueOf = n.prototype.toJSON = n.prototype.value;
    n.prototype.toString = function() {
        return "" + this._wrapped
    }
    ;
    "function" == typeof define && define.amd && define("underscore", [], function() {
        return n
    })
}
).call(this),
function() {
    var n = {
        smoketimeout: [],
        init: !1,
        zindex: 1e3,
        i: 0,
        bodyload: function(t) {
            var i = document.createElement("div");
            i.setAttribute("id", "smoke-out-" + t);
            i.className = "smoke-base";
            i.style.zIndex = n.zindex;
            n.zindex++;
            document.body.appendChild(i)
        },
        newdialog: function() {
            var t = (new Date).getTime()
              , t = Math.random(1, 99) + t;
            return n.init ? n.bodyload(t) : n.listen(window, "load", function() {
                n.bodyload(t)
            }),
            t
        },
        forceload: function() {},
        build: function(t, i) {
            n.i++;
            i.stack = n.i;
            t = t.replace(/\n/g, "<br />");
            t = t.replace(/\r/g, "<br />");
            var o = "", u = "OK", f = "Cancel", s = "", r = "", e;
            "prompt" === i.type && (o = '<div class="dialog-prompt"><input id="dialog-input-' + i.newid + '" type="text" ' + (i.params.value ? 'value="' + i.params.value + '"' : "") + " /><\/div>");
            i.params.ok && (u = i.params.ok);
            i.params.cancel && (f = i.params.cancel);
            i.params.classname && (s = i.params.classname);
            "signal" !== i.type && (r = '<div class="dialog-buttons">',
            "alert" === i.type ? r += '<button id="alert-ok-' + i.newid + '">' + u + "<\/button>" : "quiz" === i.type ? (i.params.button_1 && (r += '<button class="quiz-button" id="' + i.type + "-ok1-" + i.newid + '">' + i.params.button_1 + "<\/button>"),
            i.params.button_2 && (r += '<button class="quiz-button" id="' + i.type + "-ok2-" + i.newid + '">' + i.params.button_2 + "<\/button>"),
            i.params.button_3 && (r += '<button class="quiz-button" id="' + i.type + "-ok3-" + i.newid + '">' + i.params.button_3 + "<\/button>"),
            i.params.button_cancel && (r += '<button id="' + i.type + "-cancel-" + i.newid + '" class="cancel">' + i.params.button_cancel + "<\/button>")) : ("prompt" === i.type || "confirm" === i.type) && (r = i.params.reverseButtons ? r + ('<button id="' + i.type + "-ok-" + i.newid + '">' + u + '<\/button><button id="' + i.type + "-cancel-" + i.newid + '" class="cancel">' + f + "<\/button>") : r + ('<button id="' + i.type + "-cancel-" + i.newid + '" class="cancel">' + f + '<\/button><button id="' + i.type + "-ok-" + i.newid + '">' + u + "<\/button>")),
            r += "<\/div>");
            e = '<div id="smoke-bg-' + i.newid + '" class="smokebg"><\/div><div class="dialog smoke ' + s + '"><div class="dialog-inner">' + t + o + r + "<\/div><\/div>";
            n.init ? n.finishbuild(t, i, e) : n.listen(window, "load", function() {
                n.finishbuild(t, i, e)
            })
        },
        finishbuild: function(t, i, r) {
            var u = document.getElementById("smoke-out-" + i.newid);
            for (u.className = "smoke-base smoke-visible  smoke-" + i.type,
            u.innerHTML = r; "" === u.innerHTML; )
                u.innerHTML = r;
            n.smoketimeout[i.newid] && clearTimeout(n.smoketimeout[i.newid]);
            n.listen(document.getElementById("smoke-bg-" + i.newid), "click", function() {});
            switch (i.type) {
            case "alert":
                n.finishbuildAlert(t, i, r);
                break;
            case "confirm":
                n.finishbuildConfirm(t, i, r);
                break;
            case "quiz":
                n.finishbuildQuiz(t, i, r);
                break;
            case "prompt":
                n.finishbuildPrompt(t, i, r);
                break;
            case "signal":
                n.finishbuildSignal(t, i, r);
                break;
            default:
                throw "Unknown type: " + i.type;
            }
        },
        finishbuildAlert: function(t, i) {
            n.listen(document.getElementById("alert-ok-" + i.newid), "click", function() {
                n.destroy(i.type, i.newid);
                "undefined" != typeof i.callback && i.callback()
            });
            document.onkeyup = function(t) {
                t || (t = window.event);
                (13 === t.keyCode || 32 === t.keyCode || 27 === t.keyCode) && (n.destroy(i.type, i.newid),
                "undefined" != typeof i.callback && i.callback())
            }
        },
        finishbuildConfirm: function(t, i) {
            n.listen(document.getElementById("confirm-cancel-" + i.newid), "click", function() {
                n.destroy(i.type, i.newid);
                i.callback(!1)
            });
            n.listen(document.getElementById("confirm-ok-" + i.newid), "click", function() {
                n.destroy(i.type, i.newid);
                i.callback(!0)
            });
            document.onkeyup = function(t) {
                t || (t = window.event);
                13 === t.keyCode || 32 === t.keyCode ? (n.destroy(i.type, i.newid),
                i.callback(!0)) : 27 === t.keyCode && (n.destroy(i.type, i.newid),
                i.callback(!1))
            }
        },
        finishbuildQuiz: function(t, i) {
            n.listen(document.getElementById("quiz-cancel-" + i.newid), "click", function() {
                n.destroy(i.type, i.newid);
                i.callback(!1)
            });
            (a = document.getElementById("quiz-ok1-" + i.newid)) && n.listen(a, "click", function() {
                n.destroy(i.type, i.newid);
                i.callback(a.innerHTML)
            });
            (b = document.getElementById("quiz-ok2-" + i.newid)) && n.listen(b, "click", function() {
                n.destroy(i.type, i.newid);
                i.callback(b.innerHTML)
            });
            (c = document.getElementById("quiz-ok3-" + i.newid)) && n.listen(c, "click", function() {
                n.destroy(i.type, i.newid);
                i.callback(c.innerHTML)
            });
            document.onkeyup = function(t) {
                t || (t = window.event);
                27 === t.keyCode && (n.destroy(i.type, i.newid),
                i.callback(!1))
            }
        },
        finishbuildPrompt: function(t, i) {
            var r = document.getElementById("dialog-input-" + i.newid);
            setTimeout(function() {
                r.focus();
                r.select()
            }, 100);
            n.listen(document.getElementById("prompt-cancel-" + i.newid), "click", function() {
                n.destroy(i.type, i.newid);
                i.callback(!1)
            });
            n.listen(document.getElementById("prompt-ok-" + i.newid), "click", function() {
                n.destroy(i.type, i.newid);
                i.callback(r.value)
            });
            document.onkeyup = function(t) {
                t || (t = window.event);
                13 === t.keyCode ? (n.destroy(i.type, i.newid),
                i.callback(r.value)) : 27 === t.keyCode && (n.destroy(i.type, i.newid),
                i.callback(!1))
            }
        },
        finishbuildSignal: function(t, i) {
            document.onkeyup = function(t) {
                t || (t = window.event);
                27 === t.keyCode && (n.destroy(i.type, i.newid),
                "undefined" != typeof i.callback && i.callback())
            }
            ;
            n.smoketimeout[i.newid] = setTimeout(function() {
                n.destroy(i.type, i.newid);
                "undefined" != typeof i.callback && i.callback()
            }, i.timeout)
        },
        destroy: function(t, i) {
            var e = document.getElementById("smoke-out-" + i), f, r, u;
            if ("quiz" !== t && (r = document.getElementById(t + "-ok-" + i)),
            f = document.getElementById(t + "-cancel-" + i),
            e.className = "smoke-base",
            r && (n.stoplistening(r, "click", function() {}),
            document.onkeyup = null),
            "quiz" === t)
                for (r = document.getElementsByClassName("quiz-button"),
                u = 0; u < r.length; u++)
                    n.stoplistening(r[u], "click", function() {}),
                    document.onkeyup = null;
            f && n.stoplistening(f, "click", function() {});
            n.i = 0;
            e.innerHTML = ""
        },
        alert: function(t, i, r) {
            "object" != typeof r && (r = !1);
            var u = n.newdialog();
            n.build(t, {
                type: "alert",
                callback: i,
                params: r,
                newid: u
            })
        },
        signal: function(t, i, r) {
            var u, f;
            "object" != typeof r && (r = !1);
            u = 5e3;
            "undefined" !== r.duration && (u = r.duration);
            f = n.newdialog();
            n.build(t, {
                type: "signal",
                callback: i,
                timeout: u,
                params: r,
                newid: f
            })
        },
        confirm: function(t, i, r) {
            "object" != typeof r && (r = !1);
            var u = n.newdialog();
            n.build(t, {
                type: "confirm",
                callback: i,
                params: r,
                newid: u
            })
        },
        quiz: function(t, i, r) {
            "object" != typeof r && (r = !1);
            var u = n.newdialog();
            n.build(t, {
                type: "quiz",
                callback: i,
                params: r,
                newid: u
            })
        },
        prompt: function(t, i, r) {
            "object" != typeof r && (r = !1);
            var u = n.newdialog();
            return n.build(t, {
                type: "prompt",
                callback: i,
                params: r,
                newid: u
            })
        },
        listen: function(n, t, i) {
            return n.addEventListener ? n.addEventListener(t, i, !1) : n.attachEvent ? n.attachEvent("on" + t, i) : !1
        },
        stoplistening: function(n, t, i) {
            return n.removeEventListener ? n.removeEventListener("click", i, !1) : n.detachEvent ? n.detachEvent("on" + t, i) : !1
        },
        init: !0
    };
    "undefined" != typeof module && module.exports ? module.exports = n : "function" == typeof define && define.amd ? define(n) : this.smoke = n
}(),
function(n, t) {
    function o(n) {
        return !!("" === n || n && n.charCodeAt && n.substr)
    }
    function u(n) {
        return v ? v(n) : "[object Array]" === y.call(n)
    }
    function s(n) {
        return "[object Object]" === y.call(n)
    }
    function h(n, t) {
        var i, n = n || {}, t = t || {};
        for (i in t)
            t.hasOwnProperty(i) && null == n[i] && (n[i] = t[i]);
        return n
    }
    function r(n, t, i) {
        var u = [], r, f;
        if (!n)
            return u;
        if (a && n.map === a)
            return n.map(t, i);
        for (r = 0,
        f = n.length; r < f; r++)
            u[r] = t.call(i, n[r], r, n);
        return u
    }
    function f(n, t) {
        return n = Math.round(Math.abs(n)),
        isNaN(n) ? t : n
    }
    function l(n) {
        var t = i.settings.currency.format;
        return "function" == typeof n && (n = n()),
        o(n) && n.match("%v") ? {
            pos: n,
            neg: n.replace("-", "").replace("%v", "-%v"),
            zero: n
        } : !n || !n.pos || !n.pos.match("%v") ? o(t) ? i.settings.currency.format = {
            pos: t,
            neg: t.replace("%v", "-%v"),
            zero: t
        } : t : n
    }
    var i = {
        version: "0.4.1",
        settings: {
            currency: {
                symbol: "$",
                format: "%s%v",
                decimal: ".",
                thousand: ",",
                precision: 2,
                grouping: 3
            },
            number: {
                precision: 0,
                grouping: 3,
                thousand: ",",
                decimal: "."
            }
        }
    }
      , a = Array.prototype.map
      , v = Array.isArray
      , y = Object.prototype.toString
      , e = i.unformat = i.parse = function(n, t) {
        if (u(n))
            return r(n, function(n) {
                return e(n, t)
            });
        if (n = n || 0,
        "number" == typeof n)
            return n;
        var t = t || "."
          , i = RegExp("[^0-9-" + t + "]", ["g"])
          , i = parseFloat(("" + n).replace(/\((.*)\)/, "-$1").replace(i, "").replace(t, "."));
        return isNaN(i) ? 0 : i
    }
      , p = i.toFixed = function(n, t) {
        var t = f(t, i.settings.number.precision)
          , r = Math.pow(10, t);
        return (Math.round(i.unformat(n) * r) / r).toFixed(t)
    }
      , c = i.formatNumber = i.format = function(n, t, o, l) {
        if (u(n))
            return r(n, function(n) {
                return c(n, t, o, l)
            });
        var n = e(n)
          , a = h(s(t) ? t : {
            precision: t,
            thousand: o,
            decimal: l
        }, i.settings.number)
          , y = f(a.precision)
          , b = 0 > n ? "-" : ""
          , v = parseInt(p(Math.abs(n || 0), y), 10) + ""
          , w = 3 < v.length ? v.length % 3 : 0;
        return b + (w ? v.substr(0, w) + a.thousand : "") + v.substr(w).replace(/(\d{3})(?=\d)/g, "$1" + a.thousand) + (y ? a.decimal + p(Math.abs(n), y).split(".")[1] : "")
    }
      , w = i.formatMoney = function(n, t, o, a, v, y) {
        if (u(n))
            return r(n, function(n) {
                return w(n, t, o, a, v, y)
            });
        var n = e(n)
          , p = h(s(t) ? t : {
            symbol: t,
            precision: o,
            thousand: a,
            decimal: v,
            format: y
        }, i.settings.currency)
          , b = l(p.format);
        return (0 < n ? b.pos : 0 > n ? b.neg : b.zero).replace("%s", p.symbol).replace("%v", c(Math.abs(n), f(p.precision), p.thousand, p.decimal))
    }
    ;
    i.formatColumn = function(n, t, a, v, y, p) {
        if (!n)
            return [];
        var w = h(s(t) ? t : {
            symbol: t,
            precision: a,
            thousand: v,
            decimal: y,
            format: p
        }, i.settings.currency)
          , b = l(w.format)
          , d = b.pos.indexOf("%s") < b.pos.indexOf("%v") ? !0 : !1
          , k = 0
          , n = r(n, function(n) {
            return u(n) ? i.formatColumn(n, w) : (n = e(n),
            n = (0 < n ? b.pos : 0 > n ? b.neg : b.zero).replace("%s", w.symbol).replace("%v", c(Math.abs(n), f(w.precision), w.thousand, w.decimal)),
            n.length > k && (k = n.length),
            n)
        });
        return r(n, function(n) {
            return o(n) && n.length < k ? d ? n.replace(w.symbol, w.symbol + Array(k - n.length + 1).join(" ")) : Array(k - n.length + 1).join(" ") + n : n
        })
    }
    ;
    "undefined" != typeof exports ? ("undefined" != typeof module && module.exports && (exports = module.exports = i),
    exports.accounting = i) : "function" == typeof define && define.amd ? define([], function() {
        return i
    }) : (i.noConflict = function(r) {
        return function() {
            return n.accounting = r,
            i.noConflict = t,
            i
        }
    }(n.accounting),
    n.accounting = i)
}(this)
