<?php
// Caminhos para os arquivos JSON
$dataFilePath = 'data.json';
$visitasFilePath = 'visitas.json';

try {
    // Limpar o conteúdo do arquivo data.json
    file_put_contents($dataFilePath, json_encode([]));
    
    // Limpar o conteúdo do arquivo visitas.json
    file_put_contents($visitasFilePath, json_encode([]));
    
    // Retornar sucesso se ambos os arquivos forem limpos
    http_response_code(200);
    echo json_encode(["message" => "Dados apagados com sucesso."]);
} catch (Exception $e) {
    // Se ocorrer algum erro, retornar o código de erro e a mensagem
    http_response_code(500);
    echo json_encode(["error" => "Erro ao apagar os dados: " . $e->getMessage()]);
}
?>
