<?php

// Função para limpar e validar o CNPJ
function limparCNPJ($cnpj) {
    // Remove caracteres não numéricos
    return preg_replace('/\D/', '', $cnpj);
}

// Verifica se o CNPJ foi passado na URL
if (isset($_GET['cnpj'])) {
    // Obtém o CNPJ enviado via URL
    $cnpj = limparCNPJ($_GET['cnpj']);
    
    // Verifica se o CNPJ é válido (você pode adicionar validação aqui)
    if (strlen($cnpj) != 14) {
        echo json_encode(['success' => false, 'message' => 'CNPJ inválido.']);
        exit;
    }

    // URL da API que consulta os dados do CNPJ
    $url = "https://www.receitaws.com.br/v1/cnpj/$cnpj";

    // Inicializa a sessão cURL
    $ch = curl_init();

    // Configurações do cURL
    curl_setopt($ch, CURLOPT_URL, $url); // URL da API
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // Retorna a resposta como string
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Desativa a verificação SSL (caso a API não tenha certificado válido)

    // Executa a requisição
    $response = curl_exec($ch);

    // Verifica se houve erro
    if(curl_errno($ch)) {
        echo json_encode(['success' => false, 'message' => 'Erro ao fazer a requisição à API.']);
        exit;
    }

    // Fecha a sessão cURL
    curl_close($ch);

    // Converte a resposta JSON da API para array
    $dadosApi = json_decode($response, true);

    // Verifica se a consulta foi bem-sucedida
    if ($dadosApi && isset($dadosApi['status']) && $dadosApi['status'] == 'OK') {
        // Retorna os dados recebidos da API para o frontend
        echo json_encode([
            'success' => true,
            'dados' => $dadosApi, // Dados do CNPJ
        ]);
    } else {
        // Caso não tenha sido possível recuperar os dados
        echo json_encode(['success' => false, 'message' => 'Não foi possível recuperar os dados para este CNPJ.']);
    }

} else {
    // Caso o CNPJ não tenha sido passado
    echo json_encode(['success' => false, 'message' => 'CNPJ não informado.']);
}

?>
