<?php
session_start();
header('Content-Type: application/json');

// Segurança extra
header('X-Content-Type-Options: nosniff');
header('X-Frame-Options: DENY');
header('X-XSS-Protection: 1; mode=block');

// Configuração do banco (ajuste se necessário)
$dbHost = "localhost";
$dbUsername = "yzrgwpbvxr_spacepix";
$dbPassword = "B@963852j";
$dbName = "yzrgwpbvxr_space";

$usuario = trim($_POST['usuario'] ?? '');
$senha = trim($_POST['senha'] ?? '');

if (empty($usuario) || empty($senha)) {
    echo json_encode(['success' => false, 'error' => 'Preencha usuário e senha.']);
    exit;
}

try {
    $pdo = new PDO("mysql:host=$dbHost;dbname=$dbName;charset=utf8", $dbUsername, $dbPassword, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
    ]);

    // Busca o usuário
    $stmt = $pdo->prepare("SELECT id, usuario, senha FROM usuario WHERE usuario = :usuario LIMIT 1");
    $stmt->bindParam(':usuario', $usuario);
    $stmt->execute();
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$user) {
        echo json_encode(['success' => false, 'error' => 'Usuário não encontrado.']);
        exit;
    }

    // Verifica senha com hash seguro (bcrypt)
    if (password_verify($senha, $user['senha']) || $senha === $user['senha']) {
        $_SESSION['autenticado'] = true;
        $_SESSION['usuario'] = $usuario;

        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'error' => 'Senha incorreta.']);
    }

} catch (PDOException $e) {
    echo json_encode(['success' => false, 'error' => 'Erro no banco de dados.']);
}
