<?php
session_start();
header('Content-Type: text/html; charset=utf-8');

// Configuração do banco
$dbHost = "localhost";
$dbUsername = "yzrgwpbvxr_spacepix";
$dbPassword = "B@963852j";
$dbName = "yzrgwpbvxr_space";

try {
    $pdo = new PDO("mysql:host=$dbHost;dbname=$dbName;charset=utf8", $dbUsername, $dbPassword, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
    ]);
} catch (PDOException $e) {
    die("Erro na conexão com o banco de dados: " . $e->getMessage());
}

// Quando o formulário é enviado
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $usuario = trim($_POST['usuario'] ?? '');
    $senha = trim($_POST['senha'] ?? '');

    if (empty($usuario) || empty($senha)) {
        $mensagem = "Preencha todos os campos.";
    } else {
        try {
            // Verifica se o usuário já existe
            $check = $pdo->prepare("SELECT id FROM usuario WHERE usuario = :usuario");
            $check->bindParam(':usuario', $usuario);
            $check->execute();

            if ($check->rowCount() > 0) {
                $mensagem = "⚠️ Usuário já existe.";
            } else {
                // Criptografa a senha
                $senhaHash = password_hash($senha, PASSWORD_BCRYPT);

                // Insere no banco
                $insert = $pdo->prepare("INSERT INTO usuario (usuario, senha) VALUES (:usuario, :senha)");
                $insert->bindParam(':usuario', $usuario);
                $insert->bindParam(':senha', $senhaHash);
                $insert->execute();

                $mensagem = "✅ Usuário cadastrado com sucesso!";
            }
        } catch (PDOException $e) {
            $mensagem = "Erro ao cadastrar: " . $e->getMessage();
        }
    }
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Cadastrar Usuário</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f2f6fc;
            display: flex;
            align-items: center;
            justify-content: center;
            height: 100vh;
        }
        .card {
            background: white;
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.15);
            width: 350px;
        }
        h2 {
            text-align: center;
            color: #0c326f;
        }
        label {
            display: block;
            margin-bottom: 5px;
            color: #333;
            font-weight: 600;
        }
        input {
            width: 100%;
            padding: 10px;
            border-radius: 6px;
            border: 1px solid #ccc;
            margin-bottom: 15px;
        }
        button {
            width: 100%;
            background: #1351B4;
            color: white;
            border: none;
            padding: 10px;
            border-radius: 6px;
            font-size: 16px;
            cursor: pointer;
        }
        button:hover {
            background: #0c326f;
        }
        .mensagem {
            margin-top: 15px;
            text-align: center;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="card">
        <h2>Cadastro de Usuário</h2>
        <form method="POST" action="">
            <label for="usuario">Usuário:</label>
            <input type="text" id="usuario" name="usuario" required>

            <label for="senha">Senha:</label>
            <input type="password" id="senha" name="senha" required>

            <button type="submit">Cadastrar</button>
        </form>

        <?php if (!empty($mensagem)): ?>
            <div class="mensagem"><?= htmlspecialchars($mensagem) ?></div>
        <?php endif; ?>
    </div>
</body>
</html>
