// Adiciona a classe 'hovered' ao item selecionado da lista
let list = document.querySelectorAll(".navigation li");

function activeLink() {
  list.forEach((item) => {
    item.classList.remove("hovered");
  });
  this.classList.add("hovered");
}

list.forEach((item) => item.addEventListener("mouseover", activeLink));

// Menu Toggle
let toggle = document.querySelector(".toggle");
let navigation = document.querySelector(".navigation");
let main = document.querySelector(".main");
let logo = document.querySelector(".navigation .logo-img"); // Seleciona a imagem do logo

toggle.onclick = function () {
  // Alterna a classe 'active' na navegação e no conteúdo principal
  navigation.classList.toggle("active");
  main.classList.toggle("active");

  // Alterna a visibilidade da imagem do logo
  if (navigation.classList.contains("active")) {
    logo.style.display = "none"; // Oculta o logo quando o menu está aberto
  } else {
    logo.style.display = "block"; // Exibe o logo quando o menu está fechado
  }
};
